package edu.montana.csci.csci468.parser.statements;

import edu.montana.csci.csci468.bytecode.ByteCodeGenerator;
import edu.montana.csci.csci468.eval.CatscriptRuntime;
import edu.montana.csci.csci468.parser.SymbolTable;
import edu.montana.csci.csci468.parser.expressions.Expression;
import org.eclipse.jetty.websocket.common.OpCode;
import org.objectweb.asm.Opcodes;

import java.util.List;

public class PrintStatement extends Statement {
    private Expression expression;

    public void setExpression(Expression parseExpression) {
        this.expression = addChild(parseExpression);
    }


    public Expression getExpression() {
        return expression;
    }

    @Override
    public void validate(SymbolTable symbolTable) {
        expression.validate(symbolTable);
    }

    //==============================================================
    // Implementation
    //==============================================================
    @Override
    public List<Statement> execute(CatscriptRuntime runtime) {
        getProgram().print(expression.evaluate(runtime));
        return null;
    }

    @Override
    public void transpile(StringBuilder javascript) {
        super.transpile(javascript);
    }

    @Override
    public void compile(ByteCodeGenerator code) {

        //This pointer is added to the operand stack
        code.addVarInstruction(Opcodes.ALOAD, 0);
        expression.compile(code);

        box(code, expression.getType());
        code.addMethodInstruction(Opcodes.INVOKEVIRTUAL, code.getProgramInternalName(),
                "print", "(Ljava/lang/Object;)V");


    }

}
