package edu.montana.csci.csci468.parser.statements;

import edu.montana.csci.csci468.bytecode.ByteCodeGenerator;
import edu.montana.csci.csci468.eval.CatscriptRuntime;
import edu.montana.csci.csci468.parser.CatscriptType;
import edu.montana.csci.csci468.parser.ErrorType;
import edu.montana.csci.csci468.parser.SymbolTable;
import edu.montana.csci.csci468.parser.expressions.Expression;
import org.objectweb.asm.Opcodes;

import java.util.List;

public class VariableStatement extends Statement {
    private Expression expression;
    private String variableName;
    private CatscriptType explicitType;
    private CatscriptType type;

    public Expression getExpression() {
        return expression;
    }

    public String getVariableName() {
        return variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public void setExpression(Expression parseExpression) {
        this.expression = addChild(parseExpression);
    }

    public void setExplicitType(CatscriptType type) {
        this.explicitType = type;
    }

    public CatscriptType getExplicitType() {
        return explicitType;
    }

    public boolean isGlobal() {
        return getParent() instanceof CatScriptProgram;
    }

    @Override
    public void validate(SymbolTable symbolTable) {
        expression.validate(symbolTable);
        if (symbolTable.hasSymbol(variableName)) {
            addError(ErrorType.DUPLICATE_NAME);
        } else {
            if(explicitType != null){
                type = explicitType;

            }
            else{
                type = expression.getType();
            }
            symbolTable.registerSymbol(variableName, type);
        }


    }

    public CatscriptType getType() {
        return type;
    }

    //==============================================================
    // Implementation
    //==============================================================
    @Override
    public List<Statement> execute(CatscriptRuntime runtime) {

        Object value = getExpression().evaluate(runtime);
        runtime.setValue(variableName,value);

        return null;
    }

    @Override
    public void transpile(StringBuilder javascript) {
        super.transpile(javascript);
    }

    @Override
    public void compile(ByteCodeGenerator code) {

        if (isGlobal()) {
            //Create a field w/ given name
            code.addFieldInstruction(Opcodes.PUTFIELD, code.getProgramInternalName(),variableName,
                    "(Ljava/lang/Object;)V");

            //Push the this pointer
            code.addVarInstruction(Opcodes.ALOAD, 0);

            //Compile the expression
            expression.compile(code);
            //save the expression to the field

            code.addFieldInstruction(Opcodes.PUTFIELD, code.getProgramInternalName(),variableName,
                    "(Ljava/lang/Object;)V" );
        }
        else{
            Integer slot = code.createLocalStorageSlotFor(variableName);
            code.addVarInstruction(Opcodes.ALOAD,slot);

        }

    }
}
