package edu.montana.csci.csci468.demo;

import edu.montana.csci.csci468.CatscriptTestBase;
import edu.montana.csci.csci468.parser.CatscriptType;
import edu.montana.csci.csci468.parser.ErrorType;
import edu.montana.csci.csci468.parser.expressions.*;
import edu.montana.csci.csci468.parser.statements.CatScriptProgram;
import edu.montana.csci.csci468.parser.statements.PrintStatement;
import org.junit.jupiter.api.Test;
import static org.junit.jupiter.api.Assertions.*;

public class PartnerTest extends CatscriptTestBase {

    @Test
    //Test comparison operators for proper symbol recognition and return type
    public void testParseComparisonOperators() {

        //Testing less than operator
        ComparisonExpression lessThanExpr = parseExpression("10 < 5"); //Parse expression
        assertTrue(lessThanExpr.isLessThan()); //Check if symbol recognized
        assertEquals(CatscriptType.BOOLEAN, lessThanExpr.getType()); //Check if our return type is boolean

        //Testing less than equal operator
        ComparisonExpression lessThanEqualExpr = parseExpression("10 <= 5"); //Parse expression
        assertTrue(lessThanEqualExpr.isLessThanOrEqual()); //Check if symbol recognized
        assertEquals(CatscriptType.BOOLEAN, lessThanExpr.getType()); //Check if our return type is boolean

        //Testing greater than operator
        ComparisonExpression greaterThanExpr = parseExpression("10 > 5"); //Parse expression
        assertTrue(greaterThanExpr.isGreater()); //Check if symbol recognized
        assertEquals(CatscriptType.BOOLEAN, greaterThanExpr.getType()); //Check if our return type is boolean

        //Testing greater than equal operator
        ComparisonExpression greaterThanEqualExpr = parseExpression("10 >= 5"); //Parse expression
        assertTrue(greaterThanEqualExpr.isGreaterThanOrEqual()); //Check if symbol recognized
        assertEquals(CatscriptType.BOOLEAN, greaterThanEqualExpr.getType()); //Check if our return type is boolean
    }

    @Test
    //Test print statement parsing and evaluation
    public void printStatementTesting() {

        //Testing parsing
        PrintStatement expr = parseStatement("print(5)"); //Parse int 5
        assertNotNull(expr); //Check if null

        //Testing closure error catch
        PrintStatement errorExpr = parseStatement("print(5", false); //Test unclosed print statement
        assertNotNull(errorExpr); //Check if null
        assertTrue(errorExpr.hasErrors()); //Assert that an error was thrown

        //Print type checking
        assertEquals("5\n", executeProgram("print(5)")); //Int
        assertEquals("-5\n", executeProgram("print(-5)")); //Negative Int
        assertEquals("true\n", executeProgram("print(true)")); //Boolean true
        assertEquals("false\n", executeProgram("print(false)")); //Boolean false
        assertEquals("stringTest\n", executeProgram("print(\"stringTest\")")); //Basic string test
        assertEquals("string test with spaces\n", executeProgram("print(\"string test with spaces\")")); //String with spaces
    }


    @Test
    //Testing factor expression parsing and evaluation
    public void factorExpressionTesting(){

        //Multiplication
        FactorExpression expr = parseExpression("10 * 5"); //Parse expression
        assertTrue(expr.isMultiply()); //Check if a multiplication type
        assertEquals(50, evaluateExpression("10 * 5")); //Check for proper evaluation

        //Division
        FactorExpression divisionExpr = parseExpression("10 / 5"); //Parse expression
        assertFalse(divisionExpr.isMultiply()); //Check if multiplication type
        assertEquals(2, evaluateExpression("10 / 5")); //Check for proper evaluation

        //Precedence testing
        AdditiveExpression  precedenceTestExpr = parseExpression("10 * 5 + 10 / 5"); //Parse expression
        assertTrue(precedenceTestExpr.isAdd()); //Check for additive expression
        assertTrue(precedenceTestExpr.getLeftHandSide() instanceof FactorExpression); //Check that left side of additive is a factor
        assertTrue(precedenceTestExpr.getRightHandSide() instanceof FactorExpression); //Check that right side of additive is a factor

        //Left association testing
        FactorExpression associationTestExpr = parseExpression("10 * 5 * 10"); //Parse expression
        assertTrue(associationTestExpr.isMultiply()); //Check for multiplication expression
        assertTrue(associationTestExpr.getLeftHandSide() instanceof FactorExpression); //Check that left side is a factor
        assertTrue(associationTestExpr.getRightHandSide() instanceof IntegerLiteralExpression); //Check that right side is integer

        //Evaluation edge case testing
        assertEquals(100, evaluateExpression("10 * 5 * 2")); //2 Multiplications
        assertEquals(1, evaluateExpression("10 / 5 / 2")); //2 Divisions
        assertEquals(1000000, evaluateExpression("1000 * 10 * 10 * 10")); //3 Multiplications
        assertEquals(1, evaluateExpression("1000 / 10 / 10 / 10")); //3 Divisions
        assertEquals(25, evaluateExpression("10 * 5 / 2")); //Symbol mixing
        assertEquals(4, evaluateExpression("10 / 5 * 2")); //Symbol mixing
    }
}
