package edu.montana.csci.csci468.parser.expressions;

import edu.montana.csci.csci468.bytecode.ByteCodeGenerator;
import edu.montana.csci.csci468.eval.CatscriptRuntime;
import edu.montana.csci.csci468.parser.CatscriptType;
import edu.montana.csci.csci468.parser.SymbolTable;
import edu.montana.csci.csci468.tokenizer.Token;
import edu.montana.csci.csci468.tokenizer.TokenType;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;

import static edu.montana.csci.csci468.tokenizer.TokenType.*;

public class EqualityExpression extends Expression {

    private final Token operator;
    private final Expression leftHandSide;
    private final Expression rightHandSide;

    public EqualityExpression(Token operator, Expression leftHandSide, Expression rightHandSide) {
        this.leftHandSide = addChild(leftHandSide);
        this.rightHandSide = addChild(rightHandSide);
        this.operator = operator;
    }

    public Expression getLeftHandSide() {
        return leftHandSide;
    }

    public Expression getRightHandSide() {
        return rightHandSide;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + operator.getStringValue() + "]";
    }

    public boolean isEqual() {
        return operator.getType().equals(TokenType.EQUAL_EQUAL);
    }

    @Override
    public void validate(SymbolTable symbolTable) {
        leftHandSide.validate(symbolTable);
        rightHandSide.validate(symbolTable);
    }

    @Override
    public CatscriptType getType() {
        return CatscriptType.BOOLEAN;
    }

    //==============================================================
    // Implementation
    //==============================================================

    @Override
    public Object evaluate(CatscriptRuntime runtime) {
        Object l = this.leftHandSide.evaluate(runtime);
        Object r = this.rightHandSide.evaluate(runtime);

        if (l == null && r == null && this.operator.getType() == EQUAL_EQUAL) {
            return true;
        }

        if ((l == null || r == null) && this.operator.getType() == BANG_EQUAL) {
            return true;
        }



        if (l.getClass() == Integer.class) {
            if ((int)l == 1) l =true;
            else l = false;
        } else {
            l = (boolean)l;
        }

        if (r.getClass() == Integer.class) {
            if ((int)r == 1) r =true;
            else r = false;
        } else {
            r = (boolean)r;
        }

        if (this.operator.getType() == EQUAL_EQUAL) {
            return this.leftHandSide.evaluate(runtime) == this.rightHandSide.evaluate(runtime);
        } else if (this.operator.getType() == BANG_EQUAL) {
            return this.leftHandSide.evaluate(runtime) != this.rightHandSide.evaluate(runtime);
        }
        return super.evaluate(runtime);
    }

    @Override
    public void transpile(StringBuilder javascript) {
        super.transpile(javascript);
    }

    @Override
    public void compile(ByteCodeGenerator code) {
        getLeftHandSide().compile(code);
        getRightHandSide().compile(code);

        Label trueLabel = new Label();
        Label falseLabel = new Label();


        if (isEqual()) {
            code.addJumpInstruction(Opcodes.IF_ICMPEQ, trueLabel);
        } else {
            code.addJumpInstruction(Opcodes.IF_ICMPNE, trueLabel);
        }


        code.pushConstantOntoStack(false);
        code.addJumpInstruction(Opcodes.GOTO, falseLabel);
        code.addLabel(trueLabel);
        code.pushConstantOntoStack(true);
        code.addLabel(falseLabel);
    }


}
