package edu.montana.csci.csci468.parser;

import edu.montana.csci.csci468.parser.statements.FunctionDefinitionStatement;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class SymbolTable {

    LinkedList<Map<String, Object>> symbolStack = new LinkedList<>();

    public SymbolTable(){
        HashMap<String, Object> globalScope = new HashMap<>();
        symbolStack.push(globalScope);
    }

    public boolean hasSymbol(String name) {
        return getSymbol(name) != null;
    }

    private Object getSymbol(String name) {
        for (Map<String, Object> next : symbolStack) {
            Object val = next.get(name);
            if (val != null) {
                return val;
            }
        }
        return null;
    }

    public void registerFunction(String name, FunctionDefinitionStatement func) {
        symbolStack.peek().put(name, func);
    }

    public void registerSymbol(String name, CatscriptType type) {
        symbolStack.peek().put(name, type);
    }

    public boolean isSymbolGlobal(String name) {
        if (symbolStack.isEmpty()) {
            return false;
        } else {
            return symbolStack.get(symbolStack.size() - 1).containsKey(name);
        }
    }

    public CatscriptType getSymbolType(String name) {
        Object object = getSymbol(name);
        if (object instanceof CatscriptType) {
            return (CatscriptType) object;
        } else {
            return null;
        }
    }

    public FunctionDefinitionStatement getFunction(String name) {
        Object object = getSymbol(name);
        if (object instanceof FunctionDefinitionStatement) {
            return (FunctionDefinitionStatement) object;
        } else {
            return null;
        }
    }

    public void pushScope() {
        symbolStack.push(new HashMap<>());
    }

    public void popScope() {
        symbolStack.pop();
    }
}
