import numpy
import pandas

import sklearn.metrics
from PIL import Image, ImageFilter
from sklearn.svm import SVC

import matplotlib.pyplot as plt


def get_number_of_edge_pixels(img):
    """
    Returns the number of pixels which are detected as an edge of the given image.

    :param img: image which is processed
    :return number of pixels which are detected as an edge
    """

    """
    PROVIDED METHOD: Example for custom image processing logic to improve the prediction score
    """

    # Edges are in grayscale
    pixel_map = img.filter(ImageFilter.FIND_EDGES).load()

    # Save space for the new image
    white_count = 0
    for x in range(img.size[0]):
        for y in range(img.size[1]):
            if pixel_map[x, y][0] >= 100:
                # Less the the middle (127) to improve the contouring pixels
                white_count = white_count + 1

    return white_count


def read_data_set_from_csv(csv_path, max_row_count=None):
    """
    Read the data set from the csv file which is accessible at the given path and return two arrays.
    The first array should contain the image data of the images of the data set.
    The second array should contain the classifications of the images in string format.

    The max_row_count parameter is used to limit the number of returned entries from the data set. This might be
    useful for testing, since the training of classifiers takes much longer for a high number of entries.

    :param csv_path:      Path to the csv file describing the data set which is loaded
    :param max_row_count: Maximum number of data set entries which are returned
    :return: Tuple containing the image data array and the classification string array
    """

    """
    TODO: Implement the functionality
    
    HINT: You can use the pandas library in order to read the data inside the csv file.
    HINT: You should use the python image library PIL to read the data of the images
    """


def get_classifier_input_for_image(img):
    """
    Convert to given image to an appropriate format which can be passed to a classifier and return it.
    The meaningfulness of the returned data can be increased, by applying filters to the image.

    :param img: Image which is converted to an appropriate format
    :return: data for the given image which can be passed to a classifier
    """

    """  
    TODO: Concatenating the data of your image with one or more filtered versions of the image might increase your 
          prediction accuracy
          
    HINT: You do not have to change this method, if you do not want to increase your prediction accuracy
    """

    # get the data of the image as one dimensional array
    img_array = numpy.array(img).flatten()

    # get the data of the resulting image after applying an edge filter as one dimensional array
    edge_array = numpy.array(img.filter(ImageFilter.FIND_EDGES)).flatten()

    # extract the number of pixels which are detected as an edge and store it into an array
    white_array = numpy.array([get_number_of_edge_pixels(img)])

    # concatenate the one dimensional arrays
    return numpy.concatenate([img_array])  # add filtered versions of the image here


def plot_predictions(images, predicted_classifications, correct_classifications):
    """
    Plot a figure containing at least 10 images, together with their predicted classifications.
    The classification is shown in green if it is correct, and red if it isn't.
        
    Additionally, display a bar chart which visualizes the accuracy of the predicted classifications.

    :param images:                    This is the array of images, that must be showed
    :param predicted_classifications: There is the list of all the predictions of the images
    :param correct_classifications:   There are the correct values of prediction of the data
    """

    """
    TODO : Plot a figure containing at least 10 images, together with their predicted classifications and a bar chart
           which visualizes the accuracy of the predictions.
    
    HINT: You might use the 'figsize' parameter of the 'figure()' function, to adjust the size of your figure
    HINT: You might use the 'subplot()' function for displaying a set of images in one figure
    HINT: You might use the 'axis()' function, to hide the axes for the image subplots
    HINT: You might use the 'color' parameter of the 'title()' function
    HINT: You might use the 'subplot2grid()' function with the 'rowspan' and 'colspan' parameters to create a bar chart 
          with a custom size
    """


def main():
    # load the training data set and the test data set
    training_images, training_classifications = read_data_set_from_csv('training.csv', 1000)
    test_images, test_classifications = read_data_set_from_csv('test.csv')

    # convert the images of the data sets to an appropriate format for the classifier
    training_classifier_image_input = numpy.frompyfunc(get_classifier_input_for_image, 1, 1)(training_images)
    test_classifier_image_input = numpy.frompyfunc(get_classifier_input_for_image, 1, 1)(test_images)

    """
    TODO: Instantiate a classifier and train it with the data from the training data set.
    
    HINT: You can try different types of classifiers classifiers, but we suggest to stick with a classifier of the 
          type SVC, KNeighborsClassifier or RandomForestClassifier.
    HINT: Don't forget to import the appropriate library at the beginning of the file
    """
    classifier = None

    """
    TODO: Predict the classifications for the images of the test data set with your trained classifier.
          Save the predicted classifications to a variable named "predicted_classifications"
    """
    predicted_classifications = None

    """
    TODO: Print a classification report which includes the percentage of correct predicted classifications
    
    HINT: You might use provided methods in the sklearn.metrics package, to generate such a report
    """
    classification_report = None
    print(classification_report)

    # plot images with their predicted classifications and an accuracy bar chart
    plot_predictions(test_images, predicted_classifications, test_classifications)


if __name__ == "__main__":
    main()
