/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.SynchronousChannel;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PooledExecutor
extends ThreadFactoryUser
implements Executor {
    public static final int DEFAULT_MAXIMUMPOOLSIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_MINIMUMPOOLSIZE = 1;
    public static final long DEFAULT_KEEPALIVETIME = 60000L;
    protected volatile int maximumPoolSize_ = Integer.MAX_VALUE;
    protected volatile int minimumPoolSize_ = 1;
    protected long keepAliveTime_ = 60000L;
    protected final Channel handOff_;
    protected Object poolLock_ = new Object();
    protected volatile int poolSize_ = 0;
    protected final Map threads_;
    protected BlockedExecutionHandler blockedExecutionHandler_;

    public PooledExecutor() {
        this(new SynchronousChannel(), Integer.MAX_VALUE);
    }

    public PooledExecutor(int maxPoolSize) {
        this(new SynchronousChannel(), maxPoolSize);
    }

    public PooledExecutor(Channel channel) {
        this(channel, Integer.MAX_VALUE);
    }

    public PooledExecutor(Channel channel, int maxPoolSize) {
        this.maximumPoolSize_ = maxPoolSize;
        this.handOff_ = channel;
        this.runWhenBlocked();
        this.threads_ = new HashMap();
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize_;
    }

    public void setMaximumPoolSize(int newMaximum) {
        if (newMaximum <= 0) {
            throw new IllegalArgumentException();
        }
        this.maximumPoolSize_ = newMaximum;
    }

    public int getMinimumPoolSize() {
        return this.minimumPoolSize_;
    }

    public void setMinimumPoolSize(int newMinimum) {
        if (newMinimum < 0) {
            throw new IllegalArgumentException();
        }
        this.minimumPoolSize_ = newMinimum;
    }

    public int getPoolSize() {
        return this.poolSize_;
    }

    protected void addThread(Runnable command) {
        ++this.poolSize_;
        Worker worker = new Worker(command);
        Thread thread = this.getThreadFactory().newThread(worker);
        this.threads_.put(worker, thread);
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createThreads(int numberOfThreads) {
        int ncreated = 0;
        for (int i = 0; i < numberOfThreads; ++i) {
            Object object = this.poolLock_;
            synchronized (object) {
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    ++ncreated;
                } else {
                    break;
                }
                this.addThread(null);
                continue;
            }
        }
        return ncreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptAll() {
        Object object = this.poolLock_;
        synchronized (object) {
            Iterator it = this.threads_.values().iterator();
            while (it.hasNext()) {
                Thread t = (Thread)it.next();
                t.interrupt();
            }
        }
    }

    public List drain() {
        boolean wasInterrupted = false;
        Vector<Object> tasks = new Vector<Object>();
        while (true) {
            try {
                Object x;
                while ((x = this.handOff_.poll(0L)) != null) {
                    tasks.addElement(x);
                }
            }
            catch (InterruptedException ex) {
                wasInterrupted = true;
                continue;
            }
            break;
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
        return tasks;
    }

    public synchronized long getKeepAliveTime() {
        return this.keepAliveTime_;
    }

    public synchronized void setKeepAliveTime(long msecs) {
        this.keepAliveTime_ = msecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void workerDone(Worker w) {
        Object object = this.poolLock_;
        synchronized (object) {
            --this.poolSize_;
            this.threads_.remove(w);
        }
    }

    protected Runnable getTask() throws InterruptedException {
        long waitTime = this.getKeepAliveTime();
        if (waitTime >= 0L) {
            return (Runnable)this.handOff_.poll(waitTime);
        }
        return (Runnable)this.handOff_.take();
    }

    protected synchronized BlockedExecutionHandler getBlockedExecutionHandler() {
        return this.blockedExecutionHandler_;
    }

    public synchronized void runWhenBlocked() {
        this.blockedExecutionHandler_ = new RunWhenBlocked();
    }

    public synchronized void waitWhenBlocked() {
        this.blockedExecutionHandler_ = new WaitWhenBlocked();
    }

    public synchronized void discardWhenBlocked() {
        this.blockedExecutionHandler_ = new DiscardWhenBlocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable command) throws InterruptedException {
        do {
            Object object = this.poolLock_;
            synchronized (object) {
                if (this.getPoolSize() < this.getMinimumPoolSize()) {
                    this.addThread(command);
                    return;
                }
                if (this.handOff_.offer(command, 0L)) {
                    return;
                }
                if (this.getPoolSize() < this.getMaximumPoolSize()) {
                    this.addThread(command);
                    return;
                }
            }
        } while (!this.getBlockedExecutionHandler().blockedAction(command));
    }

    protected class DiscardWhenBlocked
    extends BlockedExecutionHandler {
        protected DiscardWhenBlocked() {
        }

        protected boolean blockedAction(Runnable command) {
            return true;
        }
    }

    protected class WaitWhenBlocked
    extends BlockedExecutionHandler {
        protected WaitWhenBlocked() {
        }

        protected boolean blockedAction(Runnable command) {
            try {
                PooledExecutor.this.handOff_.put(command);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            return true;
        }
    }

    protected class RunWhenBlocked
    extends BlockedExecutionHandler {
        protected RunWhenBlocked() {
        }

        protected boolean blockedAction(Runnable command) {
            command.run();
            return true;
        }
    }

    protected abstract class BlockedExecutionHandler {
        protected BlockedExecutionHandler() {
        }

        abstract boolean blockedAction(Runnable var1);
    }

    protected class Worker
    implements Runnable {
        protected Runnable firstTask_;

        Worker(Runnable firstTask) {
            this.firstTask_ = firstTask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Runnable task = this.firstTask_;
                this.firstTask_ = null;
                if (task != null) {
                    task.run();
                }
                while (PooledExecutor.this.getPoolSize() <= PooledExecutor.this.getMaximumPoolSize() && (task = PooledExecutor.this.getTask()) != null) {
                    task.run();
                }
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                PooledExecutor.this.workerDone(this);
            }
        }
    }
}

