/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasLayer;
import diva.canvas.CanvasPane;
import diva.canvas.FigureLayer;
import diva.canvas.OverlayLayer;
import diva.canvas.event.EventLayer;
import java.util.ArrayList;
import java.util.Iterator;

public class GraphicsPane
extends CanvasPane {
    protected ArrayList _layers = new ArrayList(6);
    private static final int BACKGROUND_EVENT_LAYER = 4;
    private static final int BACKGROUND_LAYER = 3;
    private static final int FOREGROUND_LAYER = 2;
    private static final int OVERLAY_LAYER = 1;
    private static final int FOREGROUND_EVENT_LAYER = 0;
    private EventLayer _backgroundEventLayer = new EventLayer();
    private CanvasLayer _backgroundLayer;
    private FigureLayer _foregroundLayer;
    private OverlayLayer _overlayLayer;
    private EventLayer _foregroundEventLayer;

    public GraphicsPane() {
        this(new FigureLayer());
    }

    public GraphicsPane(FigureLayer foregroundLayer) {
        this._backgroundEventLayer.setEnabled(true);
        this._backgroundLayer = new FigureLayer();
        ((FigureLayer)this._backgroundLayer).setVisible(false);
        ((FigureLayer)this._backgroundLayer).setEnabled(false);
        this._foregroundLayer = foregroundLayer;
        this._overlayLayer = new OverlayLayer();
        this._foregroundEventLayer = new EventLayer();
        this._foregroundEventLayer.setEnabled(false);
        this._initNewLayer(this._backgroundEventLayer);
        this._initNewLayer(this._backgroundLayer);
        this._initNewLayer(this._foregroundLayer);
        this._initNewLayer(this._overlayLayer);
        this._initNewLayer(this._foregroundEventLayer);
        this._layers.add(this._backgroundEventLayer);
        this._layers.add(0, this._backgroundLayer);
        this._layers.add(0, this._foregroundLayer);
        this._layers.add(0, this._overlayLayer);
        this._layers.add(0, this._foregroundEventLayer);
    }

    public EventLayer getBackgroundEventLayer() {
        return this._backgroundEventLayer;
    }

    public CanvasLayer getBackgroundLayer() {
        return this._backgroundLayer;
    }

    public FigureLayer getForegroundLayer() {
        return this._foregroundLayer;
    }

    public OverlayLayer getOverlayLayer() {
        return this._overlayLayer;
    }

    public EventLayer getForegroundEventLayer() {
        return this._foregroundEventLayer;
    }

    public Iterator layersFromFront() {
        return this._layers.iterator();
    }

    public Iterator layersFromBack() {
        return new Iterator(){
            int cursor;
            {
                this.cursor = GraphicsPane.this._layers.size();
            }

            public boolean hasNext() {
                return this.cursor > 0;
            }

            public Object next() {
                --this.cursor;
                return GraphicsPane.this._layers.get(this.cursor);
            }

            public void remove() {
                throw new UnsupportedOperationException("Cannot delete layer from canvas pane");
            }
        };
    }

    public void setBackgroundEventLayer(EventLayer l) {
        this._nullifyLayer(this._backgroundEventLayer);
        this._backgroundEventLayer = l;
        this._initNewLayer(l);
        this._layers.set(4, l);
    }

    public void setBackgroundLayer(CanvasLayer l) {
        this._nullifyLayer(this._backgroundLayer);
        this._backgroundLayer = l;
        this._initNewLayer(l);
        this._layers.set(3, l);
    }

    public void setForegroundLayer(FigureLayer l) {
        this._nullifyLayer(this._foregroundLayer);
        this._foregroundLayer = l;
        this._initNewLayer(l);
        this._layers.set(2, l);
    }

    public void setOverlayLayer(OverlayLayer l) {
        this._nullifyLayer(this._overlayLayer);
        this._overlayLayer = l;
        this._initNewLayer(l);
        this._layers.set(1, l);
    }

    public void setForegroundEventLayer(EventLayer l) {
        this._nullifyLayer(this._foregroundEventLayer);
        this._foregroundEventLayer = l;
        this._initNewLayer(l);
        this._layers.set(0, l);
    }
}

