/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.CanvasUtilities;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.connector.AbstractConnector;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;

public class ArcConnector
extends AbstractConnector {
    private Arc2D _arc = new Arc2D.Double();
    private double _angle = 0.6283185307179586;
    private double _centerX;
    private double _centerY;
    private double _radius;
    private double _startAngle;

    public ArcConnector(Site tail, Site head) {
        super(tail, head);
        this.getPaintedPath().shape = this._arc;
        this.route();
    }

    public double getAngle() {
        return this._angle;
    }

    public void repositionLabel() {
        if (this.getLabelFigure() != null) {
            Point2D.Double pt = new Point2D.Double(this._centerX + this._radius * Math.sin(this._startAngle + this._angle + 1.5707963267948966), this._centerY + this._radius * Math.cos(this._startAngle + this._angle + 1.5707963267948966));
            this.getLabelFigure().translateTo(pt);
            this.getLabelFigure().autoAnchor(this._arc);
        }
    }

    public void route() {
        Point2D headPt;
        Point2D tailPt;
        this.repaint();
        TransformContext currentContext = this.getTransformContext();
        Site headSite = this.getHeadSite();
        Site tailSite = this.getTailSite();
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        Point2D tailCenter = tailSite.getFigure() != null ? CanvasUtilities.getCenterPoint(tailSite.getFigure()) : tailPt;
        Point2D headCenter = headSite.getFigure() != null ? CanvasUtilities.getCenterPoint(headSite.getFigure()) : headPt;
        double x = headCenter.getX() - tailCenter.getX();
        double y = headCenter.getY() - tailCenter.getY();
        double gamma = Math.atan2(y, x);
        double alpha = this._angle;
        double beta = 1.5707963267948966 - alpha;
        tailSite.setNormal(gamma + alpha);
        headSite.setNormal(gamma - alpha - Math.PI);
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        x = headPt.getX() - tailPt.getX();
        y = headPt.getY() - tailPt.getY();
        gamma = Math.atan2(y, x);
        if (this.getHeadEnd() != null) {
            this.getHeadEnd().setNormal(gamma - alpha - Math.PI);
            this.getHeadEnd().setOrigin(headPt.getX(), headPt.getY());
            this.getHeadEnd().getConnection(headPt);
        }
        if (this.getTailEnd() != null) {
            this.getTailEnd().setNormal(gamma - alpha);
            this.getTailEnd().setOrigin(tailPt.getX(), tailPt.getY());
            this.getTailEnd().getConnection(tailPt);
        }
        x = headPt.getX() - tailPt.getX();
        y = headPt.getY() - tailPt.getY();
        gamma = Math.atan2(y, x);
        double dx = Math.sqrt(x * x + y * y) / 2.0;
        double dy = -dx * Math.tan(beta);
        double dxdash = dx * Math.cos(gamma) - dy * Math.sin(gamma);
        double dydash = dx * Math.sin(gamma) + dy * Math.cos(gamma);
        double centerX = tailPt.getX() + dxdash;
        double centerY = tailPt.getY() + dydash;
        double radius = Math.sqrt(dx * dx + dy * dy);
        this._centerX = centerX;
        this._centerY = centerY;
        this._radius = radius;
        this._startAngle = 4.71238898038469 - alpha - gamma;
        if (this._angle < 0.0) {
            this._startAngle += Math.PI;
        }
        this._arc.setArcByCenter(centerX, centerY, radius, this._startAngle / Math.PI * 180.0, 2.0 * alpha / Math.PI * 180.0, 0);
        this.repositionLabel();
        this.repaint();
    }

    public void setAngle(double angle) {
        this._angle = angle;
    }

    public void translate(double x, double y) {
        Rectangle bounds = this._arc.getBounds();
        this.repaint();
        this._arc.setFrame(((RectangularShape)bounds).getX() + x, ((RectangularShape)bounds).getY() + y, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
        if (this.getLabelFigure() != null) {
            this.getLabelFigure().translate(x, y);
        }
        this.repaint();
    }
}

