/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.manipulator;

import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.manipulator.BasicGrabHandleFactory;
import diva.canvas.manipulator.GrabHandle;
import diva.canvas.manipulator.GrabHandleFactory;
import diva.canvas.manipulator.Manipulator;
import diva.canvas.manipulator.PathGeometry;
import diva.canvas.manipulator.ShapedFigure;
import java.util.Iterator;

public class PathManipulator
extends Manipulator {
    private PathGeometry _geometry;

    public PathManipulator() {
        this(new BasicGrabHandleFactory());
    }

    public PathManipulator(GrabHandleFactory f) {
        this.setGrabHandleFactory(f);
        this.setHandleInteractor(new Resizer());
    }

    private PathGeometry getGeometry() {
        return this._geometry;
    }

    public FigureDecorator newInstance(Figure f) {
        PathManipulator m = new PathManipulator();
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        return m;
    }

    public void refresh() {
        if (this._geometry != null) {
            this._geometry.setShape(this.getChild().getShape());
        }
    }

    public void setChild(Figure f) {
        super.setChild(f);
        this.clearGrabHandles();
        this._geometry = null;
        Figure child = this.getChild();
        if (child != null) {
            if (!(child instanceof ShapedFigure)) {
                throw new IllegalArgumentException("PathManipulator can only decorate a ShapedFigure");
            }
            this._geometry = new PathGeometry(this, this.getChild().getShape());
            Iterator i = this._geometry.vertices();
            GrabHandle g = null;
            while (i.hasNext()) {
                Site site = (Site)i.next();
                if (site instanceof PathGeometry.CloseSegment) continue;
                g = this.getGrabHandleFactory().createGrabHandle(site);
                g.setParent(this);
                g.setInteractor(this.getHandleInteractor());
                this.addGrabHandle(g);
            }
        }
    }

    private static class Resizer
    extends DragInteractor {
        private Resizer() {
        }

        public void translate(LayerEvent e, double x, double y) {
            GrabHandle g = (GrabHandle)e.getFigureSource();
            g.translate(x, y);
            PathManipulator parent = (PathManipulator)g.getParent();
            PathGeometry geometry = parent.getGeometry();
            ((ShapedFigure)parent.getChild()).setShape(geometry.getShape());
        }
    }
}

