/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.selection;

import diva.canvas.Figure;
import diva.canvas.interactor.Interactor;
import diva.canvas.selection.SelectionEvent;
import diva.canvas.selection.SelectionInteractor;
import diva.canvas.selection.SelectionListener;
import diva.canvas.selection.SelectionModel;
import diva.canvas.selection.SelectionRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.EventListenerList;

public class BasicSelectionModel
implements SelectionModel {
    private int _mode = 1;
    private EventListenerList _listeners = null;
    private ArrayList _selection = null;
    private SelectionEvent _selEvent = new SelectionEvent(this);
    private Object[] _dummy = new Object[0];
    static /* synthetic */ Class class$diva$canvas$selection$SelectionListener;

    public BasicSelectionModel() {
        this._selection = new ArrayList();
        this._listeners = new EventListenerList();
    }

    public void addSelectionListener(SelectionListener l) {
        this._listeners.add(class$diva$canvas$selection$SelectionListener == null ? (class$diva$canvas$selection$SelectionListener = BasicSelectionModel.class$("diva.canvas.selection.SelectionListener")) : class$diva$canvas$selection$SelectionListener, l);
    }

    public void addSelection(Object sel) {
        Object[] additions = null;
        Object[] removals = null;
        if (this.getSelectionMode() == 0) {
            removals = this._selection.toArray();
            this.clearSelection();
        }
        this._selection.add(sel);
        this.renderSelected(sel);
        additions = new Object[]{sel};
        this._selEvent.set(additions, removals, this.getFirstSelection());
        this.dispatchSelectionEvent(this._selEvent);
    }

    public void addSelections(Object[] sels) {
        if (this.getSelectionMode() == 0) {
            this.addSelection(sels[sels.length - 1]);
        } else {
            for (int i = 0; i < sels.length; ++i) {
                this._selection.add(sels[i]);
                this.renderSelected(sels[i]);
            }
            this._selEvent.set(sels, null, this.getFirstSelection());
            this.dispatchSelectionEvent(this._selEvent);
        }
    }

    public void clearSelection() {
        Object[] removals = this._selection.toArray();
        this._selection.clear();
        for (int i = 0; i < removals.length; ++i) {
            this.renderDeselected(removals[i]);
        }
        this._selEvent.set(null, removals, this.getFirstSelection());
        this.dispatchSelectionEvent(this._selEvent);
    }

    public boolean containsSelection(Object sel) {
        return this._selection.contains(sel);
    }

    public void dispatchSelectionEvent(SelectionEvent e) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$diva$canvas$selection$SelectionListener == null ? BasicSelectionModel.class$("diva.canvas.selection.SelectionListener") : class$diva$canvas$selection$SelectionListener)) continue;
            ((SelectionListener)listeners[i + 1]).selectionChanged(e);
        }
    }

    public Object getFirstSelection() {
        if (this._selection.size() == 0) {
            return null;
        }
        return this._selection.get(0);
    }

    public Object getLastSelection() {
        if (this._selection.size() == 0) {
            return null;
        }
        return this._selection.get(this._selection.size() - 1);
    }

    public Iterator getSelection() {
        return this._selection.iterator();
    }

    public Object[] getSelectionAsArray() {
        return this._selection.toArray();
    }

    public int getSelectionCount() {
        return this._selection.size();
    }

    public int getSelectionMode() {
        return this._mode;
    }

    public void removeSelection(Object sel) {
        Object[] removals = new Object[]{sel};
        this._selection.remove(sel);
        this.renderDeselected(sel);
        this._selEvent.set(null, removals, this.getFirstSelection());
        this.dispatchSelectionEvent(this._selEvent);
    }

    public void removeSelectionListener(SelectionListener l) {
        this._listeners.remove(class$diva$canvas$selection$SelectionListener == null ? (class$diva$canvas$selection$SelectionListener = BasicSelectionModel.class$("diva.canvas.selection.SelectionListener")) : class$diva$canvas$selection$SelectionListener, l);
    }

    private void renderDeselected(Object o) {
        SelectionRenderer sr;
        Interactor ir;
        if (o instanceof Figure && (ir = ((Figure)o).getInteractor()) instanceof SelectionInteractor && (sr = ((SelectionInteractor)ir).getSelectionRenderer()) != null) {
            sr.renderDeselected((Figure)o);
        }
    }

    private void renderSelected(Object o) {
        SelectionRenderer sr;
        Interactor ir;
        if (o instanceof Figure && (ir = ((Figure)o).getInteractor()) instanceof SelectionInteractor && (sr = ((SelectionInteractor)ir).getSelectionRenderer()) != null) {
            sr.renderSelected((Figure)o);
        }
    }

    public void setSelectionMode(int mode) {
        this._mode = mode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

