/*
 * Decompiled with CFR 0.152.
 */
package diva.graph;

import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.CenterTarget;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorTarget;
import diva.canvas.selection.BasicSelectionModel;
import diva.canvas.selection.SelectionModel;
import diva.graph.EdgeInteractor;
import diva.graph.GraphController;
import diva.graph.GraphView;
import diva.graph.NodeInteractor;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphEvent;
import diva.graph.model.GraphModel;
import diva.graph.model.GraphUtilities;
import diva.graph.model.Node;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class AbstractGraphController
implements GraphController {
    private ConnectorTarget _connectorTarget = new CenterTarget();
    private EdgeInteractor _edgeInteractor;
    private NodeInteractor _nodeInteractor;
    private GraphModel _model;
    private SelectionModel _selectionModel = new BasicSelectionModel();
    private GraphView _view;

    boolean areEndsVisible(Edge e) {
        Node hn = e.getHead();
        Node tn = e.getTail();
        Connector c = this._view.getEdgeFigure(e);
        boolean hasHeadNode = hn != null && this._view.getNodeFigure(hn) != null;
        boolean hasAutoHead = c != null && c.getHeadSite() instanceof AutonomousSite;
        boolean hasTailNode = tn != null && this._view.getNodeFigure(tn) != null;
        boolean hasAutoTail = c != null && c.getTailSite() instanceof AutonomousSite;
        return !(!hasHeadNode && !hasAutoHead || !hasTailNode && !hasAutoTail);
    }

    void createEdgeFigure(Edge e) {
        Figure nf = this._view.getNodeFigure(e.getTail());
        Rectangle2D bounds = nf.getBounds();
        Site tailSite = this.getConnectorTarget().getTailSite(nf, bounds.getCenterX(), bounds.getCenterY());
        nf = this._view.getNodeFigure(e.getHead());
        bounds = nf.getBounds();
        Site headSite = this.getConnectorTarget().getHeadSite(nf, bounds.getCenterX(), bounds.getCenterY());
        Connector ef = this._view.getEdgeRenderer().render(e, tailSite, headSite);
        ef.setInteractor(this.getEdgeInteractor());
        this._view.addEdgeFigureToLayer(ef);
        this._view.addEdgeMapping(e, ef);
        ef.route();
    }

    private void debug(String s) {
        System.err.println(s);
    }

    public void edgeHeadChanged(GraphEvent evt) {
        Edge e = (Edge)evt.getTarget();
        boolean wasVisible = this._view.isEdgeVisible(e);
        boolean endsVisible = this.areEndsVisible(e);
        if (wasVisible || endsVisible) {
            if (wasVisible && !endsVisible) {
                this.removeEdgeFigure(e);
            } else if (!wasVisible && endsVisible) {
                this.createEdgeFigure(e);
            } else {
                Connector ef = this._view.getEdgeFigure(e);
                Site hs = ef.getHeadSite();
                if (e.getHead() != null) {
                    Figure nf = this._view.getNodeFigure(e.getHead());
                    Site s = this.getConnectorTarget().getHeadSite(nf, hs.getX(), hs.getY());
                    ef.setHeadSite(s);
                }
            }
        }
        this._view.getIncrLayout().edgeHeadChanged(evt);
    }

    public void edgeTailChanged(GraphEvent evt) {
        Edge e = (Edge)evt.getTarget();
        boolean wasVisible = this._view.isEdgeVisible(e);
        boolean endsVisible = this.areEndsVisible(e);
        if (wasVisible || endsVisible) {
            if (wasVisible && !endsVisible) {
                this.removeEdgeFigure(e);
            } else if (!wasVisible && endsVisible) {
                this.createEdgeFigure(e);
            } else {
                Connector ef = this._view.getEdgeFigure(e);
                Site ts = ef.getTailSite();
                if (e.getTail() != null) {
                    Figure nf = this._view.getNodeFigure(e.getTail());
                    Site s = this.getConnectorTarget().getTailSite(nf, ts.getX(), ts.getY());
                    ef.setTailSite(s);
                }
            }
        }
        this._view.getIncrLayout().edgeTailChanged(evt);
    }

    public ConnectorTarget getConnectorTarget() {
        return this._connectorTarget;
    }

    public EdgeInteractor getEdgeInteractor() {
        return this._edgeInteractor;
    }

    public final GraphModel getGraphModel() {
        return this._model;
    }

    public final GraphView getGraphView() {
        return this._view;
    }

    public NodeInteractor getNodeInteractor() {
        return this._nodeInteractor;
    }

    public SelectionModel getSelectionModel() {
        return this._selectionModel;
    }

    public abstract void initializeInteraction();

    public void nodeAdded(GraphEvent evt) {
        Node n = (Node)evt.getTarget();
        boolean doLayout = false;
        Figure nf = this._view.getNodeFigure(n);
        if (nf == null) {
            nf = this._view.getNodeRenderer().render(n);
            this._view.addNodeMapping(n, nf);
            doLayout = true;
        }
        nf.setInteractor(this.getNodeInteractor());
        if (nf.getParent() == null) {
            if (n.getParent() == this._model.getGraph()) {
                this._view.addNodeFigureToLayer(nf);
            } else {
                this._view.addNodeFigureToParent(nf);
            }
            Iterator i = n.outEdges();
            while (i.hasNext()) {
                Edge e = (Edge)i.next();
                if (!this.areEndsVisible(e)) continue;
                this.createEdgeFigure(e);
            }
            if (doLayout) {
                this._view.getIncrLayout().nodeAdded(evt);
            }
        } else {
            Graph prevParent = (Graph)evt.getOldValue();
            if (prevParent != n.getParent() && prevParent != null) {
                this._view.getIncrLayout().nodeAdded(evt);
            }
        }
    }

    public void nodeRemoved(GraphEvent evt) {
        Edge e;
        Node n = (Node)evt.getTarget();
        Figure nf = this._view.getNodeFigure(n);
        if (nf != null) {
            this._view.removeNodeMapping(n, nf);
            this._view.getGraphicsPane().getForegroundLayer().remove(nf);
        }
        Iterator i = n.inEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            this.removeEdgeFigure(e);
        }
        i = n.outEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            this.removeEdgeFigure(e);
        }
        if (nf != null) {
            this._view.getIncrLayout().nodeRemoved(evt);
        }
    }

    void refreshRecursive(Graph g, boolean isRoot) {
        Iterator i = g.nodes();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            Figure nf = this._view.getNodeRenderer().render(n);
            nf.setInteractor(this.getNodeInteractor());
            this._view.addNodeMapping(n, nf);
            if (isRoot) {
                this._view.addNodeFigureToLayer(nf);
            } else {
                this._view.addNodeFigureToParent(nf);
            }
            if (!(n instanceof Graph)) continue;
            Graph sub = (Graph)((Object)n);
            this.refreshRecursive(sub, false);
        }
        i = GraphUtilities.localEdges(g);
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            this.createEdgeFigure(e);
        }
    }

    public void setConnectorTarget(ConnectorTarget t) {
        this._connectorTarget = t;
    }

    protected void setEdgeInteractor(EdgeInteractor interactor) {
        this._edgeInteractor = interactor;
    }

    public void setGraphView(GraphView view) {
        this._view = view;
        this.initializeInteraction();
    }

    public void setGraphModel(GraphModel m) {
        if (this._model != null) {
            this._model.removeGraphListener(this);
        }
        this._model = m;
        if (this._model != null) {
            this._model.addGraphListener(this);
            GraphEvent update = new GraphEvent(30, this, this._model.getGraph());
            this.structureChanged(update);
        }
    }

    protected void setNodeInteractor(NodeInteractor interactor) {
        this._nodeInteractor = interactor;
    }

    public void setSelectionModel(SelectionModel m) {
        this._selectionModel = m;
    }

    public void structureChanged(GraphEvent evt) {
        this._view.clear();
        this.refreshRecursive((Graph)evt.getTarget(), true);
        this._view.getIncrLayout().structureChanged(evt);
        this._view.getGraphicsPane().repaint();
    }

    protected void removeEdgeFigure(Edge e) {
        Connector ef = this._view.getEdgeFigure(e);
        this._view.removeEdgeMapping(e, ef);
        if (ef != null) {
            this._view.getGraphicsPane().getForegroundLayer().remove(ef);
        }
    }
}

