/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.LayoutTarget;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphUtilities;
import diva.graph.model.Node;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public final class LayoutUtilities {
    public static final void place(LayoutTarget target, Node n, double x, double y) {
        Edge e;
        LayoutUtilities.placeNoReroute(target, n, x, y);
        Iterator i = n.inEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            if (!target.isEdgeVisible(e)) continue;
            target.route(e);
        }
        i = n.outEdges();
        while (i.hasNext()) {
            e = (Edge)i.next();
            if (!target.isEdgeVisible(e)) continue;
            target.route(e);
        }
    }

    public static final void placeNoReroute(LayoutTarget target, Node n, double x, double y) {
        Rectangle2D bounds = target.getBounds(n);
        target.translate(n, x - bounds.getWidth() / 2.0 - bounds.getX(), y - bounds.getHeight() / 2.0 - bounds.getY());
    }

    public static final boolean checkConsistency(Graph g, LayoutTarget target) {
        if (!GraphUtilities.checkConsistency(g)) {
            return false;
        }
        return LayoutUtilities.checkCommon(g, target);
    }

    public static final boolean checkContainment(Graph g, LayoutTarget target) {
        if (!GraphUtilities.checkContainment(g)) {
            return false;
        }
        return LayoutUtilities.checkCommon(g, target);
    }

    private static final boolean checkCommon(Graph g, LayoutTarget target) {
        return true;
    }

    public static final void routeVisibleEdges(Graph g, LayoutTarget target) {
        Iterator ns = g.nodes();
        while (ns.hasNext()) {
            Edge e;
            Node n = (Node)ns.next();
            Iterator i = n.inEdges();
            while (i.hasNext()) {
                e = (Edge)i.next();
                if (!target.isEdgeVisible(e)) continue;
                target.route(e);
            }
            i = n.outEdges();
            while (i.hasNext()) {
                e = (Edge)i.next();
                if (!target.isEdgeVisible(e)) continue;
                target.route(e);
            }
        }
    }
}

