/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import diva.canvas.FigureLayer;
import diva.graph.GraphView;
import fsa.AnimationManager;
import fsa.AnimationPath;
import fsa.Colors;
import fsa.FSAGraphController;
import fsa.FSAGraphPane;
import fsa.FSAPanel;
import fsa.FigureMover;
import fsa.LightPanel;
import fsa.StateFigure;
import fsa.Tape;
import fsa.TransitionConnector;
import fsa.machine.State;
import fsa.machine.StateMachine;
import fsa.machine.Transition;
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

class FSAAnimator
implements Tape.TapeListener,
Tape.SelectListener {
    AnimateAction _animateAction;
    AnimationControlPanel _animationControlPanel;
    FigureLayer _animationLayer;
    AnimationManager _animationManager;
    FSAGraphController _controller;
    FSAGraphPane _graphPane;
    FSAPanel _fsaPanel;
    GraphView _graphView;
    LightPanel _lightPanel;
    Semaphore _steppingLock;
    StateMachine _machine;
    StepAction _stepAction;
    CancelAction _cancelAction;
    Tape _ioTape;
    Vector _deadMovers;
    Vector _movers;
    Vector _newMovers;
    boolean _stopFlag;
    boolean _checkYRepeats = false;
    State[] _stateList = null;
    Transition[] _transitionList = null;
    int _statesSeen = 0;
    int[][] _allLoops = null;
    boolean[] _loopsFound;
    public static final int LOOP_NOINFO = 0;
    public static final int LOOP_NUMBER_LOOPS = 1;
    public static final int LOOP_SHOW = 2;
    int _loopHints = 2;

    public FSAAnimator(FSAPanel fp, StateMachine machine, GraphView graphView) {
        this._fsaPanel = fp;
        this._animationManager = new AnimationManager();
        this._controller = (FSAGraphController)graphView.getGraphController();
        this._graphView = graphView;
        this._graphPane = (FSAGraphPane)this._graphView.getGraphicsPane();
        this._animationLayer = this._graphPane.getAnimationLayer();
        this._ioTape = new Tape(true);
        this._ioTape.setLeftLimited(true);
        this._ioTape.addTapeListener(this);
        this._ioTape.addSelectListener(this);
        this._lightPanel = new LightPanel();
        this._machine = machine;
        this._movers = new Vector();
        this._deadMovers = new Vector();
        this._newMovers = new Vector();
        this._stepAction = new StepAction();
        this._cancelAction = new CancelAction();
        this._steppingLock = new Semaphore(1L);
        this._animateAction = new AnimateAction();
        this._animationControlPanel = new AnimationControlPanel();
    }

    public Action getAnimateAction() {
        return this._animateAction;
    }

    public Action getStepAction() {
        return this._stepAction;
    }

    public LightPanel getLightPanel() {
        return this._lightPanel;
    }

    public Tape getIOTape() {
        return this._ioTape;
    }

    public JPanel getAnimationControlPanel() {
        return this._animationControlPanel;
    }

    public void setLoopHints(int loopHints) {
        this._loopHints = loopHints;
    }

    void killMovers() {
        Iterator iterator = this._movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            iterator.remove();
            this._deadMovers.addElement(mover);
        }
    }

    boolean moverInFinalState(Vector movers) {
        boolean inFinalState = false;
        Iterator iterator = this._movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            State state = mover.getState();
            if (!state.isFinalState()) continue;
            inFinalState = true;
            mover.setColor(Color.green);
        }
        return inFinalState;
    }

    void colorMovers(Vector movers, Color color) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            mover.setColor(color);
        }
    }

    void updateColor() {
        this.colorStates(this._stateList, this._statesSeen, this._transitionList);
    }

    void uncolor() {
        Iterator transitionsIterator = this._machine.getTransitions();
        while (transitionsIterator.hasNext()) {
            Transition transition = (Transition)transitionsIterator.next();
            this.setTransitionState(transition, 7);
            this.resetTransitionTouchCount(transition);
        }
        Iterator statesIterator = this._machine.getStates();
        while (statesIterator.hasNext()) {
            State state = (State)statesIterator.next();
            this.colorState(state, 7);
            this.resetStateTouchCount(state);
        }
    }

    void colorStates(State[] stateList, int numberSeen, Transition[] transitionList) {
        char[] classification;
        if (stateList == null || numberSeen <= 0 || transitionList == null) {
            classification = new char[this._ioTape.getNumberOfSymbolsOnTape()];
            for (int i = 0; i < classification.length; ++i) {
                classification[i] = i < this._ioTape.getULength() ? 117 : (i < this._ioTape.getULength() + this._ioTape.getVLength() ? 118 : 119);
            }
        } else {
            classification = FSAAnimator.classify(stateList, numberSeen, this._ioTape.getULength(), this._ioTape.getVLength(), this._checkYRepeats);
            for (int i = 0; i < classification.length; ++i) {
                int portion = Colors.getClassificationInt(classification[i]);
                if (stateList[i] != null) {
                    this.colorState(stateList[i], portion);
                }
                if (i >= transitionList.length || transitionList[i] == null) continue;
                this.setTransitionState(transitionList[i], portion);
            }
        }
        this._ioTape.setClassificationList(classification);
    }

    StateFigure getState(State state) {
        return this._controller.getStateFigure(state);
    }

    void resetStateTouchCount(State state) {
        if (state != null) {
            this.getState(state).resetTouchCount();
        }
    }

    void touchState(State state) {
        if (state != null) {
            this.getState(state).touch();
        }
    }

    void colorState(State state, int portion) {
        if (state != null) {
            this.getState(state).setStringPortion(portion);
        }
    }

    void setStateLoopPortion(State state, int loopPortion) {
        if (state != null) {
            this.getState(state).setLoopPortion(loopPortion);
        }
    }

    void setCheckYRepeats(boolean check) {
        this._checkYRepeats = check;
    }

    static int[][] getLoops(Object[] states, int lengthSymbols) {
        int[][] loopsStore = new int[lengthSymbols * (lengthSymbols - 1) / 2][];
        int loopCount = 0;
        for (int start = 0; start < lengthSymbols; ++start) {
            for (int end = start + 1; end < lengthSymbols; ++end) {
                if (states[start] != states[end]) continue;
                loopsStore[loopCount] = new int[]{start, end};
                ++loopCount;
            }
        }
        int[][] loopsReturn = new int[loopCount][];
        for (int i = 0; i < loopsReturn.length; ++i) {
            loopsReturn[i] = loopsStore[i];
        }
        return loopsReturn;
    }

    boolean validPossibility(int start, int end) {
        return this._stateList != null && end <= this._statesSeen;
    }

    boolean isLoop(int start, int end) {
        if (this.validPossibility(start, end)) {
            return FSAAnimator.isLoop(this._stateList, start, end);
        }
        return false;
    }

    static boolean isLoop(Object[] states, int start, int end) {
        if (0 > start || start >= states.length) {
            return false;
        }
        if (0 > end || end >= states.length) {
            return false;
        }
        return states[start] == states[end];
    }

    static char[] classify(Object[] states, int lengthSymbols, int lengthU, int lengthV, boolean checkYRepeats) {
        char[] classification = new char[lengthSymbols];
        if (states.length < lengthSymbols - 1) {
            System.out.println("Too few states");
        }
        if (lengthSymbols < lengthU) {
            for (int i = 0; i < lengthSymbols; ++i) {
                classification[i] = 117;
            }
            return classification;
        }
        for (int i = 0; i < lengthU; ++i) {
            classification[i] = 117;
        }
        int index = lengthU;
        Hashtable<Object, Integer> statesDict = new Hashtable<Object, Integer>();
        if (lengthU + lengthV > lengthSymbols) {
            lengthV = lengthSymbols - lengthU;
        }
        while (index < lengthU + lengthV && !statesDict.containsKey(states[index])) {
            classification[index] = 120;
            statesDict.put(states[index], new Integer(index));
            ++index;
        }
        if (index < states.length && statesDict.containsKey(states[index])) {
            int startIndex;
            int i;
            for (i = startIndex = ((Integer)statesDict.get(states[index])).intValue(); i < index; ++i) {
                classification[i] = 121;
            }
            if (checkYRepeats) {
                int endIndex = index;
                int yLength = endIndex - startIndex;
                int currentStart = index;
                boolean uppercase = true;
                while (currentStart + yLength < lengthU + lengthV) {
                    int offset;
                    for (offset = 0; offset < yLength && states[startIndex + offset] == states[currentStart + offset]; ++offset) {
                        classification[currentStart + offset] = 122;
                    }
                    if (offset == yLength && states[startIndex + offset] == states[currentStart + offset]) {
                        for (int i2 = 0; i2 < yLength; ++i2) {
                            classification[currentStart + i2] = uppercase ? 89 : 121;
                        }
                        uppercase = !uppercase;
                        index = currentStart += yLength;
                        continue;
                    }
                    index = currentStart + offset;
                    break;
                }
            }
            for (i = index; i < lengthU + lengthV; ++i) {
                classification[i] = 122;
            }
        }
        for (int i = lengthU + lengthV; i < lengthSymbols; ++i) {
            classification[i] = 119;
        }
        return classification;
    }

    void demoteMovers(Vector movers) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            mover.demote();
        }
    }

    void clearMovers(Vector movers) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            mover.detach();
        }
        movers.clear();
    }

    AnimationPath getAnimationPath(Transition transition) {
        State state = transition.getDestination();
        TransitionConnector figure = this._controller.getEdgeFigure(transition);
        return figure.getAnimationPath();
    }

    FigureMover createMover(State state) {
        FigureMover mover = new FigureMover();
        mover.setLocation(this._controller.getStateFigure(state));
        mover.setState(state);
        mover.setLayer(this._animationLayer);
        mover.attach();
        return mover;
    }

    void handleEmptyTransitions() {
        Vector newMovers = new Vector(this._movers);
        do {
            ListIterator<FigureMover> movers = newMovers.listIterator();
            while (movers.hasNext()) {
                FigureMover mover = (FigureMover)movers.next();
                movers.remove();
                State state = mover.getState();
                Iterator transitions = this._machine.transitionFunction(state, StateMachine.EMPTY_SYMBOL);
                if (transitions == null) continue;
                while (transitions.hasNext()) {
                    Transition transition = (Transition)transitions.next();
                    FigureMover newMover = this.createMover(state);
                    this.prepareAnimation(newMover, transition);
                    movers.add(newMover);
                    this._movers.add(newMover);
                }
            }
            this.animateMovers(newMovers);
        } while (!newMovers.isEmpty());
    }

    TransitionConnector getEdge(Transition transition) {
        return this._controller.getEdgeFigure(transition);
    }

    void touchTransition(Transition transition) {
        this.getEdge(transition).touch();
    }

    void resetTransitionTouchCount(Transition transition) {
        this.getEdge(transition).resetTouchCount();
    }

    void setTransitionLoopPortion(Transition transition, int loopPortion) {
        this.getEdge(transition).setLoopPortion(loopPortion);
    }

    void setTransitionState(Transition transition, int state) {
        this.getEdge(transition).setState(state);
    }

    void prepareAnimation(FigureMover mover, Transition transition) {
        this.setTransitionState(transition, 6);
        mover.setState(transition.getDestination());
        mover.setPath(this.getAnimationPath(transition));
    }

    void animateMovers(Vector movers) {
        Iterator iterator = movers.iterator();
        while (iterator.hasNext()) {
            FigureMover mover = (FigureMover)iterator.next();
            this._animationManager.addAnimationObject(mover);
        }
        this._animationManager.start();
    }

    public void stringModified() {
        this._stateList = null;
        this._transitionList = null;
        this._statesSeen = 0;
        this._allLoops = null;
        this._loopsFound = null;
        this.uncolor();
        this.updateColor();
    }

    public void classificationModified() {
        this.uncolor();
        this.updateColor();
    }

    public void selectionStarted() {
        this._ioTape.setSelectColor(Color.YELLOW);
    }

    public void selectionEnded() {
        int start = this._ioTape.getSelectStart();
        int end = this._ioTape.getSelectEnd() + 1;
        this.updateFSA();
        if (this.validPossibility(start, end)) {
            if (this.isLoop(start, end)) {
                this._ioTape.setSelectColor(Color.GREEN);
            } else {
                this._ioTape.setSelectColor(Color.RED);
            }
            this.updateLoops();
            for (int i = 0; i < this._allLoops.length; ++i) {
                if (this._allLoops[i][0] != start || this._allLoops[i][1] != end) continue;
                this._loopsFound[i] = true;
            }
        }
        this._ioTape.setULength(start);
        this._ioTape.setVLength(end - start);
        this.updateLoopColoring(start, end);
    }

    private void unloop() {
        Iterator transitionsIterator = this._machine.getTransitions();
        while (transitionsIterator.hasNext()) {
            Transition transition = (Transition)transitionsIterator.next();
            this.setTransitionLoopPortion(transition, 5);
        }
        Iterator statesIterator = this._machine.getStates();
        while (statesIterator.hasNext()) {
            State state = (State)statesIterator.next();
            this.setStateLoopPortion(state, 5);
        }
    }

    private void updateLoopColoring(int start, int end) {
        this.unloop();
        boolean loopP = this.isLoop(start, end);
        for (int i = 0; i < this._statesSeen; ++i) {
            if (this._stateList[i] != null) {
                State state = this._stateList[i];
                if (i < start) {
                    this.setStateLoopPortion(state, 0);
                } else if (i == start) {
                    this.setStateLoopPortion(state, 1);
                } else if (start < i && i < end) {
                    this.setStateLoopPortion(state, 3);
                } else if (!loopP && i == end) {
                    this.setStateLoopPortion(state, 2);
                } else if (i == end) {
                    this.setStateLoopPortion(state, 4);
                } else {
                    this.setStateLoopPortion(state, 0);
                }
            }
            if (i >= this._transitionList.length || this._transitionList[i] == null) continue;
            Transition transition = this._transitionList[i];
            if (start <= i && i < end) {
                this.setTransitionLoopPortion(transition, 3);
                continue;
            }
            this.setTransitionLoopPortion(transition, 0);
        }
    }

    private void updateFSA() {
        int i;
        StateMachine.RunResults runResults = this._machine.getRunResults(this._ioTape.getSymbolsOnTape());
        this._statesSeen = runResults.statesList.length;
        this._stateList = new State[this._statesSeen];
        for (i = 0; i < this._statesSeen; ++i) {
            this._stateList[i] = runResults.statesList[i].length == 1 ? runResults.statesList[i][0] : null;
        }
        this._transitionList = new Transition[this._statesSeen - 1];
        for (i = 0; i < this._transitionList.length; ++i) {
            this._transitionList[i] = runResults.transitions[i].length == 1 ? runResults.transitions[i][0] : null;
        }
    }

    private void updateLoops() {
        if (this._allLoops == null) {
            this.updateFSA();
            this._allLoops = FSAAnimator.getLoops(this._stateList, this._statesSeen);
            this._loopsFound = new boolean[this._allLoops.length];
        } else if (this._allLoops.length != this._loopsFound.length) {
            this._loopsFound = new boolean[this._allLoops.length];
        }
    }

    private String getSingleLoopStatus(int index) {
        String symbols = new String(this._ioTape.getSymbolsOnTape());
        String retValue = "";
        int start = this._allLoops[index][0];
        int end = this._allLoops[index][1];
        retValue = retValue + symbols.substring(0, start) + "\u2192" + symbols.substring(start, end) + "\u2190" + symbols.substring(end, symbols.length());
        retValue = this._loopsFound[index] ? retValue + " \u2713\n" : retValue + "\n";
        return retValue;
    }

    public void displayLoopStatus() {
        String message;
        this.updateLoops();
        int numberLoopsFound = 0;
        for (int i = 0; i < this._allLoops.length; ++i) {
            if (!this._loopsFound[i]) continue;
            ++numberLoopsFound;
        }
        int loopsLeft = this._allLoops.length - numberLoopsFound;
        boolean allFound = loopsLeft == 0;
        switch (this._loopHints) {
            case 0: {
                if (allFound) {
                    message = "All the loops have been found.\n";
                    break;
                }
                message = numberLoopsFound + " loops have been found,\n" + "but there are still more loops to find.\n";
                break;
            }
            case 1: {
                if (allFound) {
                    message = "All the loops have been found.\n";
                    break;
                }
                message = numberLoopsFound + " loops have been found,\n" + "but there are still " + loopsLeft + " loops left to find.\n";
                break;
            }
            case 2: {
                message = "Here are all the loops:\n";
                break;
            }
            default: {
                message = "Here are all the loops::\n";
            }
        }
        block9: for (int i = 0; i < this._allLoops.length; ++i) {
            switch (this._loopHints) {
                case 0: 
                case 1: {
                    if (!this._loopsFound[i]) continue block9;
                    message = message + this.getSingleLoopStatus(i);
                    continue block9;
                }
                default: {
                    message = message + this.getSingleLoopStatus(i);
                }
            }
        }
        JOptionPane.showMessageDialog(null, message, "Loop Status", 1);
    }

    class AnimationControlPanel
    extends JPanel {
        JButton _stepButton;
        JButton _cancelButton;

        public AnimationControlPanel() {
            GridBagConstraints c = new GridBagConstraints();
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            c.gridwidth = 0;
            this._stepButton = new JButton("Step");
            this._stepButton.addActionListener(FSAAnimator.this._stepAction);
            this._stepButton.setEnabled(false);
            gridbag.setConstraints(this._stepButton, c);
            this.add(this._stepButton);
            this._cancelButton = new JButton("Cancel");
            this._cancelButton.addActionListener(FSAAnimator.this._cancelAction);
            this._cancelButton.setEnabled(false);
            gridbag.setConstraints(this._cancelButton, c);
            this.add(this._cancelButton);
        }

        public void setStepButtonEnabled(boolean enabled) {
            this._stepButton.setEnabled(enabled);
        }

        public void setCancelButtonEnabled(boolean enabled) {
            this._cancelButton.setEnabled(enabled);
        }
    }

    class AnimationThread
    extends Thread {
        AnimationThread() {
        }

        public void run() {
            FSAAnimator.this._stateList = new State[FSAAnimator.this._ioTape.getNumberOfSymbolsOnTape() + 1];
            FSAAnimator.this._transitionList = new Transition[FSAAnimator.this._ioTape.getNumberOfSymbolsOnTape()];
            FSAAnimator.this._statesSeen = 0;
            if (FSAAnimator.this._machine.getStartState() == null) {
                String message = "No start state defined.  Can't run machine until one is.";
                JOptionPane.showMessageDialog(null, message, "No start state", 0);
                return;
            }
            FSAAnimator.this._fsaPanel.enterRunMode();
            FSAAnimator.this._lightPanel.allLightsOff();
            FSAAnimator.this._controller.enterExecuteMode();
            FSAAnimator.this._ioTape.moveHeadHome();
            FSAAnimator.this._lightPanel.runningLightOn();
            FSAAnimator.this._animationControlPanel.setStepButtonEnabled(true);
            FSAAnimator.this._animationControlPanel.setCancelButtonEnabled(true);
            FSAAnimator.this.uncolor();
            FigureMover mover = FSAAnimator.this.createMover(FSAAnimator.this._machine.getStartState());
            FSAAnimator.this._movers.addElement(mover);
            FSAAnimator.this.handleEmptyTransitions();
            try {
                FSAAnimator.this._steppingLock.acquire();
                FSAAnimator.this._steppingLock.acquire();
            }
            catch (InterruptedException ie) {
                System.out.println("Interrupted Exception!");
                ie.printStackTrace();
            }
            while (!FSAAnimator.this._movers.isEmpty() && !FSAAnimator.this._stopFlag) {
                State state;
                FigureMover mover2;
                ListIterator<FigureMover> movers;
                FSAAnimator.this.clearMovers(FSAAnimator.this._deadMovers);
                Character symbol = FSAAnimator.this._ioTape.getSymbolAtHead();
                if (symbol != null) {
                    movers = FSAAnimator.this._movers.listIterator();
                    while (movers.hasNext()) {
                        mover2 = (FigureMover)movers.next();
                        state = mover2.getState();
                        FSAAnimator.this.touchState(state);
                        Iterator transitions = FSAAnimator.this._machine.transitionFunction(state, symbol);
                        if (transitions.hasNext()) {
                            Transition transition = (Transition)transitions.next();
                            FSAAnimator.this.prepareAnimation(mover2, transition);
                            FSAAnimator.this.touchTransition(transition);
                            if (FSAAnimator.this._movers.size() == 1) {
                                FSAAnimator.this._stateList[FSAAnimator.this._statesSeen] = state;
                                ++FSAAnimator.this._statesSeen;
                                FSAAnimator.this._stateList[FSAAnimator.this._statesSeen] = transition.getDestination();
                                FSAAnimator.this._transitionList[FSAAnimator.this._statesSeen - 1] = transition;
                                FSAAnimator.this.updateColor();
                            }
                            while (transitions.hasNext()) {
                                transition = (Transition)transitions.next();
                                FSAAnimator.this.touchTransition(transition);
                                FigureMover newMover = FSAAnimator.this.createMover(state);
                                FSAAnimator.this.prepareAnimation(newMover, transition);
                                movers.add(newMover);
                            }
                            continue;
                        }
                        movers.remove();
                        FSAAnimator.this._deadMovers.addElement(mover2);
                    }
                    FSAAnimator.this.colorMovers(FSAAnimator.this._deadMovers, Color.gray);
                    FSAAnimator.this.demoteMovers(FSAAnimator.this._deadMovers);
                    if (!FSAAnimator.this._movers.isEmpty()) {
                        FSAAnimator.this.animateMovers(FSAAnimator.this._movers);
                        FSAAnimator.this._ioTape.moveHeadRight();
                    } else {
                        FSAAnimator.this._lightPanel.rejectedLightOn();
                    }
                    FSAAnimator.this.handleEmptyTransitions();
                } else {
                    FSAAnimator.this._animationControlPanel.setCancelButtonEnabled(false);
                    if (FSAAnimator.this._movers.size() == 1) {
                        State state2;
                        FSAAnimator.this._stateList[FSAAnimator.this._statesSeen] = state2 = ((FigureMover)FSAAnimator.this._movers.get(0)).getState();
                        ++FSAAnimator.this._statesSeen;
                        FSAAnimator.this.updateColor();
                    }
                    movers = FSAAnimator.this._movers.listIterator();
                    while (movers.hasNext()) {
                        mover2 = (FigureMover)movers.next();
                        state = mover2.getState();
                        FSAAnimator.this.touchState(state);
                    }
                    if (FSAAnimator.this.moverInFinalState(FSAAnimator.this._movers)) {
                        FSAAnimator.this._lightPanel.acceptedLightOn();
                    } else {
                        FSAAnimator.this._lightPanel.rejectedLightOn();
                    }
                    FSAAnimator.this.killMovers();
                }
                FSAAnimator.this._animationControlPanel.setStepButtonEnabled(true);
                try {
                    FSAAnimator.this._steppingLock.acquire();
                }
                catch (InterruptedException ie) {
                    System.out.println("Interrupted Exception!");
                    ie.printStackTrace();
                }
                FSAAnimator.this._animationControlPanel.setStepButtonEnabled(false);
            }
            if (FSAAnimator.this._stopFlag) {
                FSAAnimator.this.killMovers();
                FSAAnimator.this._animationControlPanel.setStepButtonEnabled(false);
                FSAAnimator.this._animationControlPanel.setCancelButtonEnabled(false);
            }
            FSAAnimator.this.clearMovers(FSAAnimator.this._deadMovers);
            FSAAnimator.this._lightPanel.allLightsOff();
            FSAAnimator.this._controller.enterEditMode();
            FSAAnimator.this._stopFlag = false;
            FSAAnimator.this._steppingLock.release();
            FSAAnimator.this._fsaPanel.exitRunMode();
        }
    }

    class CancelAction
    extends AbstractAction {
        CancelAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            FSAAnimator.this._stopFlag = true;
            if (FSAAnimator.this._steppingLock.permits() == 0L) {
                FSAAnimator.this._steppingLock.release();
            }
            FSAAnimator.this._fsaPanel.exitRunMode();
        }
    }

    class StepAction
    extends AbstractAction {
        StepAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            if (FSAAnimator.this._steppingLock.permits() == 0L) {
                FSAAnimator.this._steppingLock.release();
            }
        }
    }

    class AnimateAction
    extends AbstractAction {
        AnimateAction() {
        }

        public void actionPerformed(ActionEvent ae) {
            new AnimationThread().start();
        }
    }
}

