/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.SymbolEvent;
import fsa.SymbolListener;
import fsa.SymbolSet;
import fsa.VetoableSymbolEvent;
import fsa.machine.State;
import fsa.machine.StateEvent;
import fsa.machine.StateListener;
import fsa.machine.StateMachine;
import fsa.machine.StatePropertyEvent;
import fsa.machine.Transition;
import fsa.machine.TransitionEvent;
import fsa.machine.TransitionListener;
import fsa.machine.TransitionMovedEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.jdom.Attribute;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class FSAFile {
    private Document _doc;
    private DocType _docType;
    private Element _alphabetElement = null;
    private Element _descriptionElement = null;
    private Element _finalStatesElement;
    private Element _initialStateElement;
    private Element _root;
    private Element _statesElement = null;
    private Element _transitionsElement = null;
    private HashMap _stateToElementMap;
    private HashMap _transitionToElementMap;
    private HashMap _statePropertyMap;
    private SAXBuilder _builder;
    private StateListener _stateListener;
    private StateMachine _machine;
    private String _systemId;
    private SymbolListener _alphabetListener;
    private SymbolSet _alphabet;
    private TransitionListener _transitionListener;
    private static final HashSet _empty = new HashSet();

    public FSAFile(StateMachine machine) {
        this._machine = machine;
        this._alphabet = this._machine.getAlphabet();
        this._stateToElementMap = new HashMap();
        this._transitionToElementMap = new HashMap();
        this._statePropertyMap = new HashMap();
        this._builder = new SAXBuilder(true);
        this._builder.setIgnoringElementContentWhitespace(true);
        this._systemId = this.getClass().getResource("/xml/fsa.dtd").toString();
        this._systemId = this._systemId.substring(0, this._systemId.lastIndexOf(47) + 1);
        this._stateListener = new FileStateListener();
        this._transitionListener = new FileTransitionListener();
        this._alphabetListener = new FileAlphabetListener();
        this.createDocument();
    }

    public void loadFile(InputStream inputStream) throws SAXException, IOException {
        this.reset();
        this.parseFile(inputStream);
        this._machine.removeStateListener(this._stateListener);
        this._machine.removeTransitionListener(this._transitionListener);
        this._alphabet.removeSymbolListener(this._alphabetListener);
        this.loadAlphabet();
        HashMap stateIDMap = this.loadStates();
        this.loadInitialState(stateIDMap);
        this.loadFinalStates(stateIDMap);
        this.loadTransitions(stateIDMap);
        this._machine.addStateListener(this._stateListener);
        this._machine.addTransitionListener(this._transitionListener);
        this._alphabet.addSymbolListener(this._alphabetListener);
    }

    public void saveFile(OutputStream outputStream) throws IOException {
        XMLOutputter outputter = new XMLOutputter();
        outputter.setEncoding("UTF-8");
        outputter.setIndent(true);
        outputter.setNewlines(true);
        outputter.output(this._doc, outputStream);
    }

    private void createDocument() {
        this._root = new Element("fsa");
        this._docType = new DocType("fsa", "fsa.dtd");
        this._doc = new Document(this._root, this._docType);
        this._descriptionElement = new Element("description");
        this._descriptionElement.setText(this._machine.getDescription());
        this._root.addContent(this._descriptionElement);
        this._alphabetElement = new Element("alphabet");
        this._alphabetElement.setText(this._alphabet.getSymbolString());
        this._root.addContent(this._alphabetElement);
        this._statesElement = new Element("states");
        this._root.addContent(this._statesElement);
        Iterator iterator = this._machine.getStates();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            StateEvent se = new StateEvent(this, 0, state);
            this._stateListener.stateAdded(se);
        }
        this._initialStateElement = new Element("initial_state");
        this._root.addContent(this._initialStateElement);
        this._stateListener.startStateChange(null);
        this._finalStatesElement = new Element("final_states");
        this._root.addContent(this._finalStatesElement);
        this._stateListener.finalStateChange(null);
        this._transitionsElement = new Element("transitions");
        this._root.addContent(this._transitionsElement);
        iterator = this._machine.getTransitions();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            TransitionEvent te = new TransitionEvent(this, 0, transition);
            this._transitionListener.transitionAdded(te);
        }
        this._machine.addStateListener(this._stateListener);
        this._machine.addTransitionListener(this._transitionListener);
        this._alphabet.addSymbolListener(this._alphabetListener);
    }

    private void reset() {
        this._machine.reset();
        this._machine.removeStateListener(this._stateListener);
        this._machine.removeTransitionListener(this._transitionListener);
        this._alphabet.removeSymbolListener(this._alphabetListener);
        this._stateToElementMap.clear();
        this._transitionToElementMap.clear();
        this._machine.addStateListener(this._stateListener);
        this._machine.addTransitionListener(this._transitionListener);
        this._alphabet.addSymbolListener(this._alphabetListener);
    }

    private void parseFile(InputStream inputStream) throws SAXException, IOException {
        try {
            this._doc = this._builder.build(inputStream, this._systemId);
            this._root = this._doc.getRootElement();
        }
        catch (JDOMException jde) {
            jde.printStackTrace();
            System.exit(1);
        }
    }

    private void loadDescription() {
        this._descriptionElement = this._root.getChild("description");
        this._machine.setDescription(this._descriptionElement.getText());
    }

    private void loadAlphabet() {
        this._alphabetElement = this._root.getChild("alphabet");
        String symbols = this._alphabetElement.getTextTrim();
        for (int i = 0; i < symbols.length(); ++i) {
            if (this._alphabet.contains(symbols.charAt(i))) continue;
            try {
                this._alphabet.addSymbol(symbols.charAt(i));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private HashMap loadStates() {
        Attribute idAttribute = null;
        HashMap<String, State> stateMap = new HashMap<String, State>();
        this._statesElement = this._root.getChild("states");
        Iterator states = this._statesElement.getChildren("state").iterator();
        while (states.hasNext()) {
            Element stateElement = (Element)states.next();
            idAttribute = stateElement.getAttribute("id");
            State state = new State();
            stateMap.put(idAttribute.getValue(), state);
            this._machine.addState(state);
            Iterator properties = stateElement.getChildren("property").iterator();
            while (properties.hasNext()) {
                Element propertyElement = (Element)properties.next();
                this.mapStateProperty(state, propertyElement);
                String propName = propertyElement.getAttributeValue("name");
                String propVal = propertyElement.getText();
                state.setProperty(propName, propVal);
            }
            idAttribute.setValue("s" + state.getKey());
            this.mapStateElement(state, stateElement);
        }
        return stateMap;
    }

    private void loadInitialState(HashMap stateMap) {
        this._initialStateElement = this._root.getChild("initial_state");
        Attribute attribute = this._initialStateElement.getAttribute("stateid");
        State initialState = (State)stateMap.get(attribute.getValue());
        if (initialState != null) {
            initialState.setStartState(true);
        }
        this._stateListener.startStateChange(null);
    }

    private void loadFinalStates(HashMap stateMap) {
        this._finalStatesElement = this._root.getChild("final_states");
        Attribute attribute = this._finalStatesElement.getAttribute("stateids");
        StringTokenizer strtok = new StringTokenizer(attribute.getValue(), " ");
        while (strtok.hasMoreTokens()) {
            String stateID = strtok.nextToken();
            State finalState = (State)stateMap.get(stateID);
            finalState.setFinalState(true);
        }
        this._stateListener.finalStateChange(null);
    }

    private void loadTransitions(HashMap stateMap) {
        Attribute stateAttribute = null;
        Attribute idAttribute = null;
        Attribute symbolAttribute = null;
        Attribute nextAttribute = null;
        this._transitionsElement = this._root.getChild("transitions");
        Iterator transitions = this._transitionsElement.getChildren("transition").iterator();
        while (transitions.hasNext()) {
            State endState;
            Element transitionElement = (Element)transitions.next();
            idAttribute = transitionElement.getAttribute("id");
            stateAttribute = transitionElement.getAttribute("state");
            symbolAttribute = transitionElement.getAttribute("symbol");
            nextAttribute = transitionElement.getAttribute("next_state");
            State startState = (State)stateMap.get(stateAttribute.getValue());
            Transition transition = this._machine.getTransition(startState, endState = (State)stateMap.get(nextAttribute.getValue()));
            if (transition == null) {
                transition = new Transition(startState, endState);
                this._machine.addTransition(transition);
            }
            String symbol = symbolAttribute.getValue();
            idAttribute.setValue("e" + transition.getKey() + symbol.charAt(0));
            stateAttribute.setValue("s" + startState.getKey());
            nextAttribute.setValue("s" + endState.getKey());
            SymbolSet transitionSymbols = transition.getSymbolSet();
            try {
                transitionSymbols.addSymbol(symbol.charAt(0));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mapTransitionElement(transition, transitionElement);
        }
    }

    private void mapStateElement(State state, Element element) {
        this._stateToElementMap.put(state, element);
    }

    private void unmapStateElement(State state) {
        this._stateToElementMap.remove(state);
    }

    private Element getStateElement(State state) {
        return (Element)this._stateToElementMap.get(state);
    }

    private void mapTransitionElement(Transition transition, Element element) {
        Attribute symbolAttribute = element.getAttribute("symbol");
        String symbol = symbolAttribute.getValue();
        HashMap<String, Element> elements = (HashMap<String, Element>)this._transitionToElementMap.get(transition);
        if (elements == null) {
            elements = new HashMap<String, Element>();
            this._transitionToElementMap.put(transition, elements);
        }
        elements.put(symbol, element);
    }

    private void unmapTransitionElement(Transition transition, String symbol) {
        HashMap elements = (HashMap)this._transitionToElementMap.get(transition);
        elements.remove(symbol);
    }

    private void unmapTransitionElements(Transition transition) {
        this._transitionToElementMap.remove(transition);
    }

    private Element getTransitionElement(Transition transition, String symbol) {
        HashMap elements = (HashMap)this._transitionToElementMap.get(transition);
        if (elements == null) {
            return null;
        }
        return (Element)elements.get(symbol);
    }

    private Iterator getTransitionElements(Transition transition) {
        HashMap elements = (HashMap)this._transitionToElementMap.get(transition);
        if (elements == null) {
            return _empty.iterator();
        }
        return elements.values().iterator();
    }

    private Iterator getTransitionMapSymbols(Transition transition) {
        HashMap elements = (HashMap)this._transitionToElementMap.get(transition);
        if (elements == null) {
            return _empty.iterator();
        }
        return elements.keySet().iterator();
    }

    private void mapStateProperty(State state, Element element) {
        Attribute nameAttribute = element.getAttribute("name");
        String propertyName = nameAttribute.getValue();
        HashMap<String, Element> elements = (HashMap<String, Element>)this._statePropertyMap.get(state);
        if (elements == null) {
            elements = new HashMap<String, Element>();
            this._statePropertyMap.put(state, elements);
        }
        elements.put(propertyName, element);
    }

    private Element getPropertyElement(State state, String propertyName) {
        Element element = null;
        HashMap elements = (HashMap)this._statePropertyMap.get(state);
        if (elements != null) {
            element = (Element)elements.get(propertyName);
        }
        return element;
    }

    private void unmapStateProperties(State state) {
        this._statePropertyMap.remove(state);
    }

    public StateMachine getStateMachine() {
        return this._machine;
    }

    private class FileAlphabetListener
    implements SymbolListener {
        private FileAlphabetListener() {
        }

        public void symbolsAdded(SymbolEvent e) {
            SymbolSet set = (SymbolSet)e.getSource();
            FSAFile.this._alphabetElement.setText(set.getSymbolString());
        }

        public void symbolsRemoved(SymbolEvent e) {
            SymbolSet set = (SymbolSet)e.getSource();
            FSAFile.this._alphabetElement.setText(set.getSymbolString());
        }

        public void aboutToAddSymbols(VetoableSymbolEvent e) {
        }

        public void aboutToRemoveSymbols(VetoableSymbolEvent e) {
        }
    }

    private class FileTransitionListener
    implements TransitionListener {
        private FileTransitionListener() {
        }

        public void transitionAdded(TransitionEvent te) {
            Transition transition = te.getTransition();
            String startKey = transition.getSource().getKey();
            String endKey = transition.getDestination().getKey();
            Iterator symbols = transition.getSymbolSet().getSymbols();
            while (symbols.hasNext()) {
                Character symbol = (Character)symbols.next();
                Element element = new Element("transition");
                element.setAttribute("id", "e" + transition.getKey() + symbol.toString());
                element.setAttribute("state", "s" + startKey);
                element.setAttribute("symbol", symbol.toString());
                element.setAttribute("next_state", "s" + endKey);
                FSAFile.this._transitionsElement.addContent(element);
                FSAFile.this.mapTransitionElement(transition, element);
            }
        }

        public void transitionRemoved(TransitionEvent te) {
            Transition transition = te.getTransition();
            Iterator symbols = transition.getSymbolSet().getSymbols();
            while (symbols.hasNext()) {
                Character symbol = (Character)symbols.next();
                Element element = FSAFile.this.getTransitionElement(transition, symbol.toString());
                FSAFile.this._transitionsElement.removeContent(element);
            }
            FSAFile.this.unmapTransitionElements(transition);
        }

        public void transitionSymbolsChanged(TransitionEvent te) {
            Element element;
            Transition transition = te.getTransition();
            SymbolSet tranSymbols = transition.getSymbolSet();
            String startKey = transition.getSource().getKey();
            String endKey = transition.getDestination().getKey();
            Iterator symbols = FSAFile.this.getTransitionMapSymbols(transition);
            while (symbols.hasNext()) {
                String mappedSymbol = (String)symbols.next();
                if (tranSymbols.contains(mappedSymbol.charAt(0))) continue;
                element = FSAFile.this.getTransitionElement(transition, mappedSymbol);
                FSAFile.this._transitionsElement.removeContent(element);
                FSAFile.this.unmapTransitionElement(transition, mappedSymbol);
            }
            symbols = tranSymbols.getSymbols();
            while (symbols.hasNext()) {
                Character symbol = (Character)symbols.next();
                element = FSAFile.this.getTransitionElement(transition, symbol.toString());
                if (element != null) continue;
                element = new Element("transition");
                element.setAttribute("id", "e" + transition.getKey() + symbol.toString());
                element.setAttribute("state", "s" + startKey);
                element.setAttribute("symbol", symbol.toString());
                element.setAttribute("next_state", "s" + endKey);
                FSAFile.this._transitionsElement.addContent(element);
                FSAFile.this.mapTransitionElement(transition, element);
            }
        }

        public void transitionMoved(TransitionMovedEvent tme) {
        }
    }

    private class FileStateListener
    implements StateListener {
        private FileStateListener() {
        }

        public void stateAdded(StateEvent se) {
            State state = se.getState();
            Element stateElement = new Element("state");
            stateElement.setAttribute("id", "s" + state.getKey());
            Iterator propertyNames = state.getPropertyNames();
            while (propertyNames.hasNext()) {
                String propertyName = (String)propertyNames.next();
                Element propertyElement = new Element("property");
                propertyElement.setAttribute("name", propertyName);
                propertyElement.setText(state.getProperty(propertyName));
                stateElement.addContent(propertyElement);
                FSAFile.this.mapStateProperty(state, propertyElement);
            }
            FSAFile.this._statesElement.addContent(stateElement);
            FSAFile.this.mapStateElement(state, stateElement);
        }

        public void stateRemoved(StateEvent se) {
            State state = se.getState();
            Element element = FSAFile.this.getStateElement(state);
            FSAFile.this._statesElement.removeContent(element);
            FSAFile.this.unmapStateElement(state);
            FSAFile.this.unmapStateProperties(state);
        }

        public void startStateChange(StateEvent se) {
            State state = FSAFile.this._machine.getStartState();
            if (state == null) {
                FSAFile.this._initialStateElement.setAttribute("stateid", "");
            } else {
                FSAFile.this._initialStateElement.setAttribute("stateid", "s" + state.getKey());
            }
        }

        public void finalStateChange(StateEvent se) {
            StringBuffer stateList = new StringBuffer();
            Iterator finalStates = FSAFile.this._machine.getFinalStates();
            while (finalStates.hasNext()) {
                State finalState = (State)finalStates.next();
                stateList.append("s" + finalState.getKey());
                if (!finalStates.hasNext()) continue;
                stateList.append(" ");
            }
            FSAFile.this._finalStatesElement.setAttribute("stateids", stateList.toString());
        }

        public void statePropertyChanged(StatePropertyEvent se) {
            State state = se.getState();
            String name = se.getPropertyName();
            Element stateElement = FSAFile.this.getStateElement(state);
            Element propertyElement = FSAFile.this.getPropertyElement(state, name);
            if (propertyElement == null) {
                propertyElement = new Element("property");
                stateElement.addContent(propertyElement);
                propertyElement.setAttribute("name", name);
                FSAFile.this.mapStateProperty(state, propertyElement);
            }
            propertyElement.setText(state.getProperty(name));
        }
    }
}

