/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.AnimationPath;
import java.awt.geom.Point2D;

public class LineAnimationPath
extends AnimationPath {
    private Point2D _dest;
    private Point2D _location;
    private int _steps;
    private int _stepCount;
    private double _xStep;
    private double _yStep;

    public LineAnimationPath(Point2D p1, Point2D p2) {
        double distance = p1.distance(p2);
        this._xStep = (p2.getX() - p1.getX()) / distance * 5.0;
        this._yStep = (p2.getY() - p1.getY()) / distance * 5.0;
        this._stepCount = 0;
        this._steps = (int)Math.floor(distance / 5.0);
        this._location = new Point2D.Double(p1.getX(), p1.getY());
        this._dest = new Point2D.Double(p2.getX(), p2.getY());
    }

    public Point2D next() {
        if (this._stepCount < this._steps) {
            ++this._stepCount;
            this._location.setLocation(this._location.getX() + this._xStep, this._location.getY() + this._yStep);
            return new Point2D.Double(this._location.getX(), this._location.getY());
        }
        if (this._stepCount == this._steps) {
            ++this._stepCount;
            return this._dest;
        }
        return null;
    }

    public boolean isDone() {
        return this._stepCount > this._steps;
    }
}

