/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.Figure;
import diva.canvas.FigureLayer;
import diva.canvas.Site;
import diva.canvas.connector.AutonomousSite;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorManipulator;
import diva.canvas.connector.ConnectorTarget;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.MouseFilter;
import diva.canvas.interactor.AbstractInteractor;
import diva.canvas.manipulator.GrabHandle;
import diva.graph.AbstractGraphController;
import diva.graph.EdgeInteractor;
import diva.graph.EdgeRenderer;
import diva.graph.GraphView;
import diva.graph.model.Edge;
import diva.graph.model.GraphModel;
import diva.graph.model.Node;
import fsa.FSAGraphPane;
import fsa.machine.State;

public class TransitionCreator
extends AbstractInteractor {
    public TransitionCreator() {
        this.setMouseFilter(new MouseFilter(16, 2));
    }

    public void mousePressed(LayerEvent event) {
        double x = event.getLayerX();
        double y = event.getLayerY();
        FigureLayer layer = (FigureLayer)event.getLayerSource();
        Figure source = event.getFigureSource();
        FSAGraphPane pane = (FSAGraphPane)layer.getCanvasPane();
        Node sourceNode = (Node)source.getUserObject();
        State sourceState = (State)sourceNode.getSemanticObject();
        GraphModel model = pane.getGraphModel();
        AbstractGraphController controller = (AbstractGraphController)pane.getGraphController();
        EdgeInteractor edgeInteractor = controller.getEdgeInteractor();
        ConnectorTarget connTarget = controller.getConnectorTarget();
        Site tailSite = connTarget.getTailSite(source, x, y);
        AutonomousSite headSite = new AutonomousSite(layer, x, y);
        Edge edge = model.createEdge(null);
        GraphView view = pane.getGraphView();
        EdgeRenderer edgeRenderer = view.getEdgeRenderer();
        Connector connector = edgeRenderer.render(edge, tailSite, headSite);
        connector.setInteractor(edgeInteractor);
        view.addEdgeFigureToLayer(connector);
        view.addEdgeMapping(edge, connector);
        model.setEdgeTail(edge, sourceNode);
        controller.getSelectionModel().addSelection(connector);
        ConnectorManipulator connManip = (ConnectorManipulator)connector.getParent();
        GrabHandle grabHandle = connManip.getHeadHandle();
        layer.grabPointer(event, grabHandle);
    }
}

