/*
 * Decompiled with CFR 0.152.
 */
package fsa.machine;

import fsa.SymbolSet;
import fsa.machine.State;
import fsa.machine.StateMachine;
import java.io.Serializable;

public class Transition
implements Serializable {
    State _source;
    State _destination;
    SymbolSet _symbols;
    String _key;
    StateMachine _owner;
    Object _userObject;

    public Transition(State source, State destination) {
        this._source = source;
        this._destination = destination;
        this._owner = null;
        this._symbols = new SymbolSet(this);
        this._key = Transition.generateKey(this._source, this._destination);
    }

    public static String generateKey(State source, State destination) {
        return source.toString() + "-" + destination.toString();
    }

    public String getKey() {
        return this._key;
    }

    protected String functionKey(Character symbol) {
        return Transition.generateFunctionKey(this._source, symbol);
    }

    protected String endpointKey() {
        return this._key;
    }

    public SymbolSet getSymbolSet() {
        return this._symbols;
    }

    public State getSource() {
        return this._source;
    }

    public State getDestination() {
        return this._destination;
    }

    protected void setDestination(State newDestination) {
        this._destination = newDestination;
        this._key = Transition.generateKey(this._source, this._destination);
    }

    public StateMachine getOwner() {
        return this._owner;
    }

    protected void setOwner(StateMachine owner) {
        this._owner = owner;
    }

    protected static String generateFunctionKey(State s, Character c) {
        return s.toString() + "," + c.toString();
    }

    public int hashCode() {
        return this._key.hashCode();
    }

    public String toString() {
        return this._key;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Transition) {
            Transition t = (Transition)obj;
            return this._source.equals(t._source) && this._destination.equals(t._destination) && this._symbols.equals(t._symbols) && this._key.equals(t._key);
        }
        return false;
    }

    public void setUserObject(Object userObject) {
        this._userObject = userObject;
    }

    public Object getUserObject() {
        return this._userObject;
    }
}

