/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasLayer;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.TransformContext;
import diva.canvas.interactor.Interactor;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractFigure
implements Figure {
    private Interactor _interactor = null;
    private Object _userObject = null;
    private boolean _visibility = true;
    private CanvasComponent _parent = null;

    public boolean contains(Point2D p) {
        return this.getShape().contains(p);
    }

    public Rectangle2D getBounds() {
        return this.getShape().getBounds2D();
    }

    public Interactor getInteractor() {
        return this._interactor;
    }

    public CanvasLayer getLayer() {
        if (this._parent == null) {
            return null;
        }
        if (this._parent instanceof CanvasLayer) {
            return (CanvasLayer)this._parent;
        }
        return ((Figure)this._parent).getLayer();
    }

    public abstract Shape getShape();

    public CanvasComponent getParent() {
        return this._parent;
    }

    public TransformContext getTransformContext() {
        if (this._parent == null) {
            return null;
        }
        return this._parent.getTransformContext();
    }

    public Object getUserObject() {
        return this._userObject;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        return this.intersects(r);
    }

    public boolean intersects(Rectangle2D r) {
        return this.getShape().intersects(r);
    }

    public boolean isVisible() {
        return this._visibility;
    }

    public abstract void paint(Graphics2D var1);

    public void paint(Graphics2D g, Rectangle2D r) {
        this.paint(g);
    }

    public void repaint() {
        if (this._parent != null) {
            this.repaint(DamageRegion.createDamageRegion(this._parent.getTransformContext(), this.getBounds()));
        }
    }

    public void repaint(DamageRegion d) {
        if (this._parent != null) {
            this._parent.repaint(d);
        }
    }

    public void setInteractor(Interactor interactor) {
        this._interactor = interactor;
    }

    public void setParent(CanvasComponent fc) {
        this._parent = fc;
        TransformContext c = this.getTransformContext();
        if (c != null) {
            c.invalidateCache();
        }
    }

    public void setUserObject(Object o) {
        this._userObject = o;
    }

    public void setVisible(boolean flag) {
        this._visibility = flag;
    }

    public abstract void transform(AffineTransform var1);

    public void translate(double x, double y) {
        this.transform(AffineTransform.getTranslateInstance(x, y));
    }
}

