/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasUtilities;
import diva.canvas.JCanvas;
import diva.canvas.TransformContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class DamageRegion {
    TransformContext _context;

    DamageRegion() {
    }

    public abstract void apply(JCanvas var1);

    public void checkCacheValid(TransformContext c) {
        this._context.checkCacheValid(c);
    }

    public static DamageRegion createDamageRegion(TransformContext c, Rectangle2D r) {
        return new RectangleDamageRegion(c, r);
    }

    public static DamageRegion createDamageRegion(TransformContext c, double x, double y, double w, double h) {
        return new RectangleDamageRegion(c, x, y, w, h);
    }

    public abstract void extend(Rectangle2D var1);

    public TransformContext getContext() {
        return this._context;
    }

    private static class RectangleDamageRegion
    extends DamageRegion {
        Rectangle2D _rectangle;

        private RectangleDamageRegion(TransformContext c, Rectangle2D r) {
            this._context = c;
            this._rectangle = r;
        }

        private RectangleDamageRegion(TransformContext c, double x, double y, double w, double h) {
            this._context = c;
            this._rectangle = new Rectangle2D.Double(x, y, w, h);
        }

        public void apply(JCanvas canvas) {
            Rectangle2D r = this._rectangle;
            AffineTransform t = this._context.getScreenTransform();
            if (!t.isIdentity()) {
                r = CanvasUtilities.isOrthogonal(t) ? (Rectangle2D)CanvasUtilities.transform(r, t) : t.createTransformedShape(r).getBounds2D();
            }
            double x = r.getX();
            double y = r.getY();
            double w = r.getWidth();
            double h = r.getHeight();
            double xdash = Math.floor(x);
            double ydash = Math.floor(y);
            double xdash1 = Math.ceil(x + w) - xdash;
            double ydash1 = Math.ceil(y + h) - ydash;
            canvas.repaint(0L, (int)xdash, (int)ydash, (int)xdash1, (int)ydash1);
        }

        public void extend(Rectangle2D r) {
            Rectangle2D.union(this._rectangle, r, this._rectangle);
        }

        public String toString() {
            return "Damage region: " + this._rectangle;
        }
    }
}

