/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.canvas.connector.Connector;
import diva.canvas.connector.ConnectorInteractor;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.connector.ConnectorTarget;
import diva.canvas.event.LayerEvent;
import diva.canvas.event.LayerEventMulticaster;
import diva.canvas.event.LayerMotionListener;
import diva.canvas.manipulator.BasicGrabHandleFactory;
import diva.canvas.manipulator.GrabHandle;
import diva.canvas.manipulator.GrabHandleFactory;
import diva.canvas.manipulator.Manipulator;
import diva.canvas.toolbox.BasicHighlighter;
import java.awt.Color;

public class ConnectorManipulator
extends Manipulator {
    LayerMotionListener _layerMotionListener;
    ConnectorTarget _connectorTarget;
    private double _snapHalo = 2.0;
    LayerMotionListener _targetHighlighter;
    String _targetProperty;
    String _targetPropertyValue;
    private GrabHandle _headHandle;
    private GrabHandle _tailHandle;

    public ConnectorManipulator() {
        this(new BasicGrabHandleFactory());
    }

    public ConnectorManipulator(GrabHandleFactory f) {
        this.setGrabHandleFactory(f);
        this.setHandleInteractor(new ConnectorInteractor(this));
        this.setTargetHighlighter(new TargetHighlighter());
    }

    public void addConnectorListener(ConnectorListener l) {
        ((ConnectorInteractor)this.getHandleInteractor()).addConnectorListener(l);
    }

    public void addLayerMotionListener(LayerMotionListener l) {
        this._layerMotionListener = LayerEventMulticaster.add(this._layerMotionListener, l);
    }

    public ConnectorTarget getConnectorTarget() {
        return this._connectorTarget;
    }

    public GrabHandle getHeadHandle() {
        return this._headHandle;
    }

    public GrabHandle getTailHandle() {
        return this._tailHandle;
    }

    public double getSnapHalo() {
        return this._snapHalo;
    }

    public LayerMotionListener getTargetHighlighter() {
        return this._targetHighlighter;
    }

    public FigureDecorator newInstance(Figure f) {
        ConnectorManipulator m = new ConnectorManipulator();
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        return m;
    }

    public void removeConnectorListener(ConnectorListener l) {
        ((ConnectorInteractor)this.getHandleInteractor()).removeConnectorListener(l);
    }

    public void removeLayerMotionListener(LayerMotionListener l) {
        this._layerMotionListener = LayerEventMulticaster.remove(this._layerMotionListener, l);
    }

    public void refresh() {
        Connector c = (Connector)this.getChild();
        if (c != null) {
            if (this._headHandle.getSite() != c.getHeadSite()) {
                this._headHandle.setSite(c.getHeadSite());
            }
            if (this._tailHandle.getSite() != c.getTailSite()) {
                this._tailHandle.setSite(c.getTailSite());
            }
        }
    }

    public void setChild(Figure f) {
        if (f == null) {
            super.setChild(null);
            this.clearGrabHandles();
            return;
        }
        if (!(f instanceof Connector)) {
            throw new IllegalArgumentException("Connector required by ConnectorManipulator");
        }
        this.clearGrabHandles();
        Connector c = (Connector)f;
        GrabHandleFactory factory = this.getGrabHandleFactory();
        this._headHandle = factory.createGrabHandle(c.getHeadSite());
        this._tailHandle = factory.createGrabHandle(c.getTailSite());
        this._headHandle.setParent(this);
        this._tailHandle.setParent(this);
        this._headHandle.setInteractor(this.getHandleInteractor());
        this._tailHandle.setInteractor(this.getHandleInteractor());
        this.addGrabHandle(this._headHandle);
        this.addGrabHandle(this._tailHandle);
        super.setChild(f);
    }

    public void setConnectorTarget(ConnectorTarget t) {
        this._connectorTarget = t;
    }

    public void setSnapHalo(double halo) {
        this._snapHalo = halo;
    }

    public void setTargetHighlighter(LayerMotionListener l) {
        this._targetHighlighter = l;
    }

    public void setTargetProperty(String key, String value) {
        this._targetProperty = key;
        this._targetPropertyValue = value;
    }

    static class TargetHighlighter
    implements LayerMotionListener {
        BasicHighlighter _high;
        FigureContainer _parent;

        TargetHighlighter() {
        }

        public void mouseEntered(LayerEvent e) {
            Figure f = e.getFigureSource();
            this._parent = (FigureContainer)f.getParent();
            if (this._parent != null) {
                this._high = new BasicHighlighter(Color.red, 2.0f);
                this._parent.decorate(f, this._high);
            }
        }

        public void mouseExited(LayerEvent e) {
            this._parent.undecorate(this._high);
            this._high = null;
            this._parent = null;
        }

        public void mouseMoved(LayerEvent e) {
        }
    }
}

