/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.event;

import diva.canvas.event.LayerEvent;
import java.awt.event.MouseEvent;

public class MouseFilter {
    public static MouseFilter defaultFilter = new MouseFilter(1);
    public static MouseFilter selectionFilter = new MouseFilter(1);
    public static MouseFilter alternateSelectionFilter = new MouseFilter(1, 1);
    private int _buttonMask = 28;
    private int _modifierMask = 3;
    private int _modifierFlags = 0;

    public MouseFilter(int button) {
        if (button <= 3) {
            switch (button) {
                case 1: {
                    button = 16;
                    break;
                }
                case 2: {
                    button = 8;
                    break;
                }
                case 3: {
                    button = 4;
                }
            }
        }
        this._buttonMask = button;
    }

    public MouseFilter(int button, int modifiers) {
        this(button);
        this._modifierFlags = modifiers;
    }

    public MouseFilter(int button, int modifiers, int mask) {
        this(button);
        this._modifierFlags = modifiers;
        this._modifierMask = mask;
    }

    public boolean accept(MouseEvent event) {
        int m = event.getModifiers();
        return (m & this._buttonMask) != 0 && this._modifierFlags == (m & this._modifierMask);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(super.toString() + "; Button " + LayerEvent.toString(this._buttonMask) + "; Modifiers " + LayerEvent.toString(this._modifierFlags) + "; Modifier mask " + LayerEvent.toString(this._modifierMask));
        return result.toString();
    }
}

