/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.manipulator;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.manipulator.Geometry;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class BoundsGeometry
implements Geometry {
    private Figure _parentFigure;
    private double _minSize = 1.0;
    private Rectangle2D _rect;
    private static int _siteCount = 9;
    private BoundsSite[] _sites = new BoundsSite[_siteCount];

    public BoundsGeometry(Figure figure, Rectangle2D bounds) {
        this._parentFigure = figure;
        this.setShape(bounds);
    }

    public Site getSite(int id) {
        if (this._sites[id] == null) {
            this._sites[id] = new BoundsSite(id);
        }
        return this._sites[id];
    }

    public double getMinimumSize() {
        return this._minSize;
    }

    public Site getNE() {
        return this.getSite(2);
    }

    public Site getNW() {
        return this.getSite(8);
    }

    public Site getSE() {
        return this.getSite(4);
    }

    public Site getSW() {
        return this.getSite(6);
    }

    public Site getN() {
        return this.getSite(1);
    }

    public Site getS() {
        return this.getSite(5);
    }

    public Site getE() {
        return this.getSite(3);
    }

    public Site getW() {
        return this.getSite(7);
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public Shape getShape() {
        return this._rect;
    }

    public Rectangle2D getBounds() {
        return this._rect;
    }

    public void setMinimumSize(double minimumSize) {
        this._minSize = minimumSize;
    }

    public void setShape(Shape shape) {
        if (!(shape instanceof Rectangle2D)) {
            throw new IllegalArgumentException("Argument must be a Rectangle2D");
        }
        this._rect = (Rectangle2D)((Rectangle2D)shape).clone();
    }

    public void setBounds(Rectangle2D rect) {
        this._rect = (Rectangle2D)rect.clone();
    }

    public Iterator sites() {
        return new Iterator(){
            int cursor = 1;

            public boolean hasNext() {
                return this.cursor < _siteCount;
            }

            public Object next() {
                if (BoundsGeometry.this._sites[this.cursor] == null) {
                    ((BoundsGeometry)BoundsGeometry.this)._sites[this.cursor] = new BoundsSite(this.cursor);
                }
                BoundsSite result = BoundsGeometry.this._sites[this.cursor];
                ++this.cursor;
                return result;
            }

            public void remove() {
                throw new UnsupportedOperationException("Sites cannot be removed");
            }
        };
    }

    public void translate(double x, double y) {
        this._rect.setFrame(this._rect.getX() + x, this._rect.getY() + y, this._rect.getWidth(), this._rect.getHeight());
    }

    public class BoundsSite
    extends AbstractSite {
        private int _id;
        private double piOver4 = 0.7853981633974483;

        BoundsSite(int id) {
            this._id = id;
        }

        public int getID() {
            return this._id;
        }

        public Figure getFigure() {
            return BoundsGeometry.this._parentFigure;
        }

        public double getNormal() {
            switch (this._id) {
                case 3: {
                    return 0.0;
                }
                case 2: {
                    return this.piOver4 * 7.0;
                }
                case 1: {
                    return this.piOver4 * 6.0;
                }
                case 8: {
                    return this.piOver4 * 5.0;
                }
                case 7: {
                    return this.piOver4 * 4.0;
                }
                case 6: {
                    return this.piOver4 * 3.0;
                }
                case 5: {
                    return this.piOver4 * 2.0;
                }
                case 4: {
                    return this.piOver4 * 1.0;
                }
            }
            return 0.0;
        }

        public Point2D getPoint() {
            return new Point2D.Double(this.getX(), this.getY());
        }

        public double getX() {
            switch (this._id) {
                case 6: 
                case 7: 
                case 8: {
                    return BoundsGeometry.this._rect.getX();
                }
                case 2: 
                case 3: 
                case 4: {
                    return BoundsGeometry.this._rect.getX() + BoundsGeometry.this._rect.getWidth();
                }
                case 1: 
                case 5: {
                    return BoundsGeometry.this._rect.getX() + BoundsGeometry.this._rect.getWidth() / 2.0;
                }
            }
            return 0.0;
        }

        public double getY() {
            switch (this._id) {
                case 1: 
                case 2: 
                case 8: {
                    return BoundsGeometry.this._rect.getY();
                }
                case 4: 
                case 5: 
                case 6: {
                    return BoundsGeometry.this._rect.getY() + BoundsGeometry.this._rect.getHeight();
                }
                case 3: 
                case 7: {
                    return BoundsGeometry.this._rect.getY() + BoundsGeometry.this._rect.getHeight() / 2.0;
                }
            }
            return 0.0;
        }

        public boolean hasNormal() {
            return true;
        }

        public boolean isNormal(int direction) {
            return direction == this._id;
        }

        public void translate(double x, double y) {
            double x1 = BoundsGeometry.this._rect.getX();
            double y1 = BoundsGeometry.this._rect.getY();
            double x2 = x1 + BoundsGeometry.this._rect.getWidth();
            double y2 = y1 + BoundsGeometry.this._rect.getHeight();
            switch (this._id) {
                case 8: {
                    x1 += x;
                    y1 += y;
                    break;
                }
                case 6: {
                    x1 += x;
                    y2 += y;
                    break;
                }
                case 7: {
                    x1 += x;
                    break;
                }
                case 2: {
                    x2 += x;
                    y1 += y;
                    break;
                }
                case 4: {
                    x2 += x;
                    y2 += y;
                    break;
                }
                case 3: {
                    x2 += x;
                    break;
                }
                case 1: {
                    y1 += y;
                    break;
                }
                case 5: {
                    y2 += y;
                }
            }
            switch (this._id) {
                case 2: 
                case 3: 
                case 4: {
                    if (!(x2 < x1 + BoundsGeometry.this._minSize)) break;
                    x2 = x1 + BoundsGeometry.this._minSize;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    if (!(x1 > x2 - BoundsGeometry.this._minSize)) break;
                    x1 = x2 - BoundsGeometry.this._minSize;
                }
            }
            switch (this._id) {
                case 1: 
                case 2: 
                case 8: {
                    if (!(y1 > y2 - BoundsGeometry.this._minSize)) break;
                    y1 = y2 - BoundsGeometry.this._minSize;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    if (!(y2 < y1 + BoundsGeometry.this._minSize)) break;
                    y2 = y1 + BoundsGeometry.this._minSize;
                }
            }
            BoundsGeometry.this._rect.setFrameFromDiagonal(x1, y1, x2, y2);
        }

        public void setPoint(Point2D point) {
            this.translate(point.getX() - this.getX(), point.getY() - this.getY());
        }
    }
}

