/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.manipulator;

import diva.canvas.CanvasUtilities;
import diva.canvas.Figure;
import diva.canvas.FigureDecorator;
import diva.canvas.Site;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.DragInteractor;
import diva.canvas.manipulator.BasicGrabHandleFactory;
import diva.canvas.manipulator.BoundsGeometry;
import diva.canvas.manipulator.GrabHandle;
import diva.canvas.manipulator.GrabHandleFactory;
import diva.canvas.manipulator.Manipulator;
import java.util.Iterator;

public class BoundsManipulator
extends Manipulator {
    private BoundsGeometry _geometry;

    public BoundsManipulator() {
        this(new BasicGrabHandleFactory());
    }

    public BoundsManipulator(GrabHandleFactory f) {
        this.setGrabHandleFactory(f);
        this.setHandleInteractor(new Resizer());
    }

    private BoundsGeometry getGeometry() {
        return this._geometry;
    }

    public FigureDecorator newInstance(Figure f) {
        BoundsManipulator m = new BoundsManipulator();
        m.setGrabHandleFactory(this.getGrabHandleFactory());
        m.setHandleInteractor(this.getHandleInteractor());
        return m;
    }

    public void refresh() {
        if (this._geometry != null) {
            this._geometry.setBounds(this.getChild().getShape().getBounds2D());
        }
    }

    public void setChild(Figure child) {
        super.setChild(child);
        this.clearGrabHandles();
        if (child != null) {
            this._geometry = new BoundsGeometry(this, this.getChild().getShape().getBounds2D());
            Iterator i = this._geometry.sites();
            GrabHandle g = null;
            while (i.hasNext()) {
                Site site = (Site)i.next();
                g = this.getGrabHandleFactory().createGrabHandle(site);
                g.setParent(this);
                g.setInteractor(this.getHandleInteractor());
                this.addGrabHandle(g);
            }
            this.relocateGrabHandles();
            this._geometry.setMinimumSize(4.0f * g.getSize());
        }
    }

    private static class Resizer
    extends DragInteractor {
        private Resizer() {
        }

        public void translate(LayerEvent e, double x, double y) {
            GrabHandle g = (GrabHandle)e.getFigureSource();
            g.translate(x, y);
            BoundsManipulator parent = (BoundsManipulator)g.getParent();
            BoundsGeometry geometry = parent.getGeometry();
            parent.getChild().transform(CanvasUtilities.computeTransform(parent.getChild().getShape().getBounds2D(), geometry.getBounds()));
        }
    }
}

