/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.GlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.Node;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;

public class GridAnnealingLayout
implements GlobalLayout {
    private static final double HEIGHT_FACTOR = 1.0;
    private static final double WIDTH_FACTOR = 1.0;
    private static final double ELBOW_PENALTY = 10.0;
    private static final double EDGE_OVERLAP_PENALTY = 30.0;
    private static final double TEE_PENALTY = 30.0;
    private static final double CROSSING_PENALTY = 10.0;
    protected Random _random = new Random(System.currentTimeMillis());
    protected LayoutTarget _target;
    protected Graph _graph;
    protected int _gw;
    protected int _gh;
    protected Node[][] _grid;
    protected Node[][] _minGrid;
    protected double _minCost;
    protected HashMap _map;
    protected double _sparseness = 1.0;
    protected int _numIters = 5;
    protected int _numMoves = 10;
    protected double _cool = 0.95;

    private void anneal() {
        this._minCost = 0.0;
        double curCost = 0.0;
        double prob = 1.0;
        this.snapMin();
        for (int i = 0; i < this._numIters; ++i) {
            for (int j = 0; j < this._numMoves; ++j) {
                int y2;
                int x2;
                Node n2;
                int y1;
                prob *= this._cool;
                int x1 = (int)(this._random.nextDouble() * (double)this._gw);
                Node n1 = this._grid[x1][y1 = (int)(this._random.nextDouble() * (double)this._gh)];
                if (n1 == (n2 = this._grid[x2 = (int)(this._random.nextDouble() * (double)this._gw)][y2 = (int)(this._random.nextDouble() * (double)this._gh)])) continue;
                double startCost = this.nodeCost(n1) + this.nodeCost(n2);
                if (n1 == null) {
                    this.setXY(n2, x1, y1);
                } else if (n2 == null) {
                    this.setXY(n1, x2, y2);
                } else {
                    this.swap(n1, n2);
                }
                double endCost = this.nodeCost(n1) + this.nodeCost(n2);
                double deltaCost = endCost - startCost;
                curCost += deltaCost;
                if (curCost < this._minCost) {
                    this._minCost = curCost;
                    this.snapMin();
                }
                if (!(deltaCost > 0.0) || !(this._random.nextDouble() > prob)) continue;
                curCost -= deltaCost;
                if (n1 == null) {
                    this.setXY(n2, x2, y2);
                    continue;
                }
                if (n2 == null) {
                    this.setXY(n1, x1, y1);
                    continue;
                }
                this.swap(n1, n2);
            }
        }
    }

    private final void ASSERT(boolean b, String err) throws RuntimeException {
        if (!b) {
            throw new RuntimeException(err);
        }
    }

    private void assignLayout() {
        Rectangle2D dim = this._target.getViewport(this._graph);
        double[] placeX = new double[this._gw];
        for (int x = 0; x < this._gw; ++x) {
            placeX[x] = (double)x * dim.getWidth() / (double)this._gw;
        }
        double[] placeY = new double[this._gh];
        for (int y = 0; y < this._gh; ++y) {
            placeY[y] = (double)y * dim.getWidth() / (double)this._gh;
        }
        Rectangle2D viewport = this._target.getViewport(this._graph);
        for (int i = 0; i < this._gw; ++i) {
            for (int j = 0; j < this._gh; ++j) {
                this.ASSERT(this._minGrid != null, "Null min grid!");
                Node n = this._minGrid[i][j];
                if (n == null) continue;
                double x = this._gw > 1 ? (double)i * dim.getWidth() / (double)(this._gw - 1) + dim.getX() : dim.getX() + dim.getWidth() / 2.0;
                double y = this._gh > 1 ? (double)j * dim.getHeight() / (double)(this._gh - 1) + dim.getY() : dim.getY() + dim.getHeight() / 2.0;
                LayoutUtilities.placeNoReroute(this._target, n, x, y);
            }
        }
        LayoutUtilities.routeVisibleEdges(this._graph, this._target);
    }

    private void cleanupStructures() {
        this._map = null;
        this._target = null;
        this._grid = null;
        this._minGrid = null;
        this._minCost = Double.MAX_VALUE;
        this._gw = -1;
        this._gh = -1;
    }

    private void debug(String s) {
        System.err.println(s);
    }

    protected double edgeCost(Edge e) {
        Node tail = e.getTail();
        Node head = e.getHead();
        if (head == null || tail == null) {
            return 0.0;
        }
        int[] ptail = this.getXY(tail);
        int[] phead = this.getXY(head);
        double heightCost = 1.0 * (double)Math.abs(phead[1] - ptail[1]);
        double widthCost = 1.0 * (double)Math.abs(phead[0] - ptail[0]);
        double elbowCost = heightCost == 0.0 || widthCost == 0.0 ? 0.0 : 10.0;
        double overlapCost = (double)this.numOverlaps(e, this._graph) * 30.0;
        double crossingCost = (double)this.numCrossings(e, this._graph) * 10.0;
        return heightCost + widthCost + elbowCost + overlapCost + crossingCost;
    }

    public double getCoolingFactor() {
        return this._cool;
    }

    public int getIterationCount(int cnt) {
        return this._numIters;
    }

    public int getMoveCount(int cnt) {
        return this._numIters;
    }

    public double getSparseness() {
        return this._sparseness;
    }

    protected int[] getXY(Node n) {
        return (int[])this._map.get(n);
    }

    protected void initGrid() {
        if (this._graph.getNodeCount() > 0) {
            Rectangle2D dim = this._target.getViewport(this._graph);
            double aspect = dim.getHeight() / dim.getWidth();
            double gh = Math.sqrt((double)this._graph.getNodeCount() * aspect) * this._sparseness;
            this._gh = (int)Math.ceil(gh);
            this._gw = (int)Math.ceil(gh / aspect);
            this._grid = new Node[this._gw][this._gh];
            Iterator nodes = this._graph.nodes();
            for (int x = 0; x < this._gw; ++x) {
                for (int y = 0; y < this._gh && nodes.hasNext(); ++y) {
                    Node n = (Node)nodes.next();
                    this.setXY(n, x, y);
                }
            }
        }
    }

    public void layout(LayoutTarget target, Graph g) {
        this._target = target;
        this._graph = g;
        this._map = new HashMap();
        if (this._graph.getNodeCount() > 0) {
            this.initGrid();
            this.anneal();
            this.assignLayout();
            this.cleanupStructures();
        }
    }

    protected double nodeCost(Node n) {
        if (n == null) {
            return 0.0;
        }
        int cost = 0;
        Iterator i = n.inEdges();
        while (i.hasNext()) {
            cost = (int)((double)cost + this.edgeCost((Edge)i.next()));
        }
        i = n.outEdges();
        while (i.hasNext()) {
            cost = (int)((double)cost + this.edgeCost((Edge)i.next()));
        }
        double teeCost = (double)this.numTees(this._graph) * 30.0;
        cost = (int)((double)cost + teeCost);
        return cost;
    }

    protected final int numCrossings(Edge in, Graph g) {
        int num = 0;
        Node inTail = in.getTail();
        Node inHead = in.getHead();
        if (inHead == null || inTail == null) {
            return 0;
        }
        int[] inTailPt = this.getXY(inTail);
        int[] inHeadPt = this.getXY(inHead);
        Iterator i = g.nodes();
        while (i.hasNext()) {
            Node n = (Node)i.next();
            Iterator j = n.outEdges();
            while (j.hasNext()) {
                Edge e = (Edge)j.next();
                Node t = e.getTail();
                Node h = e.getHead();
                if (t == null || h == null || t == inTail || t == inHead || h == inTail || h == inHead) continue;
                int[] tailPt = this.getXY(t);
                int[] headPt = this.getXY(h);
                Line2D.Double l = new Line2D.Double(tailPt[0], tailPt[1], headPt[0], headPt[1]);
                if (!Line2D.linesIntersect(inTailPt[0], inTailPt[1], inHeadPt[0], inHeadPt[1], tailPt[0], tailPt[1], headPt[0], headPt[1])) continue;
                ++num;
            }
        }
        return num;
    }

    protected final int numTees(Graph g) {
        return 0;
    }

    protected final int numOverlaps(Edge in, Graph g) {
        int num = 0;
        Node inTail = in.getTail();
        Node inHead = in.getHead();
        if (inHead == null || inTail == null) {
            return 0;
        }
        int[] inTailPt = this.getXY(inTail);
        int[] inHeadPt = this.getXY(inHead);
        for (int which = 0; which < 2; ++which) {
            if (inTailPt[which] != inHeadPt[which]) continue;
            Iterator i = g.nodes();
            while (i.hasNext()) {
                Node n = (Node)i.next();
                Iterator j = n.outEdges();
                while (j.hasNext()) {
                    int[] headPt;
                    int[] tailPt;
                    Edge e = (Edge)j.next();
                    Node t = e.getTail();
                    Node h = e.getHead();
                    if (h == null || t == null || (tailPt = this.getXY(t))[which] != (headPt = this.getXY(h))[which] || tailPt[which] != inTailPt[which]) continue;
                    int other = which + 1;
                    ++num;
                }
            }
            break;
        }
        return num;
    }

    public void setCoolingFactor(double val) {
        if (val <= 0.0 || val > 1.0) {
            String err = "Cooling factor must be greater than 0 and less or equal to 1: " + val;
            throw new IllegalArgumentException(err);
        }
        this._cool = val;
    }

    public void setIterationCount(int cnt) {
        this._numIters = cnt;
    }

    public void setMoveCount(int cnt) {
        this._numIters = cnt;
    }

    public void setSparseness(double val) {
        if (val < 1.0) {
            String err = "Illegal sparseness value: " + val;
            throw new IllegalArgumentException(err);
        }
        this._sparseness = val;
    }

    protected void setXY(Node n, int x, int y) {
        int[] pos = (int[])this._map.get(n);
        if (pos == null) {
            pos = new int[2];
            this._map.put(n, pos);
        }
        this._grid[x][y] = n;
        pos[0] = x;
        pos[1] = y;
    }

    private void snapMin() {
        if (this._minGrid == null) {
            this._minGrid = new Node[this._gw][this._gh];
        }
        for (int x = 0; x < this._gw; ++x) {
            for (int y = 0; y < this._gh; ++y) {
                this._minGrid[x][y] = this._grid[x][y];
            }
        }
    }

    private void swap(Node n1, Node n2) {
        int[] xy1 = this.getXY(n1);
        int[] xy2 = this.getXY(n2);
        int xtmp = xy1[0];
        int ytmp = xy1[1];
        this.setXY(n1, xy2[0], xy2[1]);
        this.setXY(n2, xtmp, ytmp);
    }
}

