/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.model;

import diva.graph.model.BasicGraphImpl;
import diva.graph.model.CompositeNode;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphEvent;
import diva.graph.model.GraphEventMulticaster;
import diva.graph.model.GraphImpl;
import diva.graph.model.GraphListener;
import diva.graph.model.Node;
import diva.util.PropertyContainer;
import diva.util.SemanticObjectChangeEvent;
import diva.util.SemanticObjectChangeListener;
import diva.util.SemanticObjectContainer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;

public class GraphModel {
    private GraphImpl _graphImpl = null;
    private Graph _graph = null;
    private boolean _dispatch = true;
    private GraphEventMulticaster _graphListeners;
    private EventListenerList _otherListeners;
    static /* synthetic */ Class class$java$beans$PropertyChangeListener;
    static /* synthetic */ Class class$diva$util$SemanticObjectChangeListener;

    public GraphModel() {
        this(new BasicGraphImpl());
    }

    public GraphModel(GraphImpl gi) {
        this._graphImpl = gi;
        this._graphListeners = new GraphEventMulticaster();
        this._otherListeners = new EventListenerList();
        this._graph = this._graphImpl.createGraph(null);
    }

    public void addGraphListener(GraphListener l) {
        this._graphListeners.add(l);
    }

    public void addNode(Node n) {
        this.addNode(n, this.getGraph());
    }

    public void addNode(Node n, Graph parent) {
        Graph prevParent = n.getParent();
        GraphEvent e = new GraphEvent(20, this, n, prevParent);
        this._graphImpl.addNode(n, parent);
        this.dispatchGraphEvent(e);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this._otherListeners.add(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = GraphModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
    }

    public void addSemanticObjectChangeListener(SemanticObjectChangeListener l) {
        this._otherListeners.add(class$diva$util$SemanticObjectChangeListener == null ? (class$diva$util$SemanticObjectChangeListener = GraphModel.class$("diva.util.SemanticObjectChangeListener")) : class$diva$util$SemanticObjectChangeListener, l);
    }

    public void connectEdge(Edge e, Node tail, Node head) {
        Node prevHead = e.getHead();
        Node prevTail = e.getTail();
        this._graphImpl.setEdgeTail(e, tail);
        this._graphImpl.setEdgeHead(e, head);
        this.dispatchGraphEvent(new GraphEvent(11, this, e, prevHead));
        this.dispatchGraphEvent(new GraphEvent(12, this, e, prevTail));
    }

    public CompositeNode createCompositeNode() {
        return this.createCompositeNode(null);
    }

    public CompositeNode createCompositeNode(Object semanticObject) {
        return this._graphImpl.createCompositeNode(semanticObject);
    }

    public Edge createEdge() {
        return this.createEdge(null);
    }

    public Edge createEdge(Object semanticObject, Node tail, Node head) {
        Edge e = this.createEdge(semanticObject);
        this.connectEdge(e, tail, head);
        return e;
    }

    public Edge createEdge(Object semanticObject) {
        return this._graphImpl.createEdge(semanticObject);
    }

    public Edge createEdge(Node tail, Node head) {
        return this.createEdge(null, tail, head);
    }

    public Node createNode() {
        return this.createNode(null);
    }

    public Node createNode(Object semanticObject) {
        return this._graphImpl.createNode(semanticObject);
    }

    public void dispatchSemanticObjectChangeEvent(SemanticObjectChangeEvent e) {
        if (this._dispatch) {
            Object[] listeners = this._otherListeners.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$diva$util$SemanticObjectChangeListener == null ? GraphModel.class$("diva.util.SemanticObjectChangeListener") : class$diva$util$SemanticObjectChangeListener)) continue;
                ((SemanticObjectChangeListener)listeners[i + 1]).objectChange(e);
            }
        }
    }

    public void dispatchPropertyChangeEvent(PropertyChangeEvent e) {
        if (this._dispatch) {
            Object[] listeners = this._otherListeners.getListenerList();
            for (int i = listeners.length - 2; i >= 0; i -= 2) {
                if (listeners[i] != (class$java$beans$PropertyChangeListener == null ? GraphModel.class$("java.beans.PropertyChangeListener") : class$java$beans$PropertyChangeListener)) continue;
                ((PropertyChangeListener)listeners[i + 1]).propertyChange(e);
            }
        }
    }

    public void dispatchGraphEvent(GraphEvent e) {
        if (this._dispatch) {
            this._graphListeners.dispatchEvent(e);
        }
    }

    public void disconnectEdge(Edge e) {
        this.setEdgeTail(e, null);
        this.setEdgeHead(e, null);
    }

    public Graph getGraph() {
        return this._graph;
    }

    public GraphImpl getGraphImpl() {
        return this._graphImpl;
    }

    public void removeGraphListener(GraphListener l) {
        this._graphListeners.remove(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this._otherListeners.remove(class$java$beans$PropertyChangeListener == null ? (class$java$beans$PropertyChangeListener = GraphModel.class$("java.beans.PropertyChangeListener")) : class$java$beans$PropertyChangeListener, l);
    }

    public void removeSemanticObjectChangeListener(SemanticObjectChangeListener l) {
        this._otherListeners.remove(class$diva$util$SemanticObjectChangeListener == null ? (class$diva$util$SemanticObjectChangeListener = GraphModel.class$("diva.util.SemanticObjectChangeListener")) : class$diva$util$SemanticObjectChangeListener, l);
    }

    public void removeNode(Node n) {
        Graph parent = n.getParent();
        this._graphImpl.removeNode(n);
        this.dispatchGraphEvent(new GraphEvent(21, this, n, parent));
    }

    public void setDispatchEnabled(boolean val) {
        this._dispatch = val;
    }

    public void setEdgeHead(Edge e, Node head) {
        Node prevHead = e.getHead();
        this._graphImpl.setEdgeHead(e, head);
        this.dispatchGraphEvent(new GraphEvent(11, this, e, prevHead));
    }

    public void setEdgeTail(Edge e, Node tail) {
        Node prevTail = e.getTail();
        this._graphImpl.setEdgeTail(e, tail);
        this.dispatchGraphEvent(new GraphEvent(12, this, e, prevTail));
    }

    public void setProperty(PropertyContainer pc, String propName, Object o) {
        Object prev = pc.getProperty(propName);
        pc.setProperty(propName, o);
        this.dispatchPropertyChangeEvent(new PropertyChangeEvent(pc, propName, prev, o));
    }

    public void setSemanticObject(SemanticObjectContainer uoc, Object o) {
        Object prev = uoc.getSemanticObject();
        uoc.setSemanticObject(o);
        SemanticObjectChangeEvent e = new SemanticObjectChangeEvent(uoc, prev);
        this.dispatchSemanticObjectChangeEvent(e);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

