/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.schematic;

import diva.graph.layout.IncrementalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.layout.ProxyIncrLayout;
import diva.graph.model.GraphEvent;
import diva.graph.model.Node;
import diva.util.Filter;
import diva.util.FilteredIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class SchematicIncrLayout
extends ProxyIncrLayout
implements IncrementalLayout {
    private LayoutTarget _env;
    private double _portOffset = 30.0;
    public static int NORTH = 0;
    public static int SOUTH = 1;
    public static int EAST = 2;
    public static int WEST = 3;

    public SchematicIncrLayout(LayoutTarget env, IncrementalLayout target) {
        super(target);
        this._env = env;
    }

    public SchematicIncrLayout(LayoutTarget env, IncrementalLayout target, double portOffset) {
        this(env, target);
        this._portOffset = portOffset;
    }

    public abstract boolean isPort(Node var1);

    public abstract int getPortLocation(Node var1);

    public void nodeAdded(GraphEvent evt) {
        double incr;
        Node n = (Node)evt.getTarget();
        if (!this.isPort(n)) {
            super.nodeAdded(evt);
            return;
        }
        final int pos = this.getPortLocation(n);
        ArrayList portList = new ArrayList();
        FilteredIterator i = new FilteredIterator(n.getParent().nodes(), new Filter(){

            public boolean accept(Object o) {
                Node n2 = (Node)o;
                return SchematicIncrLayout.this.isPort(n2) && SchematicIncrLayout.this.getPortLocation(n2) == pos;
            }
        });
        while (i.hasNext()) {
            portList.add(i.next());
        }
        Rectangle2D vp = this._env.getViewport(n.getParent());
        double span = pos == NORTH || pos == SOUTH ? vp.getWidth() : vp.getHeight();
        double off = portList.size() > 1 ? this._portOffset : span / 2.0;
        double d = incr = portList.size() > 1 ? (span - 2.0 * this._portOffset) / (double)(portList.size() - 1) : 0.0;
        if (pos == NORTH || pos == SOUTH) {
            double y = pos == NORTH ? vp.getY() : vp.getY() + vp.getHeight();
            double x = off;
            Iterator j = portList.iterator();
            while (j.hasNext()) {
                Node p = (Node)j.next();
                LayoutUtilities.place(this._env, p, x, y);
                x += incr;
            }
        } else {
            double x = pos == WEST ? vp.getX() : vp.getX() + vp.getWidth();
            double y = off;
            Iterator j = portList.iterator();
            while (j.hasNext()) {
                Node p = (Node)j.next();
                LayoutUtilities.place(this._env, p, x, y);
                y += incr;
            }
        }
    }

    public void nodeRemoved(GraphEvent evt) {
        Node n = (Node)evt.getTarget();
        if (!this.isPort(n)) {
            super.nodeRemoved(evt);
            return;
        }
    }

    private void debug(String s) {
        System.err.println("SchematicIncrLayout: " + s);
    }
}

