/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.GraphicsPane;
import diva.canvas.connector.ArcManipulator;
import diva.canvas.event.MouseFilter;
import diva.canvas.selection.SelectionDragger;
import diva.canvas.selection.SelectionModel;
import diva.canvas.selection.SelectionRenderer;
import diva.graph.AbstractGraphController;
import diva.graph.EdgeInteractor;
import diva.graph.GraphView;
import diva.graph.NodeInteractor;
import diva.graph.model.Edge;
import diva.graph.model.Node;
import fsa.StateFigure;
import fsa.StatePerimeterTarget;
import fsa.StatePopupMenu;
import fsa.StatePositionListener;
import fsa.SymbolDialog;
import fsa.TransitionConnector;
import fsa.TransitionCreator;
import fsa.TransitionPopupMenu;
import fsa.TransitionProxy;
import fsa.machine.State;
import fsa.machine.StateMachine;
import fsa.machine.Transition;

public class FSAGraphController
extends AbstractGraphController {
    SelectionRenderer _editRenderer;
    SelectionRenderer _executeRenderer;

    public FSAGraphController(StateMachine machine, SymbolDialog dialog) {
        SelectionModel sm = this.getSelectionModel();
        sm.setSelectionMode(0);
        NodeInteractor ni = new NodeInteractor(this, sm);
        this._editRenderer = ni.getSelectionRenderer();
        MouseFilter mouseFilter = new MouseFilter(20);
        ni.setSelectionFilter(mouseFilter);
        ni.addInteractor(new TransitionCreator());
        ni.addInteractor(new StatePopupMenu(machine));
        ni.getDragInteractor().addLayerListener(new StatePositionListener());
        this.setNodeInteractor(ni);
        EdgeInteractor ei = new EdgeInteractor(this, sm);
        ei.setSelectionFilter(mouseFilter);
        ei.addInteractor(new TransitionPopupMenu(dialog));
        this.setEdgeInteractor(ei);
        StatePerimeterTarget spt = new StatePerimeterTarget();
        this.setConnectorTarget(spt);
        ArcManipulator manipulator = new ArcManipulator();
        manipulator.setSnapHalo(0.5);
        manipulator.setConnectorTarget(spt);
        manipulator.addConnectorListener(new TransitionProxy(this));
        mouseFilter = new MouseFilter(1, 0, 0);
        manipulator.setHandleFilter(mouseFilter);
        ei.setPrototypeDecorator(manipulator);
    }

    public void initializeInteraction() {
        GraphView view = this.getGraphView();
        GraphicsPane pane = view.getGraphicsPane();
        SelectionDragger selectionDragger = new SelectionDragger(pane);
        selectionDragger.addSelectionInteractor(this.getEdgeInteractor());
        selectionDragger.addSelectionInteractor(this.getNodeInteractor());
    }

    public TransitionConnector getOppositeConnector(State tail, State head) {
        StateMachine machine = tail.getOwner();
        Transition oppTransition = machine.getTransition(head, tail);
        if (oppTransition != null) {
            GraphView view = this.getGraphView();
            Edge oppEdge = (Edge)oppTransition.getUserObject();
            return (TransitionConnector)view.getEdgeFigure(oppEdge);
        }
        return null;
    }

    public void enterEditMode() {
        this.getGraphView().getGraphicsPane().getCanvas().setEnabled(true);
    }

    public void enterExecuteMode() {
        this.getGraphView().getGraphicsPane().getCanvas().setEnabled(false);
        this.getSelectionModel().clearSelection();
    }

    public StateFigure getStateFigure(State state) {
        Node stateNode = (Node)state.getUserObject();
        GraphView view = this.getGraphView();
        return (StateFigure)view.getNodeFigure(stateNode);
    }

    public TransitionConnector getEdgeFigure(Transition transition) {
        Edge transitionEdge = (Edge)transition.getUserObject();
        GraphView view = this.getGraphView();
        return (TransitionConnector)view.getEdgeFigure(transitionEdge);
    }
}

