/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.FigureLayer;
import diva.graph.GraphPane;
import diva.graph.GraphView;
import diva.graph.model.GraphModel;
import fsa.FSAGUIProxy;
import fsa.FSAGraphController;
import fsa.StateCreator;
import fsa.StateRenderer;
import fsa.SymbolDialog;
import fsa.TransitionRenderer;
import fsa.machine.StateMachine;

public class FSAGraphPane
extends GraphPane {
    private FigureLayer _animationLayer;

    public FSAGraphPane(StateMachine machine, SymbolDialog dialog) {
        super(new GraphModel(), new FSAGraphController(machine, dialog));
        this._nullifyLayer(this.getOverlayLayer());
        this._animationLayer = new FigureLayer();
        this._initNewLayer(this._animationLayer);
        this._layers.set(1, this._animationLayer);
        GraphView gv = this.getGraphView();
        gv.setEdgeRenderer(new TransitionRenderer());
        gv.setNodeRenderer(new StateRenderer());
        FSAGraphController controller = (FSAGraphController)this.getGraphController();
        FSAGUIProxy fgp = new FSAGUIProxy(controller);
        machine.addStateListener(fgp);
        machine.addTransitionListener(fgp);
        this.getForegroundLayer().setPickHalo(0.5);
        this.getBackgroundEventLayer().addInteractor(new StateCreator(machine));
    }

    public FigureLayer getAnimationLayer() {
        return this._animationLayer;
    }
}

