/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.SymbolSet;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Tape
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
AncestorListener,
ComponentListener {
    private int _x;
    private int _y;
    private AudioClip _symbolTyped;
    private AudioClip _headMoved;
    private AudioClip _headHomed;
    private boolean _input;
    private boolean _leftLimited;
    private Color tapeColor;
    private Color selColor;
    private Color bColor;
    private Font _symbolFont;
    private Font _labelFont;
    private FontMetrics _lfm;
    private FontMetrics _sfm;
    private Vector _tapeSymbols;
    private int _cells;
    private int _cellWidth;
    private int _head;
    private int _homeCell;
    private int _leftmost;
    private int _maxLocation;
    private int _minLocation;
    private int _start;
    private int _width;
    private Polygon _leftHead;
    private Polygon _rightHead;
    private SymbolSet _allowedSymbols;
    private ImageIcon _headImage;

    public Tape(boolean input) {
        this._input = input;
        this._allowedSymbols = null;
        this.bColor = new Color(233, 240, 251);
        this.tapeColor = new Color(255, 255, 255);
        this.selColor = new Color(255, 255, 0);
        this._tapeSymbols = new Vector();
        this._symbolFont = new Font("Helvetica", 1, 14);
        this._labelFont = new Font("Helvetica", 1, 8);
        this._headImage = new ImageIcon(this.getClass().getResource("/images/head.gif"));
        this._leftLimited = false;
        this._leftmost = 0;
        this._start = this._homeCell = 0;
        this._head = this._homeCell;
        this._minLocation = this._homeCell;
        this._maxLocation = this._homeCell - 1;
        try {
            this._symbolTyped = Applet.newAudioClip(this.getClass().getResource("/sounds/TypeKey.au"));
            this._headMoved = Applet.newAudioClip(this.getClass().getResource("/sounds/TypeSpace.au"));
            this._headHomed = Applet.newAudioClip(this.getClass().getResource("/sounds/TypeReturn.au"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        if (this._input) {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.requestFocus();
        }
        this.addAncestorListener(this);
        this.addComponentListener(this);
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this._head < this._start) {
            this._start = this._head;
        } else if (this._head >= this._start + this._cells - 2) {
            this._start = this._head - this._cells + 2;
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, this._width, 60);
        g.setColor(this.tapeColor);
        g.fillRect(0, 10, this._width, 20);
        g.setColor(Color.black);
        g.drawLine(0, 10, this._width, 10);
        g.drawLine(0, 30, this._width, 30);
        int xloc = 0;
        int pos = this._start;
        for (int i = 0; i < this._cells; ++i) {
            g.drawLine(xloc, 10, xloc, 30);
            if (pos == this._head) {
                g.setColor(new Color(39, 165, 0));
            } else {
                g.setColor(Color.gray);
            }
            g.setFont(this._labelFont);
            String labelString = String.valueOf(pos);
            int labelWidth = this._lfm.stringWidth(labelString);
            int labelStart = xloc + 1 + (this._cellWidth - labelWidth) / 2;
            if (pos % 2 == 0) {
                g.drawString(labelString, labelStart, 7);
                g.drawLine(xloc + this._cellWidth / 2, 9, xloc + this._cellWidth / 2, 8);
            } else {
                g.drawString(labelString, labelStart, 40);
                g.drawLine(xloc + this._cellWidth / 2, 31, xloc + this._cellWidth / 2, 32);
            }
            Character symbol = this.getSymbolAt(pos);
            if (symbol != null) {
                g.setFont(this._symbolFont);
                g.setColor(new Color(39, 165, 0));
                int symbolWidth = this._sfm.charWidth(symbol.charValue());
                int symbolStart = xloc + 1 + (this._cellWidth - symbolWidth) / 2;
                g.drawString(symbol.toString(), symbolStart, 26);
            }
            xloc += this._cellWidth;
            ++pos;
            g.setColor(Color.black);
        }
        int headPos = (this._head - this._start) * this._cellWidth + (this._cellWidth - this._headImage.getIconWidth()) / 2;
        this._headImage.paintIcon(this, g, headPos, 27);
        if (this._input) {
            this.requestFocus();
        }
    }

    public Character getSymbolAt(int index) {
        if (index < this._minLocation || index > this._maxLocation) {
            return null;
        }
        return (Character)this._tapeSymbols.elementAt(index - this._minLocation);
    }

    public Character getSymbolAtHead() {
        return this.getSymbolAt(this.getHeadPosition());
    }

    public void setSymbolAt(char symbol, int index) {
        this.setSymbolAt(new Character(symbol), index);
    }

    public void setSymbolAt(Character symbol, int index) {
        if (this._tapeSymbols.size() == 0) {
            this._minLocation = index;
            this._maxLocation = index;
            this._tapeSymbols.addElement(symbol);
        } else if (index < this._minLocation) {
            this._minLocation = index;
            this._tapeSymbols.insertElementAt(symbol, 0);
        } else if (index > this._maxLocation) {
            this._maxLocation = index;
            this._tapeSymbols.addElement(symbol);
        } else {
            this._tapeSymbols.setElementAt(symbol, index - this._minLocation);
        }
    }

    public int getHeadPosition() {
        return this._head;
    }

    public void setHeadPosition(int head) {
        this._head = head;
        this.repaint();
    }

    public void setTape(SymbolSet allowedSymbols, String symbols, int headPos, int min) {
        this._allowedSymbols = allowedSymbols;
        this._tapeSymbols.clear();
        for (int i = 0; i < symbols.length(); ++i) {
            this.setSymbolAt(symbols.charAt(i), min + i);
        }
        this.setHeadPosition(headPos);
        this.repaint();
    }

    public void Clear() {
        this._tapeSymbols.clear();
        this._head = 0;
        this._start = 0;
        this.repaint();
    }

    public void setAllowedSymbols(SymbolSet allowedSymbols) {
        this._allowedSymbols = allowedSymbols;
    }

    public void setLeftLimited(boolean leftLimited) {
        this._leftLimited = leftLimited;
        if (this._leftmost > this._head) {
            this._head = this._leftmost;
        }
        if (this._leftmost > this._start) {
            this._start = this._leftmost;
        }
        this.repaint();
    }

    public void setLeftmost(int leftmost) {
        this._leftmost = leftmost;
        if (this._leftLimited) {
            if (this._leftmost > this._head) {
                this._head = this._leftmost;
            }
            if (this._leftmost > this._start) {
                this._start = this._leftmost;
            }
            this.repaint();
        }
    }

    public void moveHeadHome() {
        if (this._head != this._homeCell) {
            this._head = this._homeCell;
            this._headHomed.play();
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception except) {
                except.printStackTrace();
            }
            this.repaint();
        }
    }

    public void moveHeadRight() {
        ++this._head;
        this._headMoved.play();
        this.repaint();
    }

    public void mousePressed(MouseEvent event) {
        int index;
        if (!this.isEnabled()) {
            return;
        }
        int x = event.getX();
        int y = event.getY();
        if (y >= 10 && y <= 30 && (index = this._start + x / this._cellWidth) <= this._maxLocation + 1) {
            this._head = index;
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        if (this._input) {
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this._input) {
            this.requestFocus();
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this._input) {
            this.requestFocus();
        }
    }

    public void keyTyped(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._input) {
            this.requestFocus();
        }
        char key = e.getKeyChar();
        if (this._allowedSymbols == null || this._allowedSymbols.contains(key)) {
            this.setSymbolAt(key, this._head);
            ++this._head;
            this._symbolTyped.play();
            this.repaint();
        } else if (key == '@') {
            this.getToolkit().beep();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int key = e.getKeyCode();
        if (key == 39) {
            if (this._head <= this._maxLocation) {
                this.moveHeadRight();
            }
        } else if (key == 37) {
            if (!this._leftLimited || this._head > this._leftmost) {
                --this._head;
                this._headMoved.play();
                this.repaint();
            }
        } else if (key == 36) {
            this.moveHeadHome();
        } else if (key == 34) {
            this._head += this._cells - 1;
            if (this._head > this._maxLocation + 1) {
                this._head = this._maxLocation;
            }
            this.repaint();
        } else if (key == 33) {
            this._head -= this._cells - 1;
            if (this._leftLimited && this._head < this._leftmost) {
                this._head = this._leftmost;
            }
            this.repaint();
        } else if (key == 8 && this._head > this._minLocation) {
            this._tapeSymbols.removeElementAt(this._head - this._minLocation - 1);
            --this._head;
            --this._maxLocation;
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void ancestorAdded(AncestorEvent event) {
        Graphics g = this.getGraphics();
        if (g != null) {
            this._width = this.getWidth();
            this._lfm = g.getFontMetrics(this._labelFont);
            this._sfm = g.getFontMetrics(this._symbolFont);
            this._cellWidth = this._sfm.charWidth('W') + 1;
            this._cells = (int)Math.round(Math.ceil((double)this._width / (double)this._cellWidth));
            this._leftHead = new Polygon();
            this._leftHead.addPoint(0, 39);
            this._leftHead.addPoint(this._cellWidth / 2, 39);
            this._leftHead.addPoint(this._cellWidth / 2, 27);
            this._rightHead = new Polygon();
            this._rightHead.addPoint(this._cellWidth, 39);
            this._rightHead.addPoint(this._cellWidth / 2, 27);
            this._rightHead.addPoint(this._cellWidth / 2, 39);
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this._width = this.getWidth();
        this._cells = (int)Math.round(Math.ceil((double)this._width / (double)this._cellWidth));
    }

    public void componentShown(ComponentEvent e) {
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 60);
    }
}

