/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.CanvasUtilities;
import diva.canvas.Site;
import diva.canvas.TransformContext;
import diva.canvas.connector.AbstractConnector;
import diva.canvas.toolbox.LabelFigure;
import fsa.AnimationPath;
import fsa.CompositeAnimationPath;
import fsa.LineAnimationPath;
import fsa.PathIteratorAnimationPath;
import fsa.StateFigure;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class TransitionConnector
extends AbstractConnector {
    private Arc2D _arc;
    private Line2D _line = new Line2D.Double();
    private Point2D _headPt;
    private Point2D _tailPt;
    private double _angle = 0.3141592653589793;
    private double _centerX;
    private double _centerY;
    private double _radius;
    private double _startAngle;
    private boolean _isArc = false;

    public TransitionConnector(Site tail, Site head) {
        super(tail, head);
        this._arc = new Arc2D.Double();
        this.getPaintedPath().shape = this._line;
        this.route();
    }

    public double getAngle() {
        return this._angle;
    }

    public void repositionLabel() {
        if (this.getLabelFigure() != null) {
            Point2D.Double pt = this._isArc ? new Point2D.Double(this._centerX + this._radius * Math.sin(this._startAngle + this._angle + 1.5707963267948966), this._centerY + this._radius * Math.cos(this._startAngle + this._angle + 1.5707963267948966)) : new Point2D.Double((this._headPt.getX() + this._tailPt.getX()) / 2.0, (this._headPt.getY() + this._tailPt.getY()) / 2.0);
            this.getLabelFigure().translateForce(pt);
            this.getLabelFigure().autoAnchor(this.getPaintedPath().shape);
        }
    }

    public void route() {
        Point2D headPt;
        Point2D tailPt;
        this.repaint();
        TransformContext currentContext = this.getTransformContext();
        Site headSite = this.getHeadSite();
        Site tailSite = this.getTailSite();
        if (currentContext != null) {
            tailPt = tailSite.getPoint(currentContext);
            headPt = headSite.getPoint(currentContext);
        } else {
            tailPt = tailSite.getPoint();
            headPt = headSite.getPoint();
        }
        Point2D tailCenter = tailSite.getFigure() != null ? CanvasUtilities.getCenterPoint(tailSite.getFigure()) : tailPt;
        Point2D headCenter = headSite.getFigure() != null ? CanvasUtilities.getCenterPoint(headSite.getFigure()) : headPt;
        if (this._isArc) {
            if (headSite.getFigure() == tailSite.getFigure()) {
                tailSite.setNormal(-1.5707963267948966 + this._angle);
                headSite.setNormal(-1.5707963267948966 - this._angle);
                Point2D tailPoint = tailSite.getPoint();
                Point2D headPoint = headSite.getPoint();
                if (this.getHeadEnd() != null) {
                    this.getHeadEnd().setNormal(-1.5707963267948966);
                    this.getHeadEnd().setOrigin(headSite.getPoint().getX(), headSite.getPoint().getY());
                    this.getHeadEnd().getConnection(headSite.getPoint());
                }
                Rectangle2D.Double arcBounds = new Rectangle2D.Double(headSite.getPoint().getX(), headSite.getPoint().getY() - 50.0, tailSite.getPoint().getX() - headSite.getPoint().getX(), 100.0);
                this._arc.setArc(arcBounds, 0.0, 180.0, 0);
                if (this.getLabelFigure() != null) {
                    LabelFigure label = this.getLabelFigure();
                    Rectangle2D bounds = label.getBounds();
                    Rectangle2D fBounds = headSite.getFigure().getBounds();
                    double x = headPoint.getX() + (headPoint.getX() - tailPoint.getX()) / 2.0 + bounds.getWidth() / 2.0;
                    double y = headPoint.getY() - 50.0;
                    label.translateForce(new Point2D.Double(x, y));
                    label.autoAnchor(this.getPaintedPath().shape);
                }
                this.repaint();
                return;
            }
            double x = headCenter.getX() - tailCenter.getX();
            double y = headCenter.getY() - tailCenter.getY();
            double gamma = Math.atan2(y, x);
            double alpha = this._angle;
            double beta = 1.5707963267948966 - alpha;
            tailSite.setNormal(gamma + alpha);
            headSite.setNormal(gamma - alpha - Math.PI);
            if (currentContext != null) {
                tailPt = tailSite.getPoint(currentContext);
                headPt = headSite.getPoint(currentContext);
            } else {
                tailPt = tailSite.getPoint();
                headPt = headSite.getPoint();
            }
            x = headPt.getX() - tailPt.getX();
            y = headPt.getY() - tailPt.getY();
            gamma = Math.atan2(y, x);
            if (this.getHeadEnd() != null) {
                this.getHeadEnd().setNormal(gamma - alpha - Math.PI);
                this.getHeadEnd().setOrigin(headPt.getX(), headPt.getY());
                this.getHeadEnd().getConnection(headPt);
            }
            if (this.getTailEnd() != null) {
                this.getTailEnd().setNormal(gamma - alpha);
                this.getTailEnd().setOrigin(tailPt.getX(), tailPt.getY());
                this.getTailEnd().getConnection(tailPt);
            }
            x = headPt.getX() - tailPt.getX();
            y = headPt.getY() - tailPt.getY();
            gamma = Math.atan2(y, x);
            double dx = Math.sqrt(x * x + y * y) / 2.0;
            double dy = -dx * Math.tan(beta);
            double dxdash = dx * Math.cos(gamma) - dy * Math.sin(gamma);
            double dydash = dx * Math.sin(gamma) + dy * Math.cos(gamma);
            double centerX = tailPt.getX() + dxdash;
            double centerY = tailPt.getY() + dydash;
            double radius = Math.sqrt(dx * dx + dy * dy);
            this._centerX = centerX;
            this._centerY = centerY;
            this._radius = radius;
            this._startAngle = 4.71238898038469 - alpha - gamma;
            if (this._angle < 0.0) {
                this._startAngle += Math.PI;
            }
            this._arc.setArcByCenter(centerX, centerY, radius, this._startAngle / Math.PI * 180.0, 2.0 * alpha / Math.PI * 180.0, 0);
        } else {
            if (headSite.getFigure() == tailSite.getFigure()) {
                this.setIsArc(true);
                return;
            }
            double x = headCenter.getX() - tailCenter.getX();
            double y = headCenter.getY() - tailCenter.getY();
            double angle = Math.atan2(y, x);
            tailSite.setNormal(angle);
            headSite.setNormal(angle - Math.PI);
            if (currentContext != null) {
                tailPt = tailSite.getPoint(currentContext);
                headPt = headSite.getPoint(currentContext);
            } else {
                tailPt = tailSite.getPoint();
                headPt = headSite.getPoint();
            }
            this._headPt = headPt;
            this._tailPt = tailPt;
            x = headPt.getX() - tailPt.getX();
            y = headPt.getY() - tailPt.getY();
            angle = Math.atan2(y, x);
            if (this.getHeadEnd() != null) {
                this.getHeadEnd().setNormal(angle + Math.PI);
                this.getHeadEnd().setOrigin(headPt.getX(), headPt.getY());
                this.getHeadEnd().getConnection(headPt);
            }
            if (this.getTailEnd() != null) {
                this.getTailEnd().setNormal(angle);
                this.getTailEnd().setOrigin(tailPt.getX(), tailPt.getY());
                this.getTailEnd().getConnection(tailPt);
            }
            ((Line2D)this.getPaintedPath().shape).setLine(tailPt, headPt);
        }
        this.repositionLabel();
        this.repaint();
    }

    public void setAngle(double angle) {
        this._angle = angle;
    }

    public void translate(double x, double y) {
        Rectangle bounds = this._arc.getBounds();
        this.repaint();
        if (this._isArc) {
            this._arc.setFrame(((RectangularShape)bounds).getX() + x, ((RectangularShape)bounds).getY() + y, ((RectangularShape)bounds).getWidth(), ((RectangularShape)bounds).getHeight());
            if (this.getLabelFigure() != null) {
                this.getLabelFigure().translate(x, y);
            }
        } else {
            Line2D line = (Line2D)this.getPaintedPath().shape;
            line.setLine(line.getX1() + x, line.getY1() + y, line.getX2() + x, line.getY2() + y);
            if (this.getLabelFigure() != null) {
                this.getLabelFigure().translate(x, y);
            }
        }
        this.repaint();
    }

    public void setIsArc(boolean isArc) {
        if (isArc != this._isArc) {
            this._isArc = isArc;
            this.repaint();
            this.getPaintedPath().shape = isArc ? this._arc : this._line;
            this.route();
        }
    }

    public void setLabel(String label) {
        this.route();
        super.setLabel(label);
        this.route();
    }

    public AnimationPath getAnimationPath() {
        AnimationPath[] paths = new AnimationPath[3];
        StateFigure startFigure = (StateFigure)this.getTailSite().getFigure();
        StateFigure endFigure = (StateFigure)this.getHeadSite().getFigure();
        Rectangle2D bounds = startFigure.getEllipseBounds();
        Point2D startPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Point2D endPoint = this.getTailSite().getPoint();
        paths[0] = new LineAnimationPath(startPoint, endPoint);
        PathIterator pathIterator = this.getShape().getPathIterator(null, 1.0);
        paths[1] = new PathIteratorAnimationPath(pathIterator);
        bounds = endFigure.getEllipseBounds();
        startPoint = this.getHeadSite().getPoint();
        endPoint = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        paths[2] = new LineAnimationPath(startPoint, endPoint);
        return new CompositeAnimationPath(paths);
    }
}

