/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.Figure;
import diva.canvas.Site;
import diva.canvas.connector.ConnectorEvent;
import diva.canvas.connector.ConnectorListener;
import diva.canvas.selection.SelectionModel;
import diva.graph.GraphView;
import diva.graph.model.Edge;
import diva.graph.model.GraphModel;
import diva.graph.model.Node;
import fsa.FSAGraphController;
import fsa.StatePerimeterTarget;
import fsa.SymbolChangeException;
import fsa.SymbolSet;
import fsa.TransitionConnector;
import fsa.machine.State;
import fsa.machine.StateMachine;
import fsa.machine.Transition;
import java.awt.geom.Rectangle2D;

public class TransitionProxy
implements ConnectorListener {
    FSAGraphController _controller;

    public TransitionProxy(FSAGraphController controller) {
        this._controller = controller;
    }

    public void connectorGrabbed(ConnectorEvent event) {
        TransitionConnector connector = (TransitionConnector)event.getConnector();
        Edge edge = (Edge)connector.getUserObject();
        Transition transition = (Transition)edge.getSemanticObject();
        StatePerimeterTarget spt = (StatePerimeterTarget)this._controller.getConnectorTarget();
        if (transition != null) {
            spt.setInfo(transition, event.getEnd());
        } else {
            Node node = edge.getTail();
            State state = (State)node.getSemanticObject();
            spt.setInfo(state, event.getEnd());
        }
    }

    public void connectorDropped(ConnectorEvent event) {
        GraphModel model = this._controller.getGraphModel();
        GraphView view = this._controller.getGraphView();
        StatePerimeterTarget spt = (StatePerimeterTarget)this._controller.getConnectorTarget();
        TransitionConnector connector = (TransitionConnector)event.getConnector();
        Edge edge = (Edge)connector.getUserObject();
        Figure target = event.getTarget();
        if (event.getEnd() == 21) {
            spt.unsetInfo();
            if (target == null) {
                if (edge.getHead() == null) {
                    SelectionModel sm = this._controller.getSelectionModel();
                    sm.clearSelection();
                    model.disconnectEdge(edge);
                } else {
                    Figure figure = view.getNodeFigure(edge.getHead());
                    Rectangle2D bounds = figure.getBounds();
                    Site headSite = spt.getHeadSite(figure, bounds.getCenterX(), bounds.getCenterY());
                    connector.setHeadSite(headSite);
                    State headState = (State)edge.getHead().getSemanticObject();
                    State tailState = (State)edge.getTail().getSemanticObject();
                    if (tailState == headState) {
                        connector.setIsArc(true);
                    } else {
                        TransitionConnector oppConnector = this._controller.getOppositeConnector(tailState, headState);
                        if (oppConnector != null) {
                            connector.setIsArc(true);
                            oppConnector.setIsArc(true);
                        } else {
                            connector.setIsArc(false);
                        }
                    }
                }
            } else {
                Node tailNode = edge.getTail();
                State tailState = (State)tailNode.getSemanticObject();
                Node headNode = (Node)target.getUserObject();
                State headState = (State)headNode.getSemanticObject();
                if (edge.getHead() != headNode) {
                    StateMachine machine = tailState.getOwner();
                    Transition newTransition = new Transition(tailState, headState);
                    newTransition.setUserObject(edge);
                    Transition transition = (Transition)edge.getSemanticObject();
                    model.setEdgeHead(edge, headNode);
                    edge.setSemanticObject(newTransition);
                    if (transition != null) {
                        SymbolSet symbols = transition.getSymbolSet();
                        SymbolSet newSymbols = newTransition.getSymbolSet();
                        try {
                            newSymbols.addSymbols(symbols.getSymbolArray());
                        }
                        catch (SymbolChangeException sce) {
                            // empty catch block
                        }
                        transition.setUserObject(null);
                        machine.removeTransition(transition);
                    }
                    machine.addTransition(newTransition);
                }
            }
        } else if (event.getEnd() == 22) {
            spt.unsetInfo();
            if (target == null) {
                Figure figure = view.getNodeFigure(edge.getTail());
                Rectangle2D bounds = figure.getBounds();
                Site tailSite = spt.getTailSite(figure, bounds.getCenterX(), bounds.getCenterY());
                connector.setTailSite(tailSite);
                State headState = (State)edge.getHead().getSemanticObject();
                State tailState = (State)edge.getTail().getSemanticObject();
                if (tailState == headState) {
                    connector.setIsArc(true);
                } else {
                    TransitionConnector oppConnector = this._controller.getOppositeConnector(tailState, headState);
                    if (oppConnector != null) {
                        connector.setIsArc(true);
                        oppConnector.setIsArc(true);
                    }
                }
            } else {
                Node tailNode = (Node)target.getUserObject();
                State tailState = (State)tailNode.getSemanticObject();
                Node headNode = edge.getHead();
                State headState = (State)headNode.getSemanticObject();
                if (edge.getTail() != tailNode) {
                    Transition transition = (Transition)edge.getSemanticObject();
                    StateMachine machine = transition.getOwner();
                    Transition newTransition = new Transition(tailState, headState);
                    newTransition.setUserObject(edge);
                    model.setEdgeTail(edge, tailNode);
                    edge.setSemanticObject(newTransition);
                    SymbolSet symbols = transition.getSymbolSet();
                    SymbolSet newSymbols = newTransition.getSymbolSet();
                    try {
                        newSymbols.addSymbols(symbols.getSymbolArray());
                    }
                    catch (SymbolChangeException sce) {
                        // empty catch block
                    }
                    transition.setUserObject(null);
                    machine.removeTransition(transition);
                    machine.addTransition(newTransition);
                }
            }
        }
    }

    public void connectorUnsnapped(ConnectorEvent event) {
        TransitionConnector oppConnector;
        State headState;
        State tailState;
        TransitionConnector connector = (TransitionConnector)event.getConnector();
        connector.setIsArc(false);
        Figure target = event.getTarget();
        Edge edge = (Edge)connector.getUserObject();
        if (event.getEnd() == 21) {
            tailState = (State)edge.getTail().getSemanticObject();
            headState = (State)((Node)target.getUserObject()).getSemanticObject();
        } else if (event.getEnd() == 22) {
            tailState = (State)((Node)target.getUserObject()).getSemanticObject();
            headState = (State)edge.getHead().getSemanticObject();
        } else {
            tailState = (State)edge.getTail().getSemanticObject();
            headState = (State)edge.getHead().getSemanticObject();
        }
        if (tailState != headState && (oppConnector = this._controller.getOppositeConnector(tailState, headState)) != null) {
            oppConnector.setIsArc(false);
        }
    }

    public void connectorSnapped(ConnectorEvent event) {
        State headState = null;
        State tailState = null;
        TransitionConnector connector = (TransitionConnector)event.getConnector();
        Figure target = event.getTarget();
        Edge edge = (Edge)connector.getUserObject();
        if (event.getEnd() == 21) {
            tailState = (State)edge.getTail().getSemanticObject();
            headState = (State)((Node)target.getUserObject()).getSemanticObject();
        } else if (event.getEnd() == 22) {
            tailState = (State)((Node)target.getUserObject()).getSemanticObject();
            headState = (State)edge.getHead().getSemanticObject();
        } else {
            tailState = (State)edge.getTail().getSemanticObject();
            headState = (State)edge.getHead().getSemanticObject();
        }
        if (tailState == headState) {
            connector.setIsArc(true);
        } else {
            TransitionConnector oppConnector = this._controller.getOppositeConnector(tailState, headState);
            if (oppConnector != null) {
                connector.setIsArc(true);
                oppConnector.setIsArc(true);
            }
        }
    }

    public void connectorDragged(ConnectorEvent event) {
    }
}

