/*
 * Decompiled with CFR 0.152.
 */
package fsa.machine;

import fsa.SymbolAdapter;
import fsa.SymbolChangeException;
import fsa.SymbolEvent;
import fsa.SymbolSet;
import fsa.SymbolUser;
import fsa.VetoableSymbolEvent;
import fsa.machine.ReferenceCount;
import fsa.machine.State;
import fsa.machine.StateEvent;
import fsa.machine.StateListener;
import fsa.machine.StatePropertyEvent;
import fsa.machine.Transition;
import fsa.machine.TransitionEvent;
import fsa.machine.TransitionListener;
import fsa.machine.TransitionMovedEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StateMachine
implements Serializable {
    private SymbolSet alphabet;
    private HashMap refCounts = new HashMap();
    private HashMap transitions;
    private HashSet states;
    private HashMap function;
    private HashMap sources;
    private HashMap destinations;
    private HashMap symbolAdapters;
    private State startState = null;
    private int stateNum = 0;
    public static final Character EMPTY_SYMBOL = new Character('\u03b5');
    private static final HashSet empty_set = new HashSet();
    private HashMap specificListeners;
    private HashSet transitionListeners;
    private HashSet stateListeners;
    private String description;

    public StateMachine() {
        this.alphabet = new SymbolSet(this);
        this.states = new HashSet();
        this.transitions = new HashMap();
        this.function = new HashMap();
        this.sources = new HashMap();
        this.destinations = new HashMap();
        try {
            this.alphabet.addSymbol(EMPTY_SYMBOL);
            ReferenceCount rc = new ReferenceCount(EMPTY_SYMBOL);
            this.refCounts.put(EMPTY_SYMBOL, rc);
        }
        catch (SymbolChangeException sce) {
            System.err.println("This shouldn't have happened!");
            sce.printStackTrace();
        }
        SymbolAdapter sa = new SymbolAdapter(this, null, "alphabetSymbolsAdded", "requestAlphabetSymbolRemoval", "alphabetSymbolsRemoved");
        this.alphabet.addSymbolListener(sa);
        this.specificListeners = new HashMap();
        this.symbolAdapters = new HashMap();
        this.transitionListeners = new HashSet();
        this.stateListeners = new HashSet();
    }

    public void alphabetSymbolsAdded(SymbolEvent e) {
        Iterator i = e.getSymbols();
        while (i.hasNext()) {
            Character symbol = (Character)i.next();
            this.refCounts.put(symbol, new ReferenceCount(symbol));
        }
    }

    public void requestAlphabetSymbolRemoval(VetoableSymbolEvent e) {
        Iterator i = e.getSymbols();
        while (i.hasNext()) {
            Character symbol = (Character)i.next();
            ReferenceCount rc = (ReferenceCount)this.refCounts.get(symbol);
            if (rc == null || rc.getCount() <= 0) continue;
            e.veto("The symbol " + symbol + " is being used and cannot be removed from the alphabet.");
            return;
        }
    }

    public void alphabetSymbolsRemoved(SymbolEvent e) {
        Iterator i = e.getSymbols();
        while (i.hasNext()) {
            this.refCounts.remove(i.next());
        }
    }

    public SymbolSet getAlphabet() {
        return this.alphabet;
    }

    public boolean symbolInUse(Character symbol) {
        ReferenceCount rc = (ReferenceCount)this.refCounts.get(symbol);
        if (rc != null) {
            return rc.getCount() > 0;
        }
        return false;
    }

    public void addState(State state) {
        if (!this.states.contains(state)) {
            this.states.add(state);
            state.setOwner(this);
            this.fireStateEvent(state, 0);
        }
    }

    public void removeState(State s) {
        if (this.states.contains(s)) {
            Iterator transitions;
            HashSet transitionSet;
            if (s.isStartState()) {
                s.setStartState(false);
            }
            if (this.sources.containsKey(s)) {
                transitionSet = (HashSet)((HashSet)this.sources.get(s)).clone();
                transitions = transitionSet.iterator();
                while (transitions.hasNext()) {
                    this.removeTransition((Transition)transitions.next());
                }
            }
            if (this.destinations.containsKey(s)) {
                transitionSet = (HashSet)((HashSet)this.destinations.get(s)).clone();
                transitions = transitionSet.iterator();
                while (transitions.hasNext()) {
                    this.removeTransition((Transition)transitions.next());
                }
            }
            this.states.remove(s);
            s.setOwner(null);
            this.fireStateEvent(s, 1);
        }
    }

    protected void finalStateChange(State s) {
        if (this.states.contains(s)) {
            this.fireStateEvent(s, 4);
        }
    }

    protected void stateDescriptionChange(State s) {
        if (this.states.contains(s)) {
            this.fireStateEvent(s, 2);
        }
    }

    protected void statePositionChange(State s) {
        if (this.states.contains(s)) {
            this.fireStateEvent(s, 5);
        }
    }

    protected void statePropertyChange(State state, String propertyName) {
        this.fireStatePropertyEvent(state, propertyName);
    }

    public void addTransition(Transition transition) {
        if (!this.transitions.containsKey(transition.getKey())) {
            this.transitions.put(transition.getKey(), transition);
            this.addToHashedSet(this.sources, transition.getSource(), transition);
            this.addToHashedSet(this.destinations, transition.getDestination(), transition);
            Iterator iterator = transition.getSymbolSet().getSymbols();
            while (iterator.hasNext()) {
                Character symbol = (Character)iterator.next();
                this.addToHashedSet(this.function, transition.functionKey(symbol), transition);
                ReferenceCount rc = (ReferenceCount)this.refCounts.get(symbol);
                rc.incrementCount();
            }
            SymbolAdapter sa = new SymbolAdapter(this, "requestTransitionSymbolAddition", "transitionSymbolsAdded", null, "transitionSymbolsRemoved");
            transition.getSymbolSet().addSymbolListener(sa);
            this.symbolAdapters.put(transition.getKey(), sa);
            transition.setOwner(this);
            this.fireTransitionEvent(0, transition);
        }
    }

    public void removeTransition(Transition transition) {
        if (this.transitions.containsKey(transition.getKey())) {
            this.transitions.remove(transition.getKey());
            this.removeFromHashedSet(this.sources, transition.getSource(), transition);
            this.removeFromHashedSet(this.destinations, transition.getDestination(), transition);
            SymbolAdapter sa = (SymbolAdapter)this.symbolAdapters.get(transition.getKey());
            this.symbolAdapters.remove(transition.getKey());
            transition.getSymbolSet().removeSymbolListener(sa);
            Iterator iterator = transition.getSymbolSet().getSymbols();
            while (iterator.hasNext()) {
                Character symbol = (Character)iterator.next();
                this.removeFromHashedSet(this.function, transition.functionKey(symbol), transition);
                ReferenceCount rc = (ReferenceCount)this.refCounts.get(symbol);
                rc.decrementCount();
            }
            transition.setOwner(null);
            this.fireTransitionEvent(1, transition);
        }
    }

    protected void addToHashedSet(HashMap hm, Object key, Object value) {
        Set<Object> set;
        if (hm.containsKey(key)) {
            set = (Set)hm.get(key);
        } else {
            set = new HashSet();
            hm.put(key, set);
        }
        set.add(value);
    }

    protected void removeFromHashedSet(HashMap hm, Object key, Object value) {
        if (hm.containsKey(key)) {
            Set set = (Set)hm.get(key);
            set.remove(value);
            if (set.size() == 0) {
                hm.remove(key);
            }
        }
    }

    public void requestTransitionSymbolAddition(VetoableSymbolEvent e) {
        Iterator i = e.getSymbols();
        while (i.hasNext()) {
            Character symbol = (Character)i.next();
            if (this.alphabet.contains(symbol)) continue;
            e.veto(symbol + " not in alphabet");
            return;
        }
    }

    public void transitionSymbolsAdded(SymbolEvent e) {
        Iterator i = e.getSymbols();
        SymbolUser su = (SymbolUser)e.getSource();
        Transition t = (Transition)su.getOwner();
        while (i.hasNext()) {
            Character symbol = (Character)i.next();
            ReferenceCount rc = (ReferenceCount)this.refCounts.get(symbol);
            rc.incrementCount();
            this.addToHashedSet(this.function, t.functionKey(symbol), t);
        }
        this.fireTransitionEvent(2, t);
    }

    public void transitionSymbolsRemoved(SymbolEvent e) {
        Iterator i = e.getSymbols();
        SymbolUser su = (SymbolUser)e.getSource();
        Transition t = (Transition)su.getOwner();
        while (i.hasNext()) {
            Character symbol = (Character)i.next();
            ReferenceCount rc = (ReferenceCount)this.refCounts.get(symbol);
            rc.decrementCount();
            this.removeFromHashedSet(this.function, t.functionKey(symbol), t);
        }
        this.fireTransitionEvent(2, t);
    }

    public boolean equals(Object obj) {
        if (obj instanceof StateMachine) {
            StateMachine sm = (StateMachine)obj;
            return this.alphabet.equals(sm.alphabet) && this.transitions.equals(sm.transitions) && this.states.equals(sm.states) && this.function.equals(sm.function) && this.stateNum == sm.stateNum;
        }
        return false;
    }

    public Iterator transitionFunction(State state, Character symbol) {
        String functionKey = Transition.generateFunctionKey(state, symbol);
        HashSet transitions = (HashSet)this.function.get(functionKey);
        if (transitions == null) {
            return ((HashSet)empty_set.clone()).iterator();
        }
        return Arrays.asList(transitions.toArray()).iterator();
    }

    public Iterator getStates() {
        return Arrays.asList(this.states.toArray()).iterator();
    }

    public Iterator getTransitions() {
        return Arrays.asList(this.transitions.values().toArray()).iterator();
    }

    public Iterator getTransitionsStartingFrom(State state) {
        HashSet transitions = (HashSet)this.sources.get(state);
        if (transitions != null) {
            return ((HashSet)transitions.clone()).iterator();
        }
        return ((HashSet)empty_set.clone()).iterator();
    }

    public State getStartState() {
        return this.startState;
    }

    public Iterator getFinalStates() {
        ArrayList<State> finalStates = new ArrayList<State>();
        Iterator states = this.getStates();
        while (states.hasNext()) {
            State state = (State)states.next();
            if (!state.isFinalState()) continue;
            finalStates.add(state);
        }
        return finalStates.iterator();
    }

    public void setStartState(State s) {
        if (s != this.startState && (s == null || this.states.contains(s))) {
            State oldStart = this.startState;
            this.startState = s;
            if (oldStart != null) {
                this.fireStateEvent(oldStart, 3);
            }
            if (s != null) {
                this.fireStateEvent(s, 3);
            }
        }
    }

    public boolean transitionExists(State start, State end) {
        return this.transitions.containsKey(Transition.generateKey(start, end));
    }

    public Transition getTransition(State source, State destination) {
        String key = Transition.generateKey(source, destination);
        return (Transition)this.transitions.get(key);
    }

    public boolean isDeterministic() {
        ReferenceCount rc = (ReferenceCount)this.refCounts.get(EMPTY_SYMBOL);
        if (rc.getCount() > 0) {
            return false;
        }
        Iterator iterator = this.function.values().iterator();
        while (iterator.hasNext()) {
            HashSet set = (HashSet)iterator.next();
            if (set.size() <= 1) continue;
            return false;
        }
        return true;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized void addStateListener(StateListener l, State state) {
        this.addToHashedSet(this.specificListeners, state, l);
    }

    public synchronized void removeStateListener(StateListener l, State state) {
        this.removeFromHashedSet(this.specificListeners, state, l);
    }

    public synchronized void addStateListener(StateListener l) {
        this.stateListeners.add(l);
    }

    public synchronized void removeStateListener(StateListener l) {
        this.stateListeners.remove(l);
    }

    public synchronized void removeStateListeners(State state) {
        this.specificListeners.remove(state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStateEvent(State s, int type) {
        StateEvent se = new StateEvent(this, type, s);
        ArrayList listeners = new ArrayList();
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (this.specificListeners.containsKey(s)) {
                listeners.addAll((Collection)this.specificListeners.get(s));
            }
            listeners.addAll(this.stateListeners);
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            StateListener sl = (StateListener)iterator.next();
            switch (type) {
                case 0: {
                    sl.stateAdded(se);
                    break;
                }
                case 1: {
                    sl.stateRemoved(se);
                    break;
                }
                case 3: {
                    sl.startStateChange(se);
                    break;
                }
                case 4: {
                    sl.finalStateChange(se);
                }
            }
        }
    }

    public synchronized void addTransitionListener(TransitionListener l, State start, State end) {
        String key = Transition.generateKey(start, end);
        this.addToHashedSet(this.specificListeners, key, l);
    }

    public synchronized void addTransitionListener(TransitionListener l, Transition t) {
        this.addToHashedSet(this.specificListeners, t.getKey(), l);
    }

    public synchronized void removeTransitionListener(TransitionListener l, State start, State end) {
        String key = Transition.generateKey(start, end);
        this.removeFromHashedSet(this.specificListeners, key, l);
    }

    public synchronized void removeTransitionListener(TransitionListener l, Transition t) {
        this.removeFromHashedSet(this.specificListeners, t.getKey(), l);
    }

    public synchronized void addTransitionListener(TransitionListener l) {
        this.transitionListeners.add(l);
    }

    public synchronized void removeTransitionListener(TransitionListener l) {
        this.transitionListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTransitionEvent(int type, Transition t) {
        TransitionEvent te = new TransitionEvent(this, type, t);
        ArrayList listeners = new ArrayList();
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (this.specificListeners.containsKey(t.getKey())) {
                listeners.addAll((Collection)this.specificListeners.get(t.getKey()));
            }
            listeners.addAll(this.transitionListeners);
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            TransitionListener tl = (TransitionListener)iterator.next();
            switch (type) {
                case 0: {
                    tl.transitionAdded(te);
                    break;
                }
                case 1: {
                    tl.transitionRemoved(te);
                    break;
                }
                case 2: {
                    tl.transitionSymbolsChanged(te);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTransitionMoved(Transition t, State original) {
        TransitionMovedEvent tme = new TransitionMovedEvent(this, t, original);
        String key = Transition.generateKey(t.getSource(), original);
        ArrayList listeners = new ArrayList();
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (this.specificListeners.containsKey(t.getKey())) {
                listeners.addAll((Collection)this.specificListeners.get(t.getKey()));
            }
            if (this.specificListeners.containsKey(key)) {
                listeners.addAll((Collection)this.specificListeners.get(key));
            }
            listeners.addAll(this.transitionListeners);
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            TransitionListener tl = (TransitionListener)iterator.next();
            tl.transitionMoved(tme);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStatePropertyEvent(State state, String propertyName) {
        StatePropertyEvent spe = new StatePropertyEvent(this, state, propertyName);
        ArrayList listeners = new ArrayList();
        StateMachine stateMachine = this;
        synchronized (stateMachine) {
            if (this.specificListeners.containsKey(state)) {
                listeners.addAll((Collection)this.specificListeners.get(state));
            }
            listeners.addAll(this.stateListeners);
        }
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            StateListener sl = (StateListener)iterator.next();
            sl.statePropertyChanged(spe);
        }
    }

    public void reset() {
        HashMap cloneMap = (HashMap)this.transitions.clone();
        Iterator<Object> iterator = cloneMap.values().iterator();
        while (iterator.hasNext()) {
            Transition transition = (Transition)iterator.next();
            this.removeTransition(transition);
        }
        HashSet cloneSet = (HashSet)this.states.clone();
        iterator = cloneSet.iterator();
        while (iterator.hasNext()) {
            State state = (State)iterator.next();
            this.removeState(state);
        }
        iterator = this.alphabet.getSymbols();
        while (iterator.hasNext()) {
            Character symbol = (Character)iterator.next();
            if (symbol.equals(EMPTY_SYMBOL)) continue;
            try {
                this.alphabet.removeSymbol(symbol);
            }
            catch (SymbolChangeException sce) {
                sce.printStackTrace();
            }
        }
        this.stateNum = 0;
    }
}

