/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import EDU.oswego.cs.dl.util.concurrent.Mutex;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;

public class FIFOReadWriteLock
implements ReadWriteLock {
    protected final FIFOSemaphore active_ = new FIFOSemaphore(1L);
    protected final Sync readerSync_ = new ReaderSync();

    public Sync writeLock() {
        return this.active_;
    }

    public Sync readLock() {
        return this.readerSync_;
    }

    class ReaderSync
    implements Sync {
        protected int readers_ = 0;
        protected Mutex oneWaiter_ = new Mutex();

        ReaderSync() {
        }

        protected synchronized void incReaders() throws InterruptedException {
            if (this.readers_ == 0) {
                FIFOReadWriteLock.this.active_.acquire();
            }
            ++this.readers_;
        }

        protected synchronized boolean tryRead(long msecs) throws InterruptedException {
            boolean pass;
            boolean bl = pass = this.readers_ > 0 || FIFOReadWriteLock.this.active_.attempt(msecs);
            if (pass) {
                ++this.readers_;
            }
            return pass;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() throws InterruptedException {
            this.oneWaiter_.acquire();
            try {
                this.incReaders();
            }
            finally {
                this.oneWaiter_.release();
            }
        }

        public synchronized void release() {
            if (--this.readers_ == 0) {
                FIFOReadWriteLock.this.active_.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean attempt(long msecs) throws InterruptedException {
            long startTime;
            long l = startTime = msecs <= 0L ? 0L : System.currentTimeMillis();
            if (!this.oneWaiter_.attempt(msecs)) {
                return false;
            }
            long timeLeft = msecs <= 0L ? 0L : msecs - (System.currentTimeMillis() - startTime);
            try {
                boolean bl = this.tryRead(timeLeft);
                return bl;
            }
            finally {
                this.oneWaiter_.release();
            }
        }
    }
}

