/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.CanvasComponent;
import diva.canvas.CanvasLayer;
import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.JCanvas;
import diva.canvas.TransformContext;
import diva.canvas.VisibleComponent;
import diva.canvas.event.EventAcceptor;
import diva.canvas.event.LayerEvent;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public abstract class CanvasPane
implements EventAcceptor,
CanvasComponent {
    private CanvasComponent _parent = null;
    private JCanvas _canvas = null;
    private boolean _enabled = true;
    private boolean _antialias = true;
    private Point2D _paneSize = new Point2D.Double(100.0, 100.0);
    private TransformContext _transformContext = new TransformContext(this);

    public void dispatchEvent(AWTEvent event) {
        if (event instanceof LayerEvent) {
            this.processLayerEvent((LayerEvent)event);
        } else {
            System.out.println("Bad event: " + event);
        }
    }

    public CanvasComponent getParent() {
        return this._parent;
    }

    public JCanvas getCanvas() {
        return this._canvas;
    }

    public boolean isAntialiasing() {
        return this._antialias;
    }

    public TransformContext getTransformContext() {
        return this._transformContext;
    }

    public Point2D getSize() {
        if (this._canvas != null) {
            Dimension d = this._canvas.getSize();
            Point2D.Double s = new Point2D.Double(d.width, d.height);
            this._transformContext.getTransform().transform(s, s);
            return s;
        }
        return this._paneSize;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public Iterator layers() {
        return this.layersFromFront();
    }

    public abstract Iterator layersFromBack();

    public abstract Iterator layersFromFront();

    public void paint(Graphics2D g) {
        this._transformContext.push(g);
        if (this.isAntialiasing()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        Iterator i = this.layersFromBack();
        while (i.hasNext()) {
            CanvasLayer layer = (CanvasLayer)i.next();
            if (!(layer instanceof VisibleComponent)) continue;
            ((VisibleComponent)((Object)layer)).paint(g);
        }
        this._transformContext.pop(g);
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        AffineTransform t;
        this._transformContext.push(g);
        if (this.isAntialiasing()) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (!(t = this._transformContext.getInverseTransform()).isIdentity()) {
            region = CanvasUtilities.isOrthogonal(t) ? (Rectangle2D)CanvasUtilities.transform(region, t) : t.createTransformedShape(region).getBounds2D();
        }
        Iterator i = this.layersFromBack();
        while (i.hasNext()) {
            CanvasLayer layer = (CanvasLayer)i.next();
            if (!(layer instanceof VisibleComponent)) continue;
            ((VisibleComponent)((Object)layer)).paint(g, region);
        }
        this._transformContext.pop(g);
    }

    protected void processLayerEvent(LayerEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        Iterator i = this.layersFromFront();
        while (i.hasNext()) {
            CanvasLayer layer = (CanvasLayer)i.next();
            if (!(layer instanceof EventAcceptor)) continue;
            EventAcceptor acceptor = (EventAcceptor)((Object)layer);
            event.setLayerSource(layer);
            acceptor.dispatchEvent(event);
            if (!event.isConsumed()) continue;
            break;
        }
    }

    public void repaint() {
        if (this._canvas != null) {
            this._canvas.repaint();
        } else if (this._parent != null) {
            this._parent.repaint();
        }
    }

    public void repaint(DamageRegion d) {
        d.checkCacheValid(this._transformContext);
        if (this._canvas != null) {
            this._canvas.repaint(d);
        } else if (this._parent != null) {
            this._parent.repaint(d);
        }
    }

    public void setAntialiasing(boolean val) {
        this._antialias = val;
    }

    public void setCanvas(JCanvas canvas) {
        if (canvas != null && this._parent != null) {
            throw new IllegalArgumentException("Canvas pane cannot have a canvas as its parent is not null");
        }
        this._canvas = canvas;
    }

    public void setEnabled(boolean flag) {
        this._enabled = flag;
    }

    public void setParent(CanvasComponent parent) {
        if (parent != null && this._canvas != null) {
            throw new IllegalArgumentException("Canvas pane cannot have a parent as its canvas is not null");
        }
        if (this._transformContext != null) {
            this._transformContext.invalidateCache();
        }
        this._parent = parent;
    }

    public void setTransform(AffineTransform at) {
        this._transformContext.setTransform(at);
        this.repaint();
    }

    public void setSize(double width, double height) {
        this._paneSize = new Point2D.Double(width, height);
    }

    public void setSize(Point2D size) {
        this._paneSize = size;
    }

    public void translate(double x, double y) {
        this._transformContext.translate(x, y);
        this.repaint();
    }

    public void scale(double xcenter, double ycenter, double xscale, double yscale) {
        AffineTransform at = new AffineTransform();
        at.translate(xcenter, ycenter);
        at.scale(xscale, yscale);
        at.translate(-xcenter, -ycenter);
        this._transformContext.getTransform().preConcatenate(at);
        this._transformContext.invalidateCache();
        this.repaint();
    }

    protected void _initNewLayer(CanvasLayer l) {
        if (l._containingPane != null) {
            throw new IllegalArgumentException("Invalid layer");
        }
        l._containingPane = this;
    }

    protected void _nullifyLayer(CanvasLayer l) {
        if (l._containingPane != this) {
            throw new IllegalArgumentException("Invalid layer");
        }
        l._containingPane = null;
    }
}

