/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.event;

import diva.canvas.CanvasLayer;
import diva.canvas.Figure;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class LayerEvent
extends MouseEvent {
    private CanvasLayer _layerSource = null;
    private Figure _figureSource = null;
    private double _layerX;
    private double _layerY;
    private MouseEvent _backingEvent;

    public LayerEvent(MouseEvent e) {
        super(e.getComponent(), e.getID(), e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
        this._backingEvent = e;
        this._layerX = e.getX();
        this._layerY = e.getY();
    }

    public LayerEvent(MouseEvent e, int id) {
        super(e.getComponent(), id, e.getWhen(), e.getModifiers(), e.getX(), e.getY(), e.getClickCount(), e.isPopupTrigger());
        this._backingEvent = e;
        this._layerX = e.getX();
        this._layerY = e.getY();
    }

    public void consume() {
        super.consume();
        if (this._backingEvent != null) {
            this._backingEvent.consume();
        }
    }

    public CanvasLayer getLayerSource() {
        return this._layerSource;
    }

    public Figure getFigureSource() {
        return this._figureSource;
    }

    public Point2D getLayerPoint() {
        return new Point2D.Double(this._layerX, this._layerY);
    }

    public double getLayerX() {
        return this._layerX;
    }

    public double getLayerY() {
        return this._layerY;
    }

    public void setFigureSource(Figure figureSource) {
        this._figureSource = figureSource;
    }

    public void setLayerSource(CanvasLayer layerSource) {
        this._layerSource = layerSource;
    }

    public void setLayerPoint(Point2D point) {
        this._layerX = point.getX();
        this._layerY = point.getY();
    }

    public void setLayerX(double x) {
        this._layerX = x;
    }

    public void setLayerY(double y) {
        this._layerY = y;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.getClass().getName());
        result.append("[" + LayerEvent.idToString(this.getID()) + ",mods=" + LayerEvent.toString(this.getModifiers()) + ",figure=" + this.getFigureSource() + ",layer=(" + this._layerX + "," + this._layerY + ")" + "]");
        return result.toString();
    }

    public static String toString(int flags) {
        StringBuffer result = new StringBuffer();
        boolean sep = false;
        for (int i = 256; i > 0; i /= 2) {
            String s = LayerEvent.flagToString(i & flags);
            if (s == null) continue;
            if (sep) {
                result.append("|");
            }
            result.append(s);
            sep = true;
        }
        return result.toString();
    }

    private static String flagToString(int flag) {
        switch (flag) {
            case 16: {
                return "BUTTON1_MASK";
            }
            case 8: {
                return "BUTTON2_MASK";
            }
            case 4: {
                return "BUTTON3_MASK";
            }
            case 2: {
                return "CTRL_MASK";
            }
            case 1: {
                return "SHIFT_MASK";
            }
        }
        return null;
    }

    public static String idToString(int id) {
        switch (id) {
            case 501: {
                return "MOUSE_PRESSED";
            }
            case 506: {
                return "MOUSE_DRAGGED";
            }
            case 502: {
                return "MOUSE_RELEASED";
            }
            case 500: {
                return "MOUSE_CLICKED";
            }
            case 504: {
                return "MOUSE_ENTERED";
            }
            case 503: {
                return "MOUSE_MOVED";
            }
            case 505: {
                return "MOUSE_EXITED";
            }
        }
        return null;
    }

    public void transform(AffineTransform at) {
        Point2D.Double p = new Point2D.Double(this._layerX, this._layerY);
        at.transform(p, p);
        this._layerX = ((Point2D)p).getX();
        this._layerY = ((Point2D)p).getY();
    }
}

