/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class PaintedShape {
    private float[] _dashArray = null;
    private float _lineWidth = 1.0f;
    private Stroke _outlineStroke = null;
    public Composite composite = AlphaComposite.SrcOver;
    public Paint fillPaint = null;
    public Shape shape = null;
    public Paint outlinePaint = Color.black;

    public PaintedShape() {
        this.shape = null;
    }

    public PaintedShape(Shape s) {
        this.shape = s;
    }

    public Rectangle2D getBounds() {
        if (this._outlineStroke == null) {
            return this.shape.getBounds2D();
        }
        return this._outlineStroke.createStrokedShape(this.shape).getBounds2D();
    }

    public float getLineWidth() {
        return this._lineWidth;
    }

    public Stroke getStroke() {
        return this._outlineStroke;
    }

    public boolean hit(Rectangle2D r) {
        if (this.fillPaint != null) {
            return this.shape.intersects(r);
        }
        if (this.outlinePaint != null && this._outlineStroke != null) {
            return this.shape.intersects(r);
        }
        return false;
    }

    public void paint(Graphics2D g) {
        if (this.fillPaint != null && this.composite != null) {
            g.setPaint(this.fillPaint);
            g.setComposite(this.composite);
            g.fill(this.shape);
        }
        if (this._outlineStroke != null && this.outlinePaint != null) {
            g.setStroke(this._outlineStroke);
            g.setPaint(this.outlinePaint);
            g.setComposite(AlphaComposite.SrcOver);
            g.draw(this.shape);
        }
    }

    public void setDashArray(float[] dashArray) {
        this._dashArray = dashArray;
        if (this._outlineStroke instanceof BasicStroke) {
            BasicStroke s = (BasicStroke)this._outlineStroke;
            this._outlineStroke = new BasicStroke(this._lineWidth, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), this._dashArray, 0.0f);
        } else {
            this._outlineStroke = new BasicStroke(this._lineWidth, 2, 0, 10.0f, this._dashArray, 0.0f);
        }
    }

    public void setLineWidth(float lineWidth) {
        this._lineWidth = lineWidth;
        if (this._outlineStroke instanceof BasicStroke) {
            BasicStroke s = (BasicStroke)this._outlineStroke;
            this._outlineStroke = new BasicStroke(lineWidth, s.getEndCap(), s.getLineJoin(), s.getMiterLimit(), this._dashArray, 0.0f);
        } else {
            this._outlineStroke = new BasicStroke(this._lineWidth, 2, 0, 10.0f, this._dashArray, 0.0f);
        }
    }

    public void setStroke(Stroke s) {
        this._outlineStroke = s;
        if (s instanceof BasicStroke) {
            this._lineWidth = ((BasicStroke)s).getLineWidth();
            this._dashArray = ((BasicStroke)s).getDashArray();
        } else {
            this._lineWidth = 1.0f;
            this._dashArray = null;
        }
    }
}

