/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.GlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.model.BasicGraphImpl;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphImpl;
import diva.graph.model.GraphUtilities;
import diva.graph.model.Node;
import diva.util.ArrayIterator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;

public class LevelLayout
implements GlobalLayout {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    private int _orientation = 0;
    private LayoutTarget _target;
    private Graph _origGraph;
    private Graph _copyGraph;
    private int _maxLevel = -1;
    private ArrayList[] _levels = null;
    private Node _meta = null;
    private GraphImpl _impl = null;

    public LevelLayout() {
        this(new BasicGraphImpl());
    }

    public LevelLayout(GraphImpl impl) {
        this._impl = impl;
    }

    protected Graph copyGraph(Graph origGraph, LayoutTarget target) {
        Graph copyGraph = this._impl.createGraph(null);
        Hashtable<Node, Node> map = new Hashtable<Node, Node>();
        Iterator i = origGraph.nodes();
        while (i.hasNext()) {
            Node origNode = (Node)i.next();
            if (!target.isNodeVisible(origNode)) continue;
            Rectangle2D r = target.getBounds(origNode);
            LevelInfo inf = new LevelInfo();
            inf.origNode = origNode;
            inf.x = r.getX();
            inf.y = r.getY();
            inf.width = r.getWidth();
            inf.height = r.getHeight();
            Node copyNode = this._impl.createNode(inf);
            this._impl.addNode(copyNode, copyGraph);
            map.put(origNode, copyNode);
        }
        i = origGraph.nodes();
        while (i.hasNext()) {
            Node origTail = (Node)i.next();
            Iterator j = origTail.outEdges();
            while (j.hasNext()) {
                Edge origEdge = (Edge)j.next();
                Node origHead = origEdge.getHead();
                if (origHead == null) continue;
                Node copyTail = (Node)map.get(origTail);
                Node copyHead = (Node)map.get(origHead);
                if (copyHead == null || copyTail == null) continue;
                Edge copyEdge = this._impl.createEdge(origEdge);
                this._impl.setEdgeTail(copyEdge, copyTail);
                this._impl.setEdgeHead(copyEdge, copyHead);
            }
        }
        return copyGraph;
    }

    protected void copyLayout(Graph copyGraph, LayoutTarget target) {
        Iterator ns = copyGraph.nodes();
        while (ns.hasNext()) {
            Edge e;
            Node copyNode = (Node)ns.next();
            LevelInfo inf = this.getLevelInfo(copyNode);
            this.ASSERT(inf != null, "null inf");
            if (inf.origNode == null) continue;
            Rectangle2D r = target.getBounds(inf.origNode);
            this.ASSERT(r != null, "null rect");
            target.translate(inf.origNode, inf.x - r.getX(), inf.y - r.getY());
            Iterator i = inf.origNode.inEdges();
            while (i.hasNext()) {
                e = (Edge)i.next();
                if (!target.isEdgeVisible(e)) continue;
                target.route(e);
            }
            i = inf.origNode.outEdges();
            while (i.hasNext()) {
                e = (Edge)i.next();
                if (!target.isEdgeVisible(e)) continue;
                target.route(e);
            }
        }
    }

    public int getOrientation() {
        return this._orientation;
    }

    public void layout(LayoutTarget t, Graph g) {
        this._origGraph = g;
        this._target = t;
        if (g.getNodeCount() > 0) {
            this._copyGraph = this.copyGraph(g, t);
            this.breakCycles(this._copyGraph);
            this.doLayout();
            this.copyLayout(this._copyGraph, t);
            this.cleanupStructures();
        }
    }

    public void setOrientation(int o) {
        if (o != 0 && o != 1) {
            String err = "Orientation must be either VERTICAL or HORIZONTAL";
            throw new IllegalArgumentException(err);
        }
        this._orientation = o;
    }

    private void ASSERT(boolean b, String err) throws RuntimeException {
        if (!b) {
            throw new RuntimeException(err);
        }
    }

    private void doLayout() {
        int lvl2;
        Node n2;
        Iterator j;
        int lvl;
        Node n;
        this.computeLevels();
        Iterator i = this._copyGraph.nodes();
        while (i.hasNext()) {
            n = (Node)i.next();
            lvl = this.getLevel(n);
            j = GraphUtilities.inNodes(n);
            while (j.hasNext()) {
                n2 = (Node)j.next();
                lvl2 = this.getLevel(n2);
                this.ASSERT(lvl2 < lvl, "Level order error " + n + ", " + n2);
            }
        }
        this.ASSERT(LayoutUtilities.checkContainment(this._copyGraph, this._target), "Inconsistent post-computeLevels");
        this.addDummies();
        i = this._copyGraph.nodes();
        while (i.hasNext()) {
            n = (Node)i.next();
            lvl = this.getLevel(n);
            j = GraphUtilities.inNodes(n);
            while (j.hasNext()) {
                n2 = (Node)j.next();
                lvl2 = this.getLevel(n2);
                this.ASSERT(lvl2 == lvl - 1, "Level equality error " + n + ", " + n2);
            }
        }
        i = this._copyGraph.nodes();
        while (i.hasNext()) {
            n = (Node)i.next();
            if (!this.isDummy(n)) continue;
            Iterator outs = n.outEdges();
            this.ASSERT(outs.hasNext(), "Dummy w/ no out-edges");
            outs.next();
            this.ASSERT(!outs.hasNext(), "Dummy w/ multiple out edges");
            Iterator ins = n.inEdges();
            this.ASSERT(ins.hasNext(), "Dummy w/ no in edges");
            ins.next();
            this.ASSERT(!ins.hasNext(), "Dummy w/ multiple in edges");
        }
        this.ASSERT(LayoutUtilities.checkContainment(this._copyGraph, this._target), "Inconsistent post-addDummies");
        this.makeLevels();
        for (int i2 = 1; i2 < this._levels.length; ++i2) {
            ArrayList nodes = this._levels[i2];
            this.ASSERT(nodes.size() != 0, "Empty level " + i2);
        }
        this.ASSERT(LayoutUtilities.checkContainment(this._copyGraph, this._target), "Inconsistent post-makeLevels");
        Rectangle2D r = this._target.getViewport(this._origGraph);
        this.placeNodes(r);
    }

    private boolean isCyclic(Graph g) {
        Iterator i = g.nodes();
        while (i.hasNext()) {
            Node root = (Node)i.next();
            GraphUtilities.setAllVisited(g, false);
            if (!this.checkCyclic(root)) continue;
            return true;
        }
        return false;
    }

    private void breakCycles(Graph g) {
        boolean hasCycles = true;
        block0: while (hasCycles) {
            hasCycles = false;
            Iterator i = g.nodes();
            while (i.hasNext()) {
                Node root = (Node)i.next();
                GraphUtilities.setAllVisited(g, false);
                if (!this.checkAndBreak(null, root)) continue;
                hasCycles = true;
                continue block0;
            }
        }
    }

    private boolean checkAndBreak(Edge e, Node n) {
        this.ASSERT(n != null, "null tail: " + n);
        if (n.isVisited()) {
            this.ASSERT(e != null, "null incoming edge: " + n);
            this.debug("BROKEN CYCLE AT: " + n);
            Node h = e.getHead();
            Node t = e.getTail();
            this._impl.setEdgeHead(e, t);
            this._impl.setEdgeTail(e, h);
            return true;
        }
        n.setVisited(true);
        Iterator i = n.outEdges();
        while (i.hasNext()) {
            Edge outEdge = (Edge)i.next();
            Node outNode = outEdge.getHead();
            this.ASSERT(outNode != null, "null head: " + e);
            if (!this.checkAndBreak(outEdge, outNode)) continue;
            return true;
        }
        n.setVisited(false);
        return false;
    }

    private boolean checkCyclic(Node n) {
        this.ASSERT(n != null, "null tail: " + n);
        if (n.isVisited()) {
            return true;
        }
        n.setVisited(true);
        Iterator i = n.outEdges();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            Node out = e.getHead();
            this.ASSERT(out != null, "null head: " + e);
            if (!this.checkCyclic(out)) continue;
            return true;
        }
        n.setVisited(false);
        return false;
    }

    private void cleanupStructures() {
        this._target = null;
        this._copyGraph = null;
        this._maxLevel = -1;
        ArrayIterator i = new ArrayIterator(this._levels);
        while (i.hasNext()) {
            ArrayList l = (ArrayList)i.next();
            l.clear();
        }
        this._levels = null;
        this._meta = null;
    }

    private void addDummies() {
        ArrayList<Node> dummies = new ArrayList<Node>();
        Iterator nodes = this._copyGraph.nodes();
        while (nodes.hasNext()) {
            Node to = (Node)nodes.next();
            if (this.isDummy(to)) continue;
            LevelInfo nlinfo = this.getLevelInfo(to);
            Iterator in = to.inEdges();
            while (in.hasNext()) {
                Edge e = (Edge)in.next();
                if (this.isDummy(e.getTail())) continue;
                while (this.getLevel(to) > this.getLevel(e.getTail()) + 1) {
                    LevelInfo dumInfo = new LevelInfo();
                    Node dummy = this._impl.createNode(dumInfo);
                    dumInfo.level = this.getLevel(e.getTail()) + 1;
                    dummies.add(dummy);
                    this._impl.setEdgeHead(e, dummy);
                    e = this._impl.createEdge(null);
                    this._impl.setEdgeTail(e, dummy);
                    this._impl.setEdgeHead(e, to);
                }
            }
        }
        Iterator i = dummies.iterator();
        while (i.hasNext()) {
            this._impl.addNode((Node)i.next(), this._copyGraph);
        }
    }

    private void debug(String s) {
        System.err.println(s);
    }

    private void makeLevels() {
        this._maxLevel = -1;
        Node maxNode = null;
        Iterator e = this._copyGraph.nodes();
        while (e.hasNext()) {
            Node n = (Node)e.next();
            int level = this.getLevel(n);
            if (level <= this._maxLevel) continue;
            this._maxLevel = level;
            maxNode = n;
        }
        this._levels = new ArrayList[this._maxLevel + 1];
        for (int i = 0; i < this._maxLevel + 1; ++i) {
            this._levels[i] = new ArrayList();
        }
        GraphUtilities.setAllVisited(this._copyGraph, false);
        this.initialOrderNodes(maxNode);
    }

    private void initialOrderNodes(Node maxNode) {
        this.addSubGraphReverseDFS(maxNode);
        Iterator e = this._copyGraph.nodes();
        while (e.hasNext()) {
            Node n = (Node)e.next();
            if (n.isVisited()) continue;
            this.addSubGraphReverseDFS(n);
        }
    }

    private void addSubGraphReverseDFS(Node n) {
        n.setVisited(true);
        Iterator ins = GraphUtilities.inNodes(n);
        while (ins.hasNext()) {
            Node in = (Node)ins.next();
            this.ASSERT(in != null, "NULL found, n = " + n);
            if (in.isVisited()) continue;
            this.addSubGraphReverseDFS(in);
        }
        this._levels[this.getLevel(n)].add(n);
    }

    private void placeNodes(Rectangle2D vp) {
        int nonEmptyLevels = 0;
        ArrayIterator i = new ArrayIterator(this._levels);
        while (i.hasNext()) {
            ArrayList nodes = (ArrayList)i.next();
            if (nodes.size() <= 0) continue;
            ++nonEmptyLevels;
        }
        nonEmptyLevels = Math.max(1, nonEmptyLevels);
        if (this.getOrientation() == 0) {
            double ystep = vp.getHeight() / (double)(nonEmptyLevels - 1);
            double y = vp.getY();
            ArrayIterator i2 = new ArrayIterator(this._levels);
            while (i2.hasNext()) {
                ArrayList nodes = (ArrayList)i2.next();
                double xstep = vp.getWidth() / (double)(nodes.size() - 1);
                double x = vp.getX();
                if (nodes.size() == 0) continue;
                if (nodes.size() == 1) {
                    x += vp.getWidth() / 2.0;
                }
                Iterator ns = nodes.iterator();
                while (ns.hasNext()) {
                    Node n = (Node)ns.next();
                    if (!this.isDummy(n)) {
                        this.placeNode(n, x, y);
                    }
                    x += xstep;
                }
                y += ystep;
            }
        } else {
            double xstep = vp.getWidth() / (double)(nonEmptyLevels - 1);
            double x = vp.getX();
            ArrayIterator i3 = new ArrayIterator(this._levels);
            while (i3.hasNext()) {
                ArrayList nodes = (ArrayList)i3.next();
                double ystep = vp.getHeight() / (double)(nodes.size() - 1);
                double y = vp.getY();
                if (nodes.size() == 0) continue;
                if (nodes.size() == 1) {
                    y += vp.getHeight() / 2.0;
                }
                Iterator ns = nodes.iterator();
                while (ns.hasNext()) {
                    Node n = (Node)ns.next();
                    if (!this.isDummy(n)) {
                        LevelInfo inf = this.getLevelInfo(n);
                        this.placeNode(n, x, y);
                    }
                    y += ystep;
                }
                x += xstep;
            }
        }
    }

    private void placeNode(Node n, double x, double y) {
        LevelInfo inf = this.getLevelInfo(n);
        inf.x = (x += Math.random() * 0.25 * inf.width) - inf.width / 2.0;
        inf.y = (y += Math.random() * 0.25 * inf.height) - inf.height / 2.0;
    }

    private double getX(Node n) {
        return this._target.getBounds(n).getX();
    }

    private LevelInfo getLevelInfo(Node n) {
        return (LevelInfo)n.getSemanticObject();
    }

    private int getLevel(Node n) {
        return this.getLevelInfo((Node)n).level;
    }

    private void setLevel(Node n, int l) {
        this.getLevelInfo((Node)n).level = l;
    }

    private int getUsage(Node n) {
        return this.getLevelInfo((Node)n).usage;
    }

    private boolean isDummy(Node n) {
        LevelInfo inf = this.getLevelInfo(n);
        return inf.origNode == null;
    }

    private void setUsage(Node n, int val) {
        this.getLevelInfo((Node)n).usage = val;
    }

    private void topoSort(Node n, ArrayList topo) {
        n.setVisited(true);
        Iterator e = GraphUtilities.inNodes(n);
        while (e.hasNext()) {
            Node n2 = (Node)e.next();
            if (n2.isVisited()) continue;
            this.topoSort(n2, topo);
        }
        topo.add(n);
    }

    private void makeMeta() {
        this._meta = this._impl.createNode(new LevelInfo());
        Iterator ns = this._copyGraph.nodes();
        while (ns.hasNext()) {
            Node n = (Node)ns.next();
            Edge e = this._impl.createEdge(null);
            this._impl.setEdgeTail(e, n);
            this._impl.setEdgeHead(e, this._meta);
        }
        this._impl.addNode(this._meta, this._copyGraph);
    }

    private void removeMeta() {
        GraphUtilities.purgeNode(this._impl, this._meta);
        this._meta = null;
    }

    private void computeLevels() {
        GraphUtilities.setAllVisited(this._copyGraph, false);
        this.makeMeta();
        ArrayList topo = new ArrayList();
        this.topoSort(this._meta, topo);
        int maxLevel = 0;
        Iterator e = topo.iterator();
        while (e.hasNext()) {
            int level = 0;
            Node n = (Node)e.next();
            Iterator ins = GraphUtilities.inNodes(n);
            while (ins.hasNext()) {
                Node in = (Node)ins.next();
                level = Math.max(level, this.getLevel(in) + 1);
            }
            this.setLevel(n, level);
            maxLevel = Math.max(maxLevel, level);
        }
        for (int i = topo.size() - 1; i >= 0; --i) {
            Node n = (Node)topo.get(i);
            int usage = maxLevel;
            if (!n.outEdges().hasNext()) {
                usage = this.getLevel(n);
            }
            Iterator outs = GraphUtilities.outNodes(n);
            while (outs.hasNext()) {
                Node out = (Node)outs.next();
                usage = Math.min(usage, this.getUsage(out) - 1);
            }
            this.setUsage(n, usage);
        }
        e = topo.iterator();
        while (e.hasNext()) {
            Node n = (Node)e.next();
            this.setLevel(n, this.getUsage(n));
        }
        this.removeMeta();
    }

    private static class LevelInfo {
        public Node origNode = null;
        public double barycenter;
        public int level = -1;
        public int usage = Integer.MAX_VALUE;
        public double x;
        public double y;
        public double width;
        public double height;

        private LevelInfo() {
        }
    }
}

