/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.layout;

import diva.graph.layout.GlobalLayout;
import diva.graph.layout.LayoutTarget;
import diva.graph.layout.LayoutUtilities;
import diva.graph.model.Graph;
import diva.graph.model.Node;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class RandomLayout
implements GlobalLayout {
    private static final int NUM_ITER = 10;

    public void layout(LayoutTarget target, Graph g) {
        Iterator ns = g.nodes();
        block0: while (ns.hasNext()) {
            Node n = (Node)ns.next();
            if (!target.isNodeVisible(n)) continue;
            Rectangle2D vp = target.getViewport(g);
            Rectangle2D bounds = target.getBounds(n);
            for (int i = 0; i < 10; ++i) {
                double x = vp.getX() + Math.abs(Math.random()) * vp.getWidth();
                double y = vp.getY() + Math.abs(Math.random()) * vp.getHeight();
                LayoutUtilities.place(target, n, x, y);
                bounds = target.getBounds(n);
                boolean overlap = false;
                Iterator j = target.intersectingNodes(bounds);
                while (j.hasNext()) {
                    Node n2 = (Node)j.next();
                    if (n == n2) continue;
                    overlap = false;
                }
                if (!overlap) continue block0;
            }
        }
    }
}

