/*
 * Decompiled with CFR 0.152.
 */
package diva.graph.model;

import diva.graph.model.BasicCompositeNode;
import diva.graph.model.BasicEdge;
import diva.graph.model.BasicGraph;
import diva.graph.model.BasicNode;
import diva.graph.model.CompositeNode;
import diva.graph.model.Edge;
import diva.graph.model.Graph;
import diva.graph.model.GraphException;
import diva.graph.model.GraphImpl;
import diva.graph.model.Node;

public class BasicGraphImpl
implements GraphImpl {
    public final void addNode(Node n, Graph parent) {
        BasicNode bn = (BasicNode)n;
        if (parent instanceof BasicCompositeNode) {
            ((BasicCompositeNode)parent).add(bn);
        } else {
            ((BasicGraph)parent).add(bn);
        }
    }

    public CompositeNode createCompositeNode(Object semanticObject) {
        BasicCompositeNode n = new BasicCompositeNode();
        n.setSemanticObject(semanticObject);
        return n;
    }

    public final Node createNode(Object semanticObject) {
        BasicNode n = new BasicNode();
        n.setSemanticObject(semanticObject);
        return n;
    }

    public final Graph createGraph(Object semanticObject) {
        BasicGraph g = new BasicGraph();
        g.setSemanticObject(semanticObject);
        return g;
    }

    public final Edge createEdge(Object semanticObject) {
        BasicEdge e = new BasicEdge();
        e.setSemanticObject(semanticObject);
        return e;
    }

    public final void removeNode(Node n) {
        BasicNode bn = (BasicNode)n;
        Graph parent = n.getParent();
        if (parent == null) {
            String err = "Trying to remove node with no parent";
            throw new GraphException(err);
        }
        if (parent instanceof BasicCompositeNode) {
            ((BasicCompositeNode)parent).delete(bn);
        } else {
            ((BasicGraph)parent).delete(bn);
        }
    }

    public final void setEdgeHead(Edge e, Node head) {
        BasicEdge be = (BasicEdge)e;
        BasicNode bh = (BasicNode)head;
        be.setHead(bh);
    }

    public final void setEdgeTail(Edge e, Node tail) {
        BasicEdge be = (BasicEdge)e;
        BasicNode bt = (BasicNode)tail;
        be.setTail(bt);
    }
}

