/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import diva.util.java2d.PaintedObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class PaintedPath
implements PaintedObject {
    private static BasicStroke[] _strokes = new BasicStroke[16];
    public Stroke stroke;
    public Shape shape;
    public Paint strokePaint = Color.black;

    public PaintedPath(Shape s) {
        this.shape = s;
        this.stroke = PaintedPath.getStroke(1);
    }

    public PaintedPath(Shape s, float lineWidth) {
        this.shape = s;
        this.stroke = PaintedPath.getStroke(lineWidth);
    }

    public Rectangle2D getBounds() {
        return this.stroke.createStrokedShape(this.shape).getBounds2D();
    }

    public float[] getDashArray() {
        if (this.stroke instanceof BasicStroke) {
            return ((BasicStroke)this.stroke).getDashArray();
        }
        return null;
    }

    public float getLineWidth() {
        if (this.stroke instanceof BasicStroke) {
            return ((BasicStroke)this.stroke).getLineWidth();
        }
        return 1.0f;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public static BasicStroke getStroke(int width) {
        if (width < _strokes.length) {
            if (_strokes[width] == null) {
                PaintedPath._strokes[width] = new BasicStroke(width);
            }
            return _strokes[width];
        }
        return new BasicStroke(width);
    }

    public static BasicStroke getStroke(float floatwidth) {
        int width = Math.round(floatwidth);
        if ((float)width == floatwidth) {
            return PaintedPath.getStroke(width);
        }
        return new BasicStroke(floatwidth);
    }

    public boolean hit(Rectangle2D r) {
        return this.shape.intersects(r);
    }

    public void paint(Graphics2D g) {
        g.setStroke(this.stroke);
        g.setPaint(this.strokePaint);
        g.draw(this.shape);
    }

    public void setDashArray(float[] dashArray) {
        this.stroke = this.stroke instanceof BasicStroke ? new BasicStroke(((BasicStroke)this.stroke).getLineWidth(), ((BasicStroke)this.stroke).getEndCap(), ((BasicStroke)this.stroke).getLineJoin(), ((BasicStroke)this.stroke).getMiterLimit(), dashArray, 0.0f) : new BasicStroke(1.0f, 2, 0, 10.0f, dashArray, 0.0f);
    }

    public void setLineWidth(float lineWidth) {
        if (this.stroke instanceof BasicStroke) {
            this.stroke = new BasicStroke(lineWidth, ((BasicStroke)this.stroke).getEndCap(), ((BasicStroke)this.stroke).getLineJoin(), ((BasicStroke)this.stroke).getMiterLimit(), ((BasicStroke)this.stroke).getDashArray(), 0.0f);
        } else {
            new BasicStroke(lineWidth, 2, 0, 10.0f, null, 0.0f);
        }
    }

    public void setStroke(Stroke s) {
        this.stroke = s;
    }
}

