/*
 * Decompiled with CFR 0.152.
 */
package diva.util.java2d;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.RectangularShape;

public final class ShapeUtilities {
    private static boolean _jdk12beta4 = System.getProperty("java.version").equals("1.2beta4");

    public static boolean jdk12beta4() {
        return _jdk12beta4;
    }

    public static Shape createCloudShape() {
        if (ShapeUtilities.jdk12beta4()) {
            Area area = new Area();
            Ellipse2D.Double c = new Ellipse2D.Double();
            ((RectangularShape)c).setFrame(0.0, 25.0, 50.0, 50.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(25.0, 0.0, 40.0, 40.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(25.0, 25.0, 60.0, 60.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(60.0, 30.0, 40.0, 40.0);
            area.add(new Area(c));
            ((RectangularShape)c).setFrame(60.0, 10.0, 30.0, 30.0);
            area.add(new Area(c));
            return area;
        }
        GeneralPath cloud = new GeneralPath();
        cloud.moveTo(25.538464f, 25.00469f);
        cloud.curveTo(25.184881f, 23.423826f, 25.0f, 21.750202f, 25.0f, 20.0f);
        cloud.curveTo(25.0f, 8.284271f, 33.28427f, 0.0f, 45.0f, 0.0f);
        cloud.curveTo(54.65201f, 0.0f, 61.974987f, 5.6227827f, 64.25538f, 14.15479f);
        cloud.curveTo(66.904045f, 11.533722f, 70.63438f, 10.0f, 75.0f, 10.0f);
        cloud.curveTo(83.7868f, 10.0f, 90.0f, 16.213203f, 90.0f, 25.0f);
        cloud.curveTo(90.0f, 27.463652f, 89.51156f, 29.724985f, 88.6149f, 31.703773f);
        cloud.curveTo(95.573074f, 34.705032f, 100.0f, 41.43567f, 100.0f, 50.0f);
        cloud.curveTo(100.0f, 61.218895f, 92.40346f, 69.2912f, 81.47162f, 69.95567f);
        cloud.curveTo(76.58594f, 79.21437f, 66.99121f, 85.0f, 55.0f, 85.0f);
        cloud.curveTo(45.0158f, 85.0f, 36.693f, 80.98901f, 31.366493f, 74.301926f);
        cloud.curveTo(29.357918f, 74.760185f, 27.228626f, 75.0f, 25.0f, 75.0f);
        cloud.curveTo(10.355339f, 75.0f, 0.0f, 64.64466f, 0.0f, 50.0f);
        cloud.curveTo(0.0f, 35.35534f, 10.355339f, 25.0f, 25.0f, 25.0f);
        cloud.curveTo(25.180141f, 25.0f, 25.359632f, 25.001566f, 25.538464f, 25.00469f);
        cloud.closePath();
        return cloud;
    }

    public static Shape createSwatchShape() {
        if (ShapeUtilities.jdk12beta4()) {
            GeneralPath p = new GeneralPath();
            p.moveTo(10.0f, 30.0f);
            p.quadTo(30.0f, 10.0f, 85.0f, 15.0f);
            BasicStroke str = new BasicStroke(35.0f, 0, 1);
            Shape s = str.createStrokedShape(p);
            AffineTransform at = new AffineTransform();
            at.translate(5.0, 25.0);
            Area area = new Area(s);
            s = at.createTransformedShape(s);
            area.add(new Area(s));
            s = at.createTransformedShape(s);
            area.add(new Area(s));
            return area;
        }
        GeneralPath swatch = new GeneralPath();
        swatch.moveTo(32.374367f, 92.37437f);
        swatch.curveTo(24.124788f, 84.12479f, 15.87521f, 75.87521f, 7.6256313f, 67.62563f);
        swatch.curveTo(10.937775f, 64.32453f, 14.69013f, 61.410217f, 18.8827f, 58.882698f);
        swatch.curveTo(13.463676f, 53.463676f, 8.044654f, 48.044655f, 2.6256313f, 42.625633f);
        swatch.curveTo(5.9377747f, 39.324528f, 9.69013f, 36.410217f, 13.882699f, 33.882698f);
        swatch.curveTo(8.463676f, 28.463676f, 3.0446541f, 23.044653f, -2.3743687f, 17.625631f);
        swatch.curveTo(6.805437f, 8.476419f, 19.366758f, 2.2983806f, 35.309593f, -0.9084854f);
        swatch.curveTo(43.932903f, -2.6328802f, 53.64258f, -3.4950776f, 64.438614f, -3.4950776f);
        swatch.curveTo(71.37162f, -3.4950776f, 78.75264f, -3.1395109f, 86.58167f, -2.4283772f);
        swatch.curveTo(85.84244f, 5.7172503f, 85.103195f, 13.862878f, 84.36396f, 22.008507f);
        swatch.curveTo(86.726f, 22.161398f, 89.131905f, 22.349104f, 91.58167f, 22.571623f);
        swatch.curveTo(90.84244f, 30.71725f, 90.103195f, 38.86288f, 89.36396f, 47.008507f);
        swatch.curveTo(91.726f, 47.1614f, 94.131905f, 47.349106f, 96.58167f, 47.571625f);
        swatch.curveTo(95.52722f, 59.19054f, 94.47278f, 70.809456f, 93.41833f, 82.428375f);
        swatch.curveTo(86.57177f, 81.805336f, 80.21641f, 81.49381f, 74.35225f, 81.49381f);
        swatch.curveTo(65.95863f, 81.49381f, 58.57135f, 82.132034f, 52.190407f, 83.408485f);
        swatch.curveTo(43.1497f, 85.19281f, 36.544353f, 88.181435f, 32.374367f, 92.37437f);
        swatch.closePath();
        return swatch;
    }

    public static String printShapeAsCode(String name, Shape shape) {
        StringBuffer s = new StringBuffer();
        PathIterator p = shape.getPathIterator(null);
        float[] data = new float[6];
        s.append("GeneralPath " + name + " = new GeneralPath();\n");
        while (!p.isDone()) {
            int type = p.currentSegment(data);
            switch (type) {
                case 4: {
                    s.append(name + ".closePath();");
                    break;
                }
                case 0: {
                    s.append(name + ".moveTo(");
                    s.append(data[0] + "f, ");
                    s.append(data[1] + "f);\n");
                    break;
                }
                case 1: {
                    s.append(name + ".lineTo(");
                    s.append(data[0] + "f, ");
                    s.append(data[1] + "f);\n");
                    break;
                }
                case 2: {
                    s.append(name + ".quadTo(");
                    s.append(data[0] + "f, ");
                    s.append(data[1] + "f, ");
                    s.append(data[2] + "f, ");
                    s.append(data[3] + "f);\n");
                    break;
                }
                case 3: {
                    s.append(name + ".curveTo(");
                    s.append(data[0] + "f, ");
                    s.append(data[1] + "f, ");
                    s.append(data[2] + "f, ");
                    s.append(data[3] + "f, ");
                    s.append(data[4] + "f, ");
                    s.append(data[5] + "f);\n");
                }
            }
            p.next();
        }
        s.append(name + ".closePath();");
        return s.toString();
    }

    public static void main(String[] argv) {
        if (ShapeUtilities.jdk12beta4()) {
            System.out.println(ShapeUtilities.printShapeAsCode("cloud", ShapeUtilities.createCloudShape()));
            System.out.println(ShapeUtilities.printShapeAsCode("swatch", ShapeUtilities.createSwatchShape()));
        }
    }
}

