/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.FigureLayer;
import diva.graph.GraphPane;
import diva.graph.GraphView;
import diva.graph.model.GraphModel;
import fsa.FSAGUIProxy;
import fsa.FSAGraphController;
import fsa.FSAPanel;
import fsa.StateCreator;
import fsa.StateRenderer;
import fsa.SymbolDialog;
import fsa.TransitionRenderer;
import fsa.machine.StateMachine;

public class FSAGraphPane
extends GraphPane {
    private FigureLayer _animationLayer;
    private StateMachine _machine;
    private FSAPanel _fsaPanel;

    public FSAGraphPane(StateMachine machine, SymbolDialog dialog, FSAPanel fsaPanel) {
        super(new GraphModel(), new FSAGraphController(machine, dialog));
        this._nullifyLayer(this.getOverlayLayer());
        this._animationLayer = new FigureLayer();
        this._initNewLayer(this._animationLayer);
        this._layers.set(1, this._animationLayer);
        this._machine = machine;
        this._fsaPanel = fsaPanel;
        GraphView gv = this.getGraphView();
        gv.setEdgeRenderer(new TransitionRenderer());
        gv.setNodeRenderer(new StateRenderer());
        FSAGraphController controller = (FSAGraphController)this.getGraphController();
        controller.setFSAGraphPane(this);
        FSAGUIProxy fgp = new FSAGUIProxy(controller);
        machine.addStateListener(fgp);
        machine.addTransitionListener(fgp);
        this.getForegroundLayer().setPickHalo(0.5);
        this.getBackgroundEventLayer().addInteractor(new StateCreator(machine, this));
    }

    public FigureLayer getAnimationLayer() {
        return this._animationLayer;
    }

    public void stateCountChanged() {
        this._fsaPanel.updateStatesAndString();
    }
}

