/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.FigureLayer;
import diva.canvas.toolbox.BasicEllipse;
import diva.canvas.toolbox.BasicFigure;
import fsa.AnimationPath;
import fsa.StateFigure;
import fsa.machine.State;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class FigureMover {
    AnimationPath _path;
    double _height;
    double _width;
    BasicFigure _figure = new BasicEllipse(0.0, 0.0, 20.0, 20.0, Color.red);
    FigureLayer _layer;
    State _state;

    public FigureMover() {
        Rectangle2D bounds = this._figure.getBounds();
        this._height = bounds.getHeight();
        this._width = bounds.getWidth();
        this._layer = null;
        this._state = null;
    }

    public void setPath(AnimationPath ap) {
        this._path = ap;
    }

    public boolean isDone() {
        return this._path.isDone();
    }

    public void step() {
        if (!this._path.isDone()) {
            Rectangle2D bounds = this._figure.getBounds();
            Point2D newP = this._path.next();
            double newX = newP.getX() - this._width / 2.0;
            double newY = newP.getY() - this._height / 2.0;
            this._figure.translate(newX - bounds.getX(), newY - bounds.getY());
        }
    }

    void setLocation(StateFigure stateFigure) {
        Rectangle2D stateBounds = stateFigure.getEllipseBounds();
        Rectangle2D figBounds = this._figure.getBounds();
        double relX = (stateBounds.getWidth() - figBounds.getWidth()) / 2.0;
        double relY = (stateBounds.getHeight() - figBounds.getHeight()) / 2.0;
        this._figure.translate(-figBounds.getX(), -figBounds.getY());
        this._figure.translate(stateBounds.getX() + relX, stateBounds.getY() + relY);
    }

    void setLayer(FigureLayer layer) {
        this._layer = layer;
    }

    FigureLayer getLayer() {
        return this._layer;
    }

    void attach() {
        if (this._layer != null) {
            this._layer.add(this._figure);
        }
    }

    void detach() {
        if (this._layer != null) {
            this._layer.remove(this._figure);
        }
    }

    void setState(State state) {
        this._state = state;
    }

    State getState() {
        return this._state;
    }

    void setColor(Color color) {
        this._figure.setFillPaint(color);
    }

    void demote() {
        this._layer.setIndex(this._layer.getFigureCount() - 1, this._figure);
    }
}

