/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasComponent;
import diva.canvas.CanvasPane;
import diva.canvas.CanvasUtilities;
import diva.canvas.JCanvas;
import diva.util.java2d.PaintedShape;
import fsa.Colors;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class StateFigure
extends AbstractFigure {
    private PaintedShape _outsideEllipse;
    private PaintedShape _insideEllipse;
    private double _spacing = 4.0;
    private PaintedShape _initialTail = null;
    private TextLayout _label;
    private double _labelx;
    private double _labely;
    private int _stringPortion = 6;
    private int _touchCount = 0;
    private int _loopPortion = 5;
    private int _stateType = 35;
    public static final int NORMAL_STATE = 35;
    public static final int INITIAL_STATE = 36;
    public static final int FINAL_STATE = 37;
    public static final int INITIAL_FINAL_STATE = 38;

    public StateFigure(double x, double y, double width, double height) {
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, width, height);
        this._outsideEllipse = new PaintedShape(s);
        this._label = null;
    }

    public StateFigure(double x, double y, double width, double height, Paint fill) {
        Ellipse2D.Double s = new Ellipse2D.Double(x, y, width, height);
        this._outsideEllipse = new PaintedShape(s, fill);
        this._label = null;
    }

    public Rectangle2D getBounds() {
        if (this._initialTail != null) {
            return this._outsideEllipse.getBounds().createUnion(this._initialTail.getBounds());
        }
        return this._outsideEllipse.getBounds();
    }

    public Rectangle2D getEllipseBounds() {
        return this._outsideEllipse.getBounds();
    }

    public Shape getShape() {
        return this._outsideEllipse.shape;
    }

    public int getStateType() {
        return this._stateType;
    }

    public Stroke getStroke() {
        return this._outsideEllipse.getStroke();
    }

    public Paint getStrokePaint() {
        return this._outsideEllipse.strokePaint;
    }

    public boolean hit(Rectangle2D r) {
        if (!this.isVisible()) {
            return false;
        }
        return this._outsideEllipse.hit(r);
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        this._outsideEllipse.paint(g);
        switch (this._stateType) {
            case 38: {
                this._initialTail.paint(g);
                this._insideEllipse.paint(g);
                break;
            }
            case 37: {
                this._insideEllipse.paint(g);
                break;
            }
            case 36: {
                this._initialTail.paint(g);
            }
        }
        if (this._label != null) {
            this._label.draw(g, (float)this._labelx, (float)this._labely);
        }
    }

    public void setFillPaint(Paint p) {
        this._outsideEllipse.fillPaint = p;
        if (this._insideEllipse != null) {
            this._insideEllipse.fillPaint = p;
        }
        if (this._initialTail != null) {
            this._initialTail.fillPaint = p;
        }
        this.repaint();
    }

    public void setStroke(BasicStroke s) {
        this.repaint();
        this._outsideEllipse.stroke = s;
        if (this._insideEllipse != null) {
            this._insideEllipse.stroke = s;
        }
        if (this._initialTail != null) {
            this._initialTail.stroke = s;
        }
        this.repaint();
    }

    public void setStateType(int type) {
        this.repaint();
        this._stateType = type;
        switch (type) {
            case 35: {
                break;
            }
            case 37: {
                if (this._insideEllipse != null) break;
                Rectangle2D bounds = this._outsideEllipse.getBounds();
                Ellipse2D.Double s = new Ellipse2D.Double(bounds.getX() + this._spacing, bounds.getY() + this._spacing, bounds.getWidth() - 2.0 * this._spacing, bounds.getHeight() - 2.0 * this._spacing);
                this._insideEllipse = new PaintedShape(s);
                break;
            }
            case 36: {
                if (this._initialTail != null) break;
                Rectangle2D bounds = this._outsideEllipse.getBounds();
                GeneralPath tailPath = new GeneralPath();
                tailPath.moveTo((float)bounds.getX() - 5.0f, (float)(bounds.getY() + bounds.getHeight() / 2.0 - 5.0));
                tailPath.lineTo((float)bounds.getX(), (float)(bounds.getY() + bounds.getHeight() / 2.0));
                tailPath.lineTo((float)bounds.getX() - 5.0f, (float)(bounds.getY() + bounds.getHeight() / 2.0 + 5.0));
                this._initialTail = new PaintedShape(tailPath);
                break;
            }
            case 38: {
                Rectangle2D bounds = this._outsideEllipse.getBounds();
                if (this._insideEllipse == null) {
                    Ellipse2D.Double s = new Ellipse2D.Double(bounds.getX() + this._spacing, bounds.getY() + this._spacing, bounds.getWidth() - 2.0 * this._spacing, bounds.getHeight() - 2.0 * this._spacing);
                    this._insideEllipse = new PaintedShape(s);
                }
                if (this._initialTail != null) break;
                GeneralPath tailPath = new GeneralPath();
                tailPath.moveTo((float)bounds.getX() - 5.0f, (float)(bounds.getY() + bounds.getHeight() / 2.0 - 5.0));
                tailPath.lineTo((float)bounds.getX(), (float)(bounds.getY() + bounds.getHeight() / 2.0));
                tailPath.lineTo((float)bounds.getX() - 5.0f, (float)(bounds.getY() + bounds.getHeight() / 2.0 + 5.0));
                this._initialTail = new PaintedShape(tailPath);
                break;
            }
        }
        this.repaint();
    }

    public void setLabelString(String labelText) {
        if (labelText != null && labelText.length() != 0) {
            CanvasComponent parent = this.getParent();
            while (!(parent instanceof CanvasPane)) {
                parent = parent.getParent();
            }
            JCanvas canvas = ((CanvasPane)parent).getCanvas();
            Graphics2D g = (Graphics2D)canvas.getGraphics();
            Font font = canvas.getFont().deriveFont(10.0f);
            FontRenderContext frc = g.getFontRenderContext();
            this._label = new TextLayout(labelText, font, frc);
            Rectangle2D bounds = this._outsideEllipse.getBounds();
            Rectangle2D labelBounds = this._label.getBounds();
            this._labelx = bounds.getX() + bounds.getWidth() / 2.0 - labelBounds.getWidth() / 2.0;
            this._labely = bounds.getY() + bounds.getHeight() / 2.0 + labelBounds.getHeight() / 2.0;
        } else {
            this._label = null;
        }
        this.repaint();
    }

    protected void updateColors() {
        this.setStrokePaint(Colors.getClassificationColor(this._stringPortion, this._touchCount, this._loopPortion));
        this.setStroke(new BasicStroke(Colors.getClassificationWidth(this._stringPortion, this._touchCount, this._loopPortion)));
        this.repaint();
    }

    public void resetTouchCount() {
        this._touchCount = 0;
        this.updateColors();
    }

    public void touch() {
        ++this._touchCount;
        this.updateColors();
    }

    public void setStringPortion(int portion) {
        if (!Colors.canOverwrite(portion, this._stringPortion)) {
            return;
        }
        this._stringPortion = portion;
        this.updateColors();
    }

    public void setLoopPortion(int loopPortion) {
        if (!Colors.canOverwriteLoop(loopPortion, this._loopPortion)) {
            return;
        }
        this._loopPortion = loopPortion;
        this.updateColors();
    }

    public void setStrokePaint(Paint p) {
        this._outsideEllipse.strokePaint = p;
        if (this._insideEllipse != null) {
            this._insideEllipse.strokePaint = p;
        }
        if (this._initialTail != null) {
            this._initialTail.strokePaint = p;
        }
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._outsideEllipse.shape = CanvasUtilities.transform(this._outsideEllipse.shape, at);
        if (this._insideEllipse != null) {
            this._insideEllipse.shape = CanvasUtilities.transform(this._insideEllipse.shape, at);
        }
        if (this._initialTail != null) {
            this._initialTail.shape = CanvasUtilities.transform(this._initialTail.shape, at);
        }
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        this._outsideEllipse.shape = CanvasUtilities.translate(this._outsideEllipse.shape, x, y);
        if (this._insideEllipse != null) {
            this._insideEllipse.shape = CanvasUtilities.translate(this._insideEllipse.shape, x, y);
        }
        if (this._initialTail != null) {
            this._initialTail.shape = CanvasUtilities.translate(this._initialTail.shape, x, y);
        }
        this._labelx += x;
        this._labely += y;
        this.repaint();
    }
}

