/*
 * Decompiled with CFR 0.152.
 */
package fsa;

import fsa.Colors;
import fsa.SymbolSet;
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class Tape
extends JComponent
implements MouseListener,
MouseMotionListener,
KeyListener,
AncestorListener,
ComponentListener {
    private int _x;
    private int _y;
    private AudioClip _symbolTyped;
    private AudioClip _headMoved;
    private AudioClip _headHomed;
    private boolean _input;
    private boolean _leftLimited;
    private Color tapeColor;
    private Color selColor;
    private Color bColor;
    private Color _selectColor;
    private Color _selBackground;
    private Font _symbolFont;
    private Font _labelFont;
    private FontMetrics _lfm;
    private FontMetrics _sfm;
    private Vector _tapeSymbols;
    private int _cells;
    private int _cellWidth;
    private int _head;
    private int _homeCell;
    private int _leftmost;
    private int _maxLocation;
    private int _minLocation;
    private int _start;
    private int _width;
    private Polygon _leftHead;
    private Polygon _rightHead;
    private SymbolSet _allowedSymbols;
    private ImageIcon _headImage;
    private boolean _displayClassification = true;
    private final int TAPE_HEIGHT = 60;
    private final int CLASSIFICATION_HEIGHT = 22;
    private char[] _classification;
    private TapeListener[] _listeners = new TapeListener[0];
    private SelectListener[] _selectListeners = new SelectListener[0];
    static final int NO_SELECTION = 0;
    static final int LOOP_SELECTION = 1;
    static final int PUMP_SELECTION = 2;
    private int _selectionType = 0;
    private int _uLength = 0;
    private int _vLength = -1;
    private int _selectStart = 0;
    private int _selectEnd = -1;
    private boolean _inDrag = false;
    private int _dragStart;
    private int _dragStop;

    public Tape(boolean input) {
        this._input = input;
        this._allowedSymbols = null;
        this.bColor = new Color(233, 240, 251);
        this.tapeColor = new Color(255, 255, 255);
        this.selColor = new Color(255, 255, 0);
        this._selectColor = Color.white;
        this._selBackground = new Color(208, 208, 208);
        this._tapeSymbols = new Vector();
        this._symbolFont = new Font("Helvetica", 1, 14);
        this._labelFont = new Font("Helvetica", 1, 8);
        this._headImage = new ImageIcon(this.getClass().getResource("/images/head.gif"));
        this._leftLimited = false;
        this._leftmost = 0;
        this._start = this._homeCell = 0;
        this._head = this._homeCell;
        this._minLocation = this._homeCell;
        this._maxLocation = this._homeCell - 1;
        try {
            this._symbolTyped = Applet.newAudioClip(this.getClass().getResource("/sounds/TypeKey.au"));
            this._headMoved = Applet.newAudioClip(this.getClass().getResource("/sounds/TypeSpace.au"));
            this._headHomed = Applet.newAudioClip(this.getClass().getResource("/sounds/TypeReturn.au"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setAutoscrolls(true);
        this.setDoubleBuffered(true);
        if (this._input) {
            this.addKeyListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.requestFocus();
        }
        this.addAncestorListener(this);
        this.addComponentListener(this);
    }

    public void addTapeListener(TapeListener tapeListener) {
        TapeListener[] oldList = this._listeners;
        this._listeners = new TapeListener[oldList.length + 1];
        for (int i = 0; i < oldList.length; ++i) {
            this._listeners[i] = oldList[i];
        }
        this._listeners[oldList.length] = tapeListener;
    }

    public void addSelectListener(SelectListener selectListener) {
        SelectListener[] oldList = this._selectListeners;
        this._selectListeners = new SelectListener[oldList.length + 1];
        for (int i = 0; i < oldList.length; ++i) {
            this._selectListeners[i] = oldList[i];
        }
        this._selectListeners[oldList.length] = selectListener;
    }

    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this._head < this._start) {
            this._start = this._head;
        } else if (this._head >= this._start + this._cells - 2) {
            this._start = this._head - this._cells + 2;
        }
        g.setColor(Color.black);
        g.fillRect(0, 0, this._width, 60);
        g.setColor(this.tapeColor);
        g.fillRect(0, 10, this._width, 20);
        g.setColor(Color.black);
        g.drawLine(0, 10, this._width, 10);
        g.drawLine(0, 30, this._width, 30);
        if (this._displayClassification) {
            g.setColor(Color.black);
            g.fillRect(0, 60, this._width, 22);
            g.setColor(this._selBackground);
            g.fillRect(0, 61, this._width, 20);
            g.setColor(Color.black);
        }
        int xloc = 0;
        int pos = this._start;
        int dragBegin = Math.min(this._dragStart, this._dragStop);
        int dragEnd = Math.max(this._dragStart, this._dragStop);
        for (int i = 0; i < this._cells; ++i) {
            g.drawLine(xloc, 10, xloc, 30);
            if (pos == this._head) {
                g.setColor(new Color(39, 165, 0));
            } else {
                g.setColor(Color.gray);
            }
            g.setFont(this._labelFont);
            String labelString = String.valueOf(pos);
            int labelWidth = this._lfm.stringWidth(labelString);
            int labelStart = xloc + 1 + (this._cellWidth - labelWidth) / 2;
            if (pos % 2 == 0) {
                g.drawString(labelString, labelStart, 7);
                g.drawLine(xloc + this._cellWidth / 2, 9, xloc + this._cellWidth / 2, 8);
            } else {
                g.drawString(labelString, labelStart, 40);
                g.drawLine(xloc + this._cellWidth / 2, 31, xloc + this._cellWidth / 2, 32);
            }
            Character symbol = this.getSymbolAt(pos);
            if (symbol != null) {
                g.setFont(this._symbolFont);
                g.setColor(new Color(39, 165, 0));
                int symbolWidth = this._sfm.charWidth(symbol.charValue());
                int symbolStart = xloc + 1 + (this._cellWidth - symbolWidth) / 2;
                g.drawString(symbol.toString(), symbolStart, 26);
            }
            if (this._displayClassification && this._classification != null && pos < this._classification.length && symbol != null && !this._inDrag && this._selectionType != 1) {
                boolean lineEnd;
                char classification = this._classification[pos];
                g.setColor(Colors.getClassificationColor(classification, 0, 0));
                boolean lineStart = pos - 1 < 0 || this._classification[pos - 1] != classification;
                boolean bl = lineEnd = pos + 1 >= this._classification.length || this._classification[pos + 1] != classification;
                if (lineStart) {
                    g.drawString("" + classification, xloc + 3, 74);
                    g.fillRect(xloc, 61, 2, 21);
                }
                if (lineEnd) {
                    g.fillRect(xloc + this._cellWidth - 2, 61, 2, 21);
                }
                g.fillRect(xloc, 80, this._cellWidth, 2);
            }
            if (this._displayClassification && (this._inDrag && dragBegin <= pos && pos <= dragEnd || !this._inDrag && this._selectStart <= pos && pos <= this._selectEnd)) {
                g.setColor(this._selectColor);
                g.fillRect(xloc, 61, this._cellWidth, 20);
            }
            xloc += this._cellWidth;
            ++pos;
            g.setColor(Color.black);
        }
        int headPos = (this._head - this._start) * this._cellWidth + (this._cellWidth - this._headImage.getIconWidth()) / 2;
        this._headImage.paintIcon(this, g, headPos, 27);
        if (this._input) {
            this.requestFocus();
        }
    }

    public void setClassificationList(char[] classification) {
        this._classification = classification;
        this.repaint();
    }

    public void setSelectionType(int selectionType) {
        this._selectionType = selectionType;
    }

    public int getNumberOfSymbolsOnTape() {
        return this._maxLocation - this._minLocation + 1;
    }

    public int getULength() {
        return this._uLength;
    }

    public void setULength(int uLength) {
        this._uLength = uLength;
        for (int i = 0; i < this._listeners.length; ++i) {
            this._listeners[i].classificationModified();
        }
    }

    public int getVLength() {
        int leftover = this.getNumberOfSymbolsOnTape() - this.getULength();
        if (this._vLength < 0) {
            return leftover;
        }
        return Math.min(this._vLength, leftover);
    }

    public void setVLength(int vLength) {
        this._vLength = vLength;
        for (int i = 0; i < this._listeners.length; ++i) {
            this._listeners[i].classificationModified();
        }
    }

    public int getSelectStart() {
        return this._selectStart;
    }

    public int getSelectEnd() {
        return this._selectEnd;
    }

    public Character getSymbolAt(int index) {
        if (index < this._minLocation || index > this._maxLocation) {
            return null;
        }
        return (Character)this._tapeSymbols.elementAt(index - this._minLocation);
    }

    public char[] getSymbolsOnTape() {
        char[] retValue = new char[this.getNumberOfSymbolsOnTape()];
        for (int i = this._minLocation; i <= this._maxLocation; ++i) {
            retValue[i] = this.getSymbolAt(i).charValue();
        }
        return retValue;
    }

    public Character getSymbolAtHead() {
        return this.getSymbolAt(this.getHeadPosition());
    }

    public void setSymbolAt(char symbol, int index) {
        this.setSymbolAt(new Character(symbol), index);
    }

    public void setSymbolAt(Character symbol, int index) {
        this.setClassificationList(null);
        if (this._tapeSymbols.size() == 0) {
            this._minLocation = index;
            this._maxLocation = index;
            this._tapeSymbols.addElement(symbol);
        } else if (index < this._minLocation) {
            this._minLocation = index;
            this._tapeSymbols.insertElementAt(symbol, 0);
        } else if (index > this._maxLocation) {
            this._maxLocation = index;
            this._tapeSymbols.addElement(symbol);
        } else {
            this._tapeSymbols.setElementAt(symbol, index - this._minLocation);
        }
        for (int i = 0; i < this._listeners.length; ++i) {
            this._listeners[i].stringModified();
        }
    }

    public int getHeadPosition() {
        return this._head;
    }

    public void setHeadPosition(int head) {
        this._head = head;
        this.repaint();
    }

    public void setTape(SymbolSet allowedSymbols, String symbols, int headPos, int min) {
        int i;
        this._allowedSymbols = allowedSymbols;
        this._tapeSymbols.clear();
        for (i = 0; i < symbols.length(); ++i) {
            this.setSymbolAt(symbols.charAt(i), min + i);
        }
        this.setHeadPosition(headPos);
        for (i = 0; i < this._listeners.length; ++i) {
            this._listeners[i].stringModified();
        }
        this.repaint();
    }

    public void clear() {
        this._tapeSymbols.clear();
        this._start = this._homeCell = 0;
        this._head = this._homeCell;
        this._minLocation = this._homeCell;
        this._maxLocation = this._homeCell - 1;
        this.setClassificationList(null);
        this.repaint();
        for (int i = 0; i < this._listeners.length; ++i) {
            this._listeners[i].stringModified();
        }
    }

    public void setAllowedSymbols(SymbolSet allowedSymbols) {
        this._allowedSymbols = allowedSymbols;
    }

    public void setLeftLimited(boolean leftLimited) {
        this._leftLimited = leftLimited;
        if (this._leftmost > this._head) {
            this._head = this._leftmost;
        }
        if (this._leftmost > this._start) {
            this._start = this._leftmost;
        }
        this.repaint();
    }

    public void setLeftmost(int leftmost) {
        this._leftmost = leftmost;
        if (this._leftLimited) {
            if (this._leftmost > this._head) {
                this._head = this._leftmost;
            }
            if (this._leftmost > this._start) {
                this._start = this._leftmost;
            }
            this.repaint();
        }
    }

    public void moveHeadHome() {
        if (this._head != this._homeCell) {
            this._head = this._homeCell;
            this._headHomed.play();
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (Exception except) {
                except.printStackTrace();
            }
            this.repaint();
        }
    }

    public void moveHeadRight() {
        ++this._head;
        this._headMoved.play();
        this.repaint();
    }

    int getIndexFromX(int x) {
        return this._start + x / this._cellWidth;
    }

    public void mousePressed(MouseEvent event) {
        int x = event.getX();
        int y = event.getY();
        int index = this.getIndexFromX(x);
        if (this.isEnabled() && y >= 10 && y <= 30 && index <= this._maxLocation + 1) {
            this._head = index;
            this.repaint();
        }
        if (this.isEnabled() && y >= 60 && this._displayClassification && this._selectionType != 0) {
            this._inDrag = true;
            this._dragStart = index;
            this._dragStop = index;
            if (this._selectionType == 1) {
                for (int i = 0; i < this._selectListeners.length; ++i) {
                    this._selectListeners[i].selectionStarted();
                }
            }
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent event) {
        if (this._inDrag) {
            int x = event.getX();
            int y = event.getY();
            this._inDrag = false;
            this._dragStop = this.getIndexFromX(x);
            System.out.println("Drag from: " + this._dragStart + " to " + this._dragStop);
            int dragBegin = Math.min(this._dragStart, this._dragStop) - this._start;
            int dragEnd = Math.max(this._dragStart, this._dragStop) - this._start;
            int lastSymbol = this.getNumberOfSymbolsOnTape() - 1;
            switch (this._selectionType) {
                case 2: {
                    this._uLength = dragBegin;
                    this._vLength = dragEnd > this.getNumberOfSymbolsOnTape() ? -1 : dragEnd - dragBegin + 1;
                    for (int i = 0; i < this._listeners.length; ++i) {
                        this._listeners[i].classificationModified();
                    }
                    break;
                }
                case 1: {
                    this._selectStart = Math.min(dragBegin, lastSymbol);
                    this._selectEnd = Math.min(dragEnd, lastSymbol);
                    for (int i = 0; i < this._selectListeners.length; ++i) {
                        this._selectListeners[i].selectionEnded();
                    }
                    break;
                }
            }
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this._input) {
            this.requestFocus();
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this._input) {
            this.requestFocus();
        }
    }

    public void mouseDragged(MouseEvent event) {
        if (this._inDrag) {
            int x = event.getX();
            int y = event.getY();
            this._dragStop = this.getIndexFromX(x);
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent e) {
        if (this._input) {
            this.requestFocus();
        }
    }

    public void keyTyped(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        if (this._input) {
            this.requestFocus();
        }
        char key = e.getKeyChar();
        if (this._allowedSymbols == null || this._allowedSymbols.contains(key)) {
            this.setSymbolAt(key, this._head);
            ++this._head;
            this._symbolTyped.play();
            this.repaint();
        } else if (key == '@') {
            this.getToolkit().beep();
        }
    }

    public void keyPressed(KeyEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int key = e.getKeyCode();
        if (key == 39) {
            if (this._head <= this._maxLocation) {
                this.moveHeadRight();
            }
        } else if (key == 37) {
            if (!this._leftLimited || this._head > this._leftmost) {
                --this._head;
                this._headMoved.play();
                this.repaint();
            }
        } else if (key == 36) {
            this.moveHeadHome();
        } else if (key == 34) {
            this._head += this._cells - 1;
            if (this._head > this._maxLocation + 1) {
                this._head = this._maxLocation;
            }
            this.repaint();
        } else if (key == 33) {
            this._head -= this._cells - 1;
            if (this._leftLimited && this._head < this._leftmost) {
                this._head = this._leftmost;
            }
            this.repaint();
        } else if (key == 8 && this._head > this._minLocation) {
            this._tapeSymbols.removeElementAt(this._head - this._minLocation - 1);
            --this._head;
            --this._maxLocation;
            for (int i = 0; i < this._listeners.length; ++i) {
                this._listeners[i].stringModified();
            }
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void ancestorAdded(AncestorEvent event) {
        Graphics g = this.getGraphics();
        if (g != null) {
            this._width = this.getWidth();
            this._lfm = g.getFontMetrics(this._labelFont);
            this._sfm = g.getFontMetrics(this._symbolFont);
            this._cellWidth = this._sfm.charWidth('W') + 1;
            this._cells = (int)Math.round(Math.ceil((double)this._width / (double)this._cellWidth));
            this._leftHead = new Polygon();
            this._leftHead.addPoint(0, 39);
            this._leftHead.addPoint(this._cellWidth / 2, 39);
            this._leftHead.addPoint(this._cellWidth / 2, 27);
            this._rightHead = new Polygon();
            this._rightHead.addPoint(this._cellWidth, 39);
            this._rightHead.addPoint(this._cellWidth / 2, 27);
            this._rightHead.addPoint(this._cellWidth / 2, 39);
        }
    }

    public void ancestorMoved(AncestorEvent event) {
    }

    public void ancestorRemoved(AncestorEvent event) {
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this._width = this.getWidth();
        this._cells = (int)Math.round(Math.ceil((double)this._width / (double)this._cellWidth));
    }

    public void componentShown(ComponentEvent e) {
    }

    public Dimension getPreferredSize() {
        if (this._displayClassification) {
            return new Dimension(100, 82);
        }
        return new Dimension(100, 60);
    }

    public void showClassification(boolean show) {
        this._displayClassification = show;
    }

    public void setSelectColor(Color color) {
        this._selectColor = color;
        this.repaint();
    }

    public static interface SelectListener {
        public void selectionEnded();

        public void selectionStarted();
    }

    public static interface TapeListener {
        public void stringModified();

        public void classificationModified();
    }
}

