/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas;

import diva.canvas.BasicZList;
import diva.canvas.CanvasComponent;
import diva.canvas.CanvasLayer;
import diva.canvas.CanvasPane;
import diva.canvas.CanvasUtilities;
import diva.canvas.DamageRegion;
import diva.canvas.Figure;
import diva.canvas.FigureContainer;
import diva.canvas.FigureDecorator;
import diva.canvas.TransformContext;
import diva.canvas.ZList;
import diva.canvas.event.EventAcceptor;
import diva.canvas.event.LayerEvent;
import diva.canvas.interactor.Interactor;
import java.awt.AWTEvent;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;

public class FigureLayer
extends CanvasLayer
implements FigureContainer,
EventAcceptor {
    private ZList _zlist = null;
    private double _pickHalo = 0.5;
    private boolean _visible = true;
    private boolean _enabled = true;
    private Figure _pointerGrabber = null;

    public FigureLayer() {
        this._zlist = new BasicZList();
    }

    public FigureLayer(CanvasPane pane) {
        super(pane);
        this._zlist = new BasicZList();
    }

    public FigureLayer(CanvasPane pane, ZList zlist) {
        super(pane);
        this._zlist = zlist;
    }

    public FigureLayer(ZList zlist) {
        this._zlist = zlist;
    }

    public void add(Figure f) {
        this._zlist.add(0, f);
        f.setParent(this);
        this.repaint(f.getBounds());
    }

    public void add(int index, Figure f) {
        this._zlist.add(index, f);
        f.setParent(this);
        this.repaint(f.getBounds());
    }

    public void decorate(Figure child, FigureDecorator decorator) {
        if (child.getParent() != this) {
            throw new IllegalArgumentException("Not a child");
        }
        child.repaint();
        decorator.setParent(this);
        decorator.setChild(child);
        this._zlist.set(this._zlist.indexOf(child), decorator);
        decorator.repaint();
    }

    public boolean contains(Figure f) {
        return this._zlist.contains(f);
    }

    public Iterator figures() {
        return this._zlist.figures();
    }

    public Iterator figuresFromBack() {
        return this._zlist.figuresFromBack();
    }

    public Iterator figuresFromFront() {
        return this._zlist.figuresFromFront();
    }

    public Figure get(int index) {
        return this._zlist.get(index);
    }

    public int getFigureCount() {
        return this._zlist.getFigureCount();
    }

    public TransformContext getTransformContext() {
        if (this.getCanvasPane() != null) {
            return this.getCanvasPane().getTransformContext();
        }
        return null;
    }

    public ZList getFigures() {
        return this._zlist;
    }

    public double getPickHalo() {
        return this._pickHalo;
    }

    public void grabPointer(LayerEvent e, Figure f) {
        if (e.getID() != 501) {
            throw new IllegalArgumentException("Only mouse pressed events can grab the pointer (for now)");
        }
        this._pointerGrabber = f;
        if (f instanceof EventAcceptor) {
            ((EventAcceptor)((Object)f)).dispatchEvent(e);
        }
        if (!e.isConsumed()) {
            this.dispatchEventUpTree(f, e);
        }
    }

    public int indexOf(Figure f) {
        return this._zlist.indexOf(f);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public boolean isVisible() {
        return this._visible;
    }

    public void paint(Graphics2D g) {
        if (!this.isVisible()) {
            return;
        }
        Iterator i = this.figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g);
        }
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (!this.isVisible()) {
            return;
        }
        Iterator i = this._zlist.getIntersectedFigures(region).figuresFromBack();
        while (i.hasNext()) {
            Figure f = (Figure)i.next();
            f.paint(g, region);
        }
    }

    public Figure pick(Rectangle2D region) {
        return CanvasUtilities.pick(this._zlist.getIntersectedFigures(region).figuresFromFront(), region);
    }

    public void dispatchEvent(AWTEvent event) {
        if (!this.isEnabled()) {
            return;
        }
        switch (event.getID()) {
            case 500: 
            case 501: 
            case 502: 
            case 506: {
                this.processLayerEvent((LayerEvent)event);
                break;
            }
            case 503: 
            case 504: 
            case 505: {
                this.processLayerMotionEvent((LayerEvent)event);
                break;
            }
            default: {
                System.out.println("Bad event: " + event);
            }
        }
    }

    public void remove(Figure f) {
        this._zlist.remove(f);
        f.setParent(null);
        this.repaint(f.getBounds());
    }

    public void remove(int index) {
        Figure f = this._zlist.get(index);
        this._zlist.remove(index);
        f.setParent(null);
        this.repaint(f.getBounds());
    }

    public void setEnabled(boolean flag) {
        this._enabled = flag;
    }

    public void setPickHalo(double halo) {
        this._pickHalo = halo;
    }

    public void repaint(Rectangle2D region) {
        this.repaint(DamageRegion.createDamageRegion(this.getTransformContext(), region));
    }

    public void setIndex(int index, Figure f) {
        this._zlist.setIndex(index, f);
        this.repaint(f.getBounds());
    }

    public void setVisible(boolean flag) {
        this._visible = flag;
    }

    public void undecorate(FigureDecorator decorator) {
        if (decorator.getParent() != this) {
            throw new IllegalArgumentException("Not a child");
        }
        decorator.repaint();
        Figure child = decorator.getChild();
        this._zlist.set(this._zlist.indexOf(decorator), child);
        decorator.setChild(null);
        decorator.setParent(null);
        child.setParent(this);
        this.repaint();
    }

    private void dispatchEventUpTree(Figure f, LayerEvent e) {
        while (f != null) {
            CanvasComponent p;
            Interactor interactor = f.getInteractor();
            if (interactor != null) {
                e.setFigureSource(f);
                if (interactor.accept(e)) {
                    switch (e.getID()) {
                        case 506: {
                            interactor.mouseDragged(e);
                            break;
                        }
                        case 501: {
                            interactor.mousePressed(e);
                            break;
                        }
                        case 502: {
                            interactor.mouseReleased(e);
                        }
                    }
                }
            }
            if (e.isConsumed() || !((p = f.getParent()) instanceof Figure)) break;
            f = (Figure)p;
        }
    }

    private void dispatchMotionEventUpTree(Figure f, LayerEvent e) {
        while (f != null) {
            CanvasComponent p;
            Interactor interactor = f.getInteractor();
            if (interactor != null && interactor.isMotionEnabled()) {
                e.setFigureSource(f);
                if (interactor.accept(e)) {
                    switch (e.getID()) {
                        case 503: {
                            interactor.mouseMoved(e);
                            break;
                        }
                        case 505: {
                            interactor.mouseExited(e);
                            break;
                        }
                        case 504: {
                            interactor.mouseEntered(e);
                        }
                    }
                }
            }
            if (!((p = f.getParent()) instanceof Figure)) break;
            f = (Figure)p;
        }
    }

    protected void processLayerEvent(LayerEvent e) {
        int id = e.getID();
        e.setLayerSource(this);
        switch (id) {
            case 501: {
                double wh = this._pickHalo * 2.0;
                Rectangle2D.Double region = new Rectangle2D.Double(e.getLayerX() - this._pickHalo, e.getLayerY() - this._pickHalo, wh, wh);
                Figure f = this.pick(region);
                if (f == null) break;
                this._pointerGrabber = f;
                if (f instanceof EventAcceptor) {
                    ((EventAcceptor)((Object)f)).dispatchEvent(e);
                }
                if (e.isConsumed()) break;
                this.dispatchEventUpTree(f, e);
                break;
            }
            case 506: {
                Figure f = this._pointerGrabber;
                if (f == null) {
                    return;
                }
                if (f instanceof EventAcceptor) {
                    ((EventAcceptor)((Object)f)).dispatchEvent(e);
                }
                if (e.isConsumed()) break;
                this.dispatchEventUpTree(f, e);
                break;
            }
            case 502: {
                Figure f = this._pointerGrabber;
                if (f == null) {
                    return;
                }
                if (f instanceof EventAcceptor) {
                    ((EventAcceptor)((Object)f)).dispatchEvent(e);
                }
                if (!e.isConsumed()) {
                    this.dispatchEventUpTree(f, e);
                }
                this._pointerGrabber = null;
            }
        }
    }

    protected void processLayerMotionEvent(MouseEvent e) {
        LayerEvent le = (LayerEvent)e;
        double wh = this._pickHalo * 2.0;
        Rectangle2D.Double region = new Rectangle2D.Double(le.getLayerX() - this._pickHalo, le.getLayerY() - this._pickHalo, wh, wh);
        Figure f = this.pick(region);
        le.setLayerSource(this);
        if (!le.isConsumed()) {
            this.dispatchMotionEventUpTree(f, le);
        }
    }
}

