/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.connector;

import diva.canvas.AbstractSite;
import diva.canvas.Figure;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PerimeterSite
extends AbstractSite {
    private int _id;
    private double _normal;
    private Figure _parentFigure;

    public PerimeterSite(Figure figure, int id, double normal) {
        this._parentFigure = figure;
        this._id = id;
        this.setNormal(normal);
    }

    public Figure getFigure() {
        return this._parentFigure;
    }

    public int getID() {
        return this._id;
    }

    public Point2D getPoint() {
        Shape shape = this._parentFigure.getShape();
        Rectangle2D bounds = shape.getBounds2D();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double pi2 = 1.5707963267948966;
        double alpha = this._normal;
        double beta = pi2 - alpha;
        if (shape instanceof Ellipse2D) {
            double dy;
            double dx;
            double rx = width / 2.0;
            double ry = height / 2.0;
            if (Math.abs(width - height) < 0.001) {
                dx = rx * Math.cos(alpha);
                dy = ry * Math.sin(alpha);
            } else if (Math.abs(alpha - pi2) < 0.001) {
                dx = 0.0;
                dy = ry;
            } else if (Math.abs(alpha + pi2) < 0.001) {
                dx = 0.0;
                dy = ry;
            } else {
                double m = Math.tan(alpha);
                dx = rx * ry / Math.sqrt(ry * ry + rx * rx * m * m);
                if (alpha > pi2 || alpha < -pi2) {
                    dx = -dx;
                }
                dy = m * dx;
            }
            xout = x + rx + dx;
            yout = y + ry + dy;
        } else {
            double t;
            if (!(shape instanceof Rectangle2D)) {
                shape = bounds;
            }
            if (alpha < -pi + (t = Math.atan2(height, width)) || alpha > pi - t) {
                xout = x;
                yout = y + height / 2.0 - width / 2.0 * Math.tan(alpha);
            } else if (alpha < -t) {
                yout = y;
                xout = x + width / 2.0 - height / 2.0 * Math.tan(beta);
            } else if (alpha < t) {
                xout = x + width;
                yout = y + height / 2.0 + width / 2.0 * Math.tan(alpha);
            } else {
                yout = y + height;
                xout = x + width / 2.0 + height / 2.0 * Math.tan(beta);
            }
        }
        return new Point2D.Double(xout, yout);
    }

    public double getX() {
        return this.getPoint().getX();
    }

    public double getY() {
        return this.getPoint().getY();
    }

    public void setNormal(double normal) {
        if (normal == this._normal) {
            return;
        }
        while (normal > Math.PI) {
            normal -= Math.PI * 2;
        }
        while (normal < -Math.PI) {
            normal += Math.PI * 2;
        }
        this._normal = normal;
    }
}

