/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.CompositeFigure;
import diva.canvas.Figure;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class BackgroundedCompositeFigure
extends CompositeFigure {
    private Figure _background;

    public BackgroundedCompositeFigure() {
        this((Figure)null);
    }

    public BackgroundedCompositeFigure(Figure background) {
        this.setBackgroundFigure(background);
    }

    public void setBackgroundFigure(Figure background) {
        this._background = background;
    }

    public Figure getBackgroundFigure() {
        return this._background;
    }

    public Rectangle2D getBounds() {
        if (this._background == null) {
            return super.getBounds();
        }
        Rectangle2D r1 = super.getBounds();
        Rectangle2D r2 = this._background.getBounds();
        Rectangle2D.Double rout = new Rectangle2D.Double();
        Rectangle2D.union(r1, r2, rout);
        return rout;
    }

    public void paint(Graphics2D g) {
        if (this._background != null) {
            this._background.paint(g);
        }
        super.paint(g);
    }

    public void paint(Graphics2D g, Rectangle2D region) {
        if (this._background != null) {
            this._background.paint(g, region);
        }
        super.paint(g, region);
    }

    private void debug(String s) {
        System.err.println(s);
    }

    public Figure pick(Rectangle2D region) {
        double bh;
        double bw;
        double by;
        Rectangle2D bb;
        double bx;
        Figure f = super.pick(region);
        if (f != null) {
            return f;
        }
        if (this._background != null && region.intersects(bx = (bb = this._background.getBounds()).getX(), by = bb.getY(), bw = bb.getWidth(), bh = bb.getHeight())) {
            return this;
        }
        return null;
    }

    public void transform(AffineTransform at) {
        this.repaint();
        super.transform(at);
        if (this._background != null) {
            this._background.transform(at);
        }
        this.repaint();
    }

    public void translate(double x, double y) {
        this.repaint();
        super.translate(x, y);
        if (this._background != null) {
            this._background.translate(x, y);
        }
        this.repaint();
    }
}

