/*
 * Decompiled with CFR 0.152.
 */
package diva.canvas.toolbox;

import diva.canvas.AbstractFigure;
import diva.canvas.CanvasUtilities;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class LabelFigure
extends AbstractFigure {
    private String _string;
    private static Font _defaultFont = new Font("Serif", 0, 10);
    private Font _font;
    private Paint _fillPaint = Color.black;
    private AffineTransform _transform = new AffineTransform();
    private Shape _shape;
    private Rectangle2D _bounds;
    private double _padding = 4.0;
    private int _anchor = 0;
    private AffineTransform _translate = new AffineTransform();

    public LabelFigure() {
        this("");
    }

    public LabelFigure(String s) {
        this._string = s;
        this._font = _defaultFont;
        this.update();
    }

    public LabelFigure(String s, Font f) {
        this._string = s;
        this._font = f;
        this.update();
    }

    public LabelFigure(String s, String face, int style, int size) {
        this._string = s;
        this._font = new Font(face, style, size);
        this.update();
    }

    public void autoAnchor(Shape s) {
        Rectangle2D.Double r = new Rectangle2D.Double();
        r.setRect(this._bounds);
        if (!s.intersects(r)) {
            return;
        }
        int[] anchors = new int[]{5, 1, 7, 3, 6, 4, 8, 2};
        Point2D location = this.getAnchorPoint();
        for (int i = 0; i < anchors.length; ++i) {
            Point2D pt = CanvasUtilities.getLocation(r, anchors[i]);
            CanvasUtilities.translate(pt, this._padding, anchors[i]);
            r.x += location.getX() - pt.getX();
            r.y += location.getY() - pt.getY();
            if (s.intersects(r)) continue;
            this.setAnchor(anchors[i]);
            break;
        }
    }

    public int getAnchor() {
        return this._anchor;
    }

    public Point2D getAnchorPoint() {
        Point2D pt = CanvasUtilities.getLocation(this._bounds, this._anchor);
        if (this._anchor != 0) {
            CanvasUtilities.translate(pt, this._padding, this._anchor);
        }
        return pt;
    }

    public Rectangle2D getBounds() {
        return this._bounds;
    }

    public Font getFont() {
        return this._font;
    }

    public Paint getFillPaint() {
        return this._fillPaint;
    }

    public String getFontName() {
        return this._font.getFontName();
    }

    public double getPadding() {
        return this._padding;
    }

    public int getStyle() {
        return this._font.getStyle();
    }

    public int getSize() {
        return this._font.getSize();
    }

    public Shape getShape() {
        return this._bounds;
    }

    public String getString() {
        return this._string;
    }

    public void paint(Graphics2D g) {
        if (this.getString() != null) {
            g.transform(this._translate);
            g.setPaint(this._fillPaint);
            g.fill(this._shape);
            try {
                g.transform(this._translate.createInverse());
            }
            catch (NoninvertibleTransformException nte) {
                nte.printStackTrace();
            }
        }
    }

    public void setAnchor(int anchor) {
        Point2D oldpt = this.getAnchorPoint();
        this._anchor = anchor;
        Point2D newpt = this.getAnchorPoint();
        this.repaint();
        this._transform.translate(oldpt.getX() - newpt.getX(), oldpt.getY() - newpt.getY());
        this.update();
        this.repaint();
    }

    public void setFillPaint(Paint p) {
        this._fillPaint = p;
        this.repaint();
    }

    public void setFont(Font f) {
        this._font = f;
        Point2D pt = this.getAnchorPoint();
        this.repaint();
        this.update();
        this.translateTo(pt);
    }

    public void setFontName(String s) {
        this.setFont(new Font(s, this._font.getStyle(), this._font.getSize()));
    }

    public void setPadding(double padding) {
        this._padding = padding;
        this.setAnchor(this._anchor);
    }

    public void setStyle(int style) {
        this.setFont(new Font(this._font.getFontName(), style, this._font.getSize()));
    }

    public void setSize(int size) {
        this.setFont(new Font(this._font.getFontName(), this._font.getStyle(), size));
    }

    public void setString(String s) {
        this._string = s;
        Point2D pt = this.getAnchorPoint();
        this.repaint();
        this.update();
        this.translateTo(pt);
    }

    public void setTransform(AffineTransform at) {
        this.repaint();
        this.update();
        this.repaint();
    }

    public void transform(AffineTransform at) {
        this.repaint();
        this._transform.preConcatenate(at);
        this.update();
        this.repaint();
    }

    public void translateForce(double x, double y) {
        this._translate = new AffineTransform();
        this._translate.translate(x, y);
        this.update();
        this.repaint();
    }

    public void translateForce(Point2D pt) {
        this.translateForce(pt.getX(), pt.getY());
    }

    public void translateTo(double x, double y) {
        this.repaint();
        Point2D pt = this.getAnchorPoint();
        this._transform.translate(x - pt.getX(), y - pt.getY());
        this.update();
        this.repaint();
    }

    public void translateTo(Point2D pt) {
        this.translateTo(pt.getX(), pt.getY());
    }

    private void update() {
        FontRenderContext frc = new FontRenderContext(this._transform, true, false);
        GlyphVector gv = this._font.createGlyphVector(frc, this._string);
        this._bounds = gv.getVisualBounds();
        this._bounds.setRect(this._bounds.getX() + this._translate.getTranslateX(), this._bounds.getY() + this._translate.getTranslateY(), this._bounds.getWidth(), this._bounds.getHeight());
        this._shape = gv.getOutline();
    }
}

